/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.thread.SerializedExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Context Handler Collection")
public class ContextHandlerCollection
extends Handler.Collection {
    private static final Logger LOG = LoggerFactory.getLogger(ContextHandlerCollection.class);
    private final SerializedExecutor _serializedExecutor = new SerializedExecutor();

    public ContextHandlerCollection(ContextHandler ... contexts) {
        super(new Handler[0]);
        if (contexts.length > 0) {
            this.setHandlers(contexts);
        }
    }

    @ManagedOperation(value="Update the mapping of context path to context")
    public void mapContexts() {
        this._serializedExecutor.execute(() -> {
            List<Handler> handlers = this.getHandlers();
            if (handlers == null) {
                return;
            }
            super.setHandlers(this.newHandlers(handlers));
        });
    }

    @Override
    protected List<Handler> newHandlers(List<Handler> handlers) {
        if (handlers == null || handlers.size() == 0) {
            return Collections.emptyList();
        }
        HashMap<String, Branch[]> path2Branches = new HashMap<String, Branch[]>();
        for (Handler handler : handlers) {
            Branch branch = new Branch(handler);
            for (String contextPath : branch.getContextPaths()) {
                Object[] branches = (Branch[])path2Branches.get(contextPath);
                path2Branches.put(contextPath, (Branch[])ArrayUtil.addToArray((Object[])branches, (Object)branch, Branch.class));
            }
        }
        for (Map.Entry entry : path2Branches.entrySet()) {
            Branch[] branches = (Branch[])entry.getValue();
            Branch[] sorted = new Branch[branches.length];
            int i = 0;
            for (Branch branch : branches) {
                if (!branch.hasVirtualHost()) continue;
                sorted[i++] = branch;
            }
            for (Branch branch : branches) {
                if (branch.hasVirtualHost()) continue;
                sorted[i++] = branch;
            }
            entry.setValue(sorted);
        }
        Mapping mapping = new Mapping(handlers, path2Branches);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", mapping._pathBranches);
        }
        return mapping;
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        Map.Entry branches;
        List<Handler> handlers = this.getHandlers();
        if (handlers == null || handlers.isEmpty()) {
            return null;
        }
        if (!(handlers instanceof Mapping)) {
            return super.handle(request);
        }
        Mapping mapping = (Mapping)this.getHandlers();
        if (handlers.size() == 1) {
            return handlers.get(0).handle(request);
        }
        Index<Map.Entry<String, Branch[]>> pathBranches = mapping._pathBranches;
        if (pathBranches == null) {
            return null;
        }
        String path = Request.getPathInContext(request);
        if (!path.startsWith("/")) {
            super.handle(request);
            return null;
        }
        int limit = path.length() - 1;
        while (limit >= 0 && (branches = (Map.Entry)pathBranches.getBest(path, 1, limit)) != null) {
            int l = ((String)branches.getKey()).length();
            if (l == 1 || path.length() == l || path.charAt(l) == '/') {
                for (Branch branch : (Branch[])branches.getValue()) {
                    try {
                        Request.Processor processor = branch.getHandler().handle(request);
                        if (processor != null) {
                            return processor;
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn("Unaccepted error {}", (Object)this, (Object)t);
                    }
                }
            }
            limit = l - 2;
        }
        return null;
    }

    public void deployHandler(final Handler handler, final Callback callback) {
        this._serializedExecutor.execute((Runnable)new SerializedExecutor.ErrorHandlingTask(){

            public void run() {
                ContextHandlerCollection.this.addHandler(handler);
                callback.succeeded();
            }

            public void accept(Throwable throwable) {
                callback.failed(throwable);
            }
        });
    }

    public void undeployHandler(final Handler handler, final Callback callback) {
        this._serializedExecutor.execute((Runnable)new SerializedExecutor.ErrorHandlingTask(){

            public void run() {
                ContextHandlerCollection.this.removeHandler(handler);
                callback.succeeded();
            }

            public void accept(Throwable throwable) {
                callback.failed(throwable);
            }
        });
    }

    private static final class Branch {
        private final Handler _handler;
        private final List<ContextHandler> _contexts;

        Branch(Handler handler) {
            this._handler = handler;
            if (handler instanceof ContextHandler) {
                this._contexts = List.of((ContextHandler)handler);
            } else if (handler instanceof Handler.Container) {
                List<ContextHandler> contexts = ((Handler.Container)handler).getDescendants(ContextHandler.class);
                this._contexts = new ArrayList<ContextHandler>(contexts);
            } else {
                this._contexts = List.of();
            }
        }

        Set<String> getContextPaths() {
            HashSet<String> set = new HashSet<String>();
            for (ContextHandler context : this._contexts) {
                set.add(context.getContextPath());
            }
            return set;
        }

        boolean hasVirtualHost() {
            for (ContextHandler context : this._contexts) {
                if (context.getVirtualHosts() == null || context.getVirtualHosts().size() <= 0) continue;
                return true;
            }
            return false;
        }

        List<ContextHandler> getContextHandlers() {
            return this._contexts;
        }

        Handler getHandler() {
            return this._handler;
        }

        public String toString() {
            return String.format("{%s,%s}", this._handler, this._contexts);
        }
    }

    private static class Mapping
    extends ArrayList<Handler> {
        private final Map<ContextHandler, Handler> _contextBranches;
        private final Index<Map.Entry<String, Branch[]>> _pathBranches = new Index.Builder().caseSensitive(true).withAll(() -> {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : path2Branches.entrySet()) {
                result.put(((String)entry.getKey()).substring(1), entry);
            }
            return result;
        }).build();

        private Mapping(List<Handler> handlers, Map<String, Branch[]> path2Branches) {
            super(handlers);
            HashMap<ContextHandler, Handler> contextBranches = new HashMap<ContextHandler, Handler>();
            for (Branch[] branches : path2Branches.values()) {
                for (Branch branch : branches) {
                    for (ContextHandler context : branch.getContextHandlers()) {
                        contextBranches.put(context, branch.getHandler());
                    }
                }
            }
            this._contextBranches = Collections.unmodifiableMap(contextBranches);
        }
    }
}

