/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.function.Predicate;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextResponse;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextRequest
extends Request.WrapperProcessor
implements Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRequest.class);
    private final ContextHandler _contextHandler;
    private final ContextHandler.ScopedContext _context;

    protected ContextRequest(ContextHandler contextHandler, ContextHandler.ScopedContext context, Request wrapped) {
        super(wrapped);
        this._contextHandler = contextHandler;
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Request request, Response response, Callback callback) throws Exception {
        assert (this.getWrapped() == request);
        ContextResponse contextResponse = this.newContextResponse(this, response);
        ClassLoader lastLoader = this._contextHandler.enterScope(this);
        try {
            super.process(this, contextResponse, callback);
        }
        catch (Throwable t) {
            Response.writeError((Request)this, (Response)contextResponse, callback, t);
        }
        finally {
            this._contextHandler.exitScope(this, request.getContext(), lastLoader);
        }
    }

    protected ContextResponse newContextResponse(Request request, Response response) {
        return new ContextResponse(this._context, request, response);
    }

    @Override
    public void demand(Runnable demandCallback) {
        super.demand(() -> this._context.run(demandCallback, this));
    }

    @Override
    public boolean addErrorListener(Predicate<Throwable> onError) {
        return super.addErrorListener(t -> {
            this._context.accept(onError::test, (Throwable)t, this);
            return true;
        });
    }

    @Override
    public ContextHandler.ScopedContext getContext() {
        return this._context;
    }

    public Object getAttribute(String name) {
        return switch (name) {
            case "o.e.j.s.h.ScopedRequest.contextPath" -> this._context.getContextPath();
            case "o.e.j.s.h.ScopedRequest.pathInContext" -> Request.getPathInContext(this);
            default -> super.getAttribute(name);
        };
    }
}

