/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMappingsHandler
extends Handler.AbstractContainer {
    private static final Logger LOG = LoggerFactory.getLogger(PathMappingsHandler.class);
    private final PathMappings<Handler> mappings = new PathMappings();

    @Override
    public void addHandler(Handler handler) {
        throw new UnsupportedOperationException("Arbitrary addHandler() not supported, use addMapping() instead");
    }

    @Override
    public void addHandler(Supplier<Handler> supplier) {
        throw new UnsupportedOperationException("Arbitrary addHandler() not supported, use addMapping() instead");
    }

    @Override
    public List<Handler> getHandlers() {
        return this.mappings.streamResources().map(MappedResource::getResource).toList();
    }

    public void addMapping(PathSpec pathSpec, Handler handler) {
        Handler.Container container;
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot add mapping: " + String.valueOf(this));
        }
        if (handler == this || handler instanceof Handler.Container && (container = (Handler.Container)handler).getDescendants().contains(this)) {
            throw new IllegalStateException("Unable to addHandler of self: " + String.valueOf(handler));
        }
        for (MappedResource entry : this.mappings) {
            Handler.Container container2;
            Handler entryHandler = (Handler)entry.getResource();
            if (entryHandler != this && entryHandler != handler && (!(entryHandler instanceof Handler.Container) || !(container2 = (Handler.Container)entryHandler).getDescendants().contains(this))) continue;
            throw new IllegalStateException("addMapping loop detected: " + String.valueOf(handler));
        }
        this.mappings.put(pathSpec, (Object)handler);
        this.addBean(handler);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this.mappings});
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        String pathInContext = Request.getPathInContext(request);
        MatchedResource matchedResource = this.mappings.getMatched(pathInContext);
        if (matchedResource == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No match on pathInContext of {}", (Object)pathInContext);
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matched pathInContext of {} to {} -> {}", new Object[]{pathInContext, matchedResource.getPathSpec(), matchedResource.getResource()});
        }
        return ((Handler)matchedResource.getResource()).handle(request);
    }
}

