/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.List;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;

public class TryPathsHandler
extends Handler.Wrapper {
    private String originalPathAttribute;
    private String originalQueryAttribute;
    private List<String> paths;

    public String getOriginalPathAttribute() {
        return this.originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribute) {
        this.originalPathAttribute = originalPathAttribute;
    }

    public String getOriginalQueryAttribute() {
        return this.originalQueryAttribute;
    }

    public void setOriginalQueryAttribute(String originalQueryAttribute) {
        this.originalQueryAttribute = originalQueryAttribute;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        for (String path : this.paths) {
            String interpolated = this.interpolate(request, path);
            Request.WrapperProcessor result = new Request.WrapperProcessor(new TryPathsRequest(request, interpolated));
            Request.Processor childProcessor = super.handle(result);
            if (childProcessor == null) continue;
            return result.wrapProcessor(childProcessor);
        }
        return null;
    }

    private String interpolate(Request request, String value) {
        String path = Request.getPathInContext(request);
        return value.replace("$path", path);
    }

    private class TryPathsRequest
    extends Request.Wrapper {
        private final HttpURI _uri;

        public TryPathsRequest(Request wrapped, String newPathQuery) {
            String originalQueryAttribute;
            super(wrapped);
            HttpURI originalURI = wrapped.getHttpURI();
            String originalPathAttribute = TryPathsHandler.this.getOriginalPathAttribute();
            if (originalPathAttribute != null) {
                this.setAttribute(originalPathAttribute, Request.getPathInContext(wrapped));
            }
            if ((originalQueryAttribute = TryPathsHandler.this.getOriginalQueryAttribute()) != null) {
                this.setAttribute(originalQueryAttribute, originalURI.getQuery());
            }
            String originalContextPath = Request.getContextPath(wrapped);
            HttpURI.Mutable rewrittenURI = HttpURI.build((HttpURI)originalURI);
            int queryIdx = newPathQuery.indexOf(63);
            if (queryIdx >= 0) {
                String path = newPathQuery.substring(0, queryIdx);
                rewrittenURI.path(URIUtil.addPaths((String)originalContextPath, (String)path));
                rewrittenURI.query(newPathQuery.substring(queryIdx + 1));
            } else {
                rewrittenURI.path(URIUtil.addPaths((String)originalContextPath, (String)newPathQuery));
            }
            this._uri = rewrittenURI.asImmutable();
        }

        @Override
        public HttpURI getHttpURI() {
            return this._uri;
        }
    }
}

