/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLatencyRecordingHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLatencyRecordingHandler.class);

    private HttpStream recordingWrapper(final HttpStream httpStream) {
        return new HttpStream.Wrapper(httpStream){

            @Override
            public void succeeded() {
                long begin = httpStream.getNanoTime();
                super.succeeded();
                this.fireOnRequestComplete(begin);
            }

            @Override
            public void failed(Throwable x) {
                long begin = httpStream.getNanoTime();
                super.failed(x);
                this.fireOnRequestComplete(begin);
            }

            private void fireOnRequestComplete(long begin) {
                block2: {
                    try {
                        AbstractLatencyRecordingHandler.this.onRequestComplete(NanoTime.since((long)begin));
                    }
                    catch (Throwable t) {
                        if (!LOG.isDebugEnabled()) break block2;
                        LOG.debug("Error thrown by onRequestComplete", t);
                    }
                }
            }
        };
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        request.addHttpStreamWrapper(this::recordingWrapper);
        return super.handle(request, response, callback);
    }

    protected abstract void onRequestComplete(long var1);
}

