/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.function.Predicate;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextRequest
extends Request.Wrapper
implements Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRequest.class);
    private final ContextHandler.ScopedContext _context;

    protected ContextRequest(ContextHandler.ScopedContext context, Request request) {
        super(request);
        this._context = context;
    }

    @Override
    public void demand(Runnable demandCallback) {
        super.demand(new OnContextDemand(demandCallback));
    }

    @Override
    public boolean addErrorListener(Predicate<Throwable> onError) {
        return super.addErrorListener(t -> {
            this._context.accept(onError::test, (Throwable)t, this);
            return true;
        });
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    private class OnContextDemand
    implements Runnable {
        private final Runnable _demandCallback;

        public OnContextDemand(Runnable demandCallback) {
            this._demandCallback = demandCallback;
        }

        @Override
        public void run() {
            ContextRequest.this._context.run(this._demandCallback, ContextRequest.this);
        }
    }
}

