/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;

public class DebugHandler
extends Handler.Wrapper
implements Connection.Listener {
    private final DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        boolean bl;
        Thread thread = Thread.currentThread();
        String name = thread.getName() + ":" + String.valueOf(request.getHttpURI());
        String ex = null;
        try {
            this.print(name, "REQUEST " + Request.getRemoteAddr(request) + " " + request.getMethod() + " " + request.getHeaders().get("Cookie") + "; " + request.getHeaders().get("User-Agent"));
            thread.setName(name);
            bl = this.getHandler().handle(request, response, callback);
            this.print(name, "RESPONSE " + response.getStatus() + (String)(ex == null ? "" : "/" + (String)ex) + " " + response.getHeaders().get(HttpHeader.CONTENT_TYPE));
        }
        catch (Throwable x) {
            try {
                ex = String.valueOf(x) + ":" + String.valueOf(x.getCause());
                throw x;
            }
            catch (Throwable throwable) {
                this.print(name, "RESPONSE " + response.getStatus() + (String)(ex == null ? "" : "/" + ex) + " " + response.getHeaders().get(HttpHeader.CONTENT_TYPE));
                throw throwable;
            }
        }
        return bl;
    }

    private void print(String name, String message) {
        long now = System.currentTimeMillis();
        String d = this._date.formatNow(now);
        int ms = (int)(now % 1000L);
        this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " " + message);
    }

    @Override
    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            ((AbstractConnector)connector).addBean(this, false);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            ((AbstractConnector)connector).removeBean(this);
        }
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }

    public void onOpened(Connection connection) {
        this.print(Thread.currentThread().getName(), "OPENED " + connection.toString());
    }

    public void onClosed(Connection connection) {
        this.print(Thread.currentThread().getName(), "CLOSED " + connection.toString());
    }
}

