/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.Graceful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulHandler
extends Handler.Wrapper
implements Graceful {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulHandler.class);
    private final LongAdder dispatchedStats = new LongAdder();
    private final Graceful.Shutdown shutdown = new Graceful.Shutdown(this){

        public boolean isShutdownDone() {
            long count = GracefulHandler.this.dispatchedStats.sum();
            if (LOG.isDebugEnabled()) {
                LOG.debug("isShutdownDone: count {}", (Object)count);
            }
            return count == 0L;
        }
    };

    public boolean isShutdown() {
        return this.shutdown.isShutdown();
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler handler = this.getHandler();
        if (handler == null || !this.isStarted()) {
            return false;
        }
        ShutdownTrackingCallback shutdownCallback = new ShutdownTrackingCallback(request, response, callback);
        if (this.isShutdown()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service Unavailable: {}", (Object)request.getHttpURI());
            }
            Response.writeError(request, response, (Callback)shutdownCallback, 503);
            return true;
        }
        try {
            boolean handled = super.handle(request, response, (Callback)shutdownCallback);
            if (!handled) {
                shutdownCallback.decrement();
            }
            boolean bl = handled;
            return bl;
        }
        catch (Throwable t) {
            shutdownCallback.decrement();
            throw t;
        }
        finally {
            if (this.isShutdown()) {
                this.shutdown.check();
            }
        }
    }

    public CompletableFuture<Void> shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown requested");
        }
        return this.shutdown.shutdown();
    }

    private class ShutdownTrackingCallback
    extends Callback.Nested {
        final Request request;
        final Response response;

        public ShutdownTrackingCallback(Request request, Response response, Callback callback) {
            super(callback);
            this.request = request;
            this.response = response;
            GracefulHandler.this.dispatchedStats.increment();
        }

        public void decrement() {
            GracefulHandler.this.dispatchedStats.decrement();
        }

        public void failed(Throwable x) {
            this.decrement();
            super.failed(x);
            if (GracefulHandler.this.isShutdown()) {
                GracefulHandler.this.shutdown.check();
            }
        }

        public void succeeded() {
            this.decrement();
            super.succeeded();
            if (GracefulHandler.this.isShutdown()) {
                GracefulHandler.this.shutdown.check();
            }
        }
    }
}

