/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.URIUtil;

public class TryPathsHandler
extends Handler.Wrapper {
    private String originalPathAttribute;
    private String originalQueryAttribute;
    private List<String> paths;

    public String getOriginalPathAttribute() {
        return this.originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribute) {
        this.originalPathAttribute = originalPathAttribute;
    }

    public String getOriginalQueryAttribute() {
        return this.originalQueryAttribute;
    }

    public void setOriginalQueryAttribute(String originalQueryAttribute) {
        this.originalQueryAttribute = originalQueryAttribute;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        if (this.paths.size() == 0) {
            return false;
        }
        if (this.paths.size() == 1) {
            if (!super.handle(new TryPathsRequest(request, this.interpolate(request, this.paths.get(0))), response, callback)) {
                Response.writeError(request, response, callback, 404);
            }
        } else {
            new PathsIterator(request, response, callback).iterate();
        }
        return true;
    }

    private String interpolate(Request request, String value) {
        String path = Request.getPathInContext(request);
        return value.replace("$path", path);
    }

    private class TryPathsRequest
    extends Request.Wrapper {
        private final HttpURI _uri;

        public TryPathsRequest(Request wrapped, String newPathQuery) {
            String originalQueryAttribute;
            super(wrapped);
            HttpURI originalURI = wrapped.getHttpURI();
            String originalPathAttribute = TryPathsHandler.this.getOriginalPathAttribute();
            if (originalPathAttribute != null && this.getAttribute(originalPathAttribute) == null) {
                this.setAttribute(originalPathAttribute, Request.getPathInContext(wrapped));
            }
            if ((originalQueryAttribute = TryPathsHandler.this.getOriginalQueryAttribute()) != null && this.getAttribute(originalQueryAttribute) == null) {
                this.setAttribute(originalQueryAttribute, originalURI.getQuery());
            }
            String originalContextPath = Request.getContextPath(wrapped);
            HttpURI.Mutable rewrittenURI = HttpURI.build((HttpURI)originalURI);
            int queryIdx = newPathQuery.indexOf(63);
            if (queryIdx >= 0) {
                String path = newPathQuery.substring(0, queryIdx);
                rewrittenURI.path(URIUtil.addPaths((String)originalContextPath, (String)path));
                rewrittenURI.query(newPathQuery.substring(queryIdx + 1));
            } else {
                rewrittenURI.path(URIUtil.addPaths((String)originalContextPath, (String)newPathQuery));
            }
            this._uri = rewrittenURI.asImmutable();
        }

        @Override
        public HttpURI getHttpURI() {
            return this._uri;
        }
    }

    private class PathsIterator
    extends IteratingNestedCallback {
        private final Request request;
        private final Response response;
        private final Iterator<String> paths;
        private boolean trying;

        private PathsIterator(Request request, Response response, Callback callback) {
            super(callback);
            this.paths = TryPathsHandler.this.paths.iterator();
            this.request = request;
            this.response = response;
        }

        protected IteratingCallback.Action process() throws Throwable {
            if (this.trying) {
                if (this.response.getStatus() != 404) {
                    return IteratingCallback.Action.SUCCEEDED;
                }
                this.trying = false;
                this.response.reset();
            }
            while (this.paths.hasNext()) {
                String path = this.paths.next();
                String interpolated = TryPathsHandler.this.interpolate(this.request, path);
                TryPathsRequest tryRequest = new TryPathsRequest(this.request, interpolated);
                TryPathsResponse tryResponse = new TryPathsResponse(tryRequest, this.response);
                this.trying = true;
                if (TryPathsHandler.super.handle(tryRequest, tryResponse, (Callback)this)) {
                    return IteratingCallback.Action.SCHEDULED;
                }
                this.trying = false;
            }
            if (this.response.isCommitted()) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            Response.writeError(this.request, this.response, (Callback)this, 404);
            return IteratingCallback.Action.SCHEDULED;
        }
    }

    private class TryPathsResponse
    extends Response.Wrapper
    implements Callback {
        private TryPathsResponse(TryPathsRequest request, Response response) {
            super(request, response);
        }

        @Override
        public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
            if (this.getStatus() == 404) {
                this.getRequest().getComponents().getThreadPool().execute(() -> ((Callback)callback).succeeded());
            } else {
                super.write(last, byteBuffer, callback);
            }
        }
    }
}

