/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.GZIPContentDecoder;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.content.ContentSourceTransformer;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.compression.InflaterPool;

public class GzipRequest
extends Request.Wrapper {
    private static final HttpField X_CE_GZIP = new PreEncodedHttpField("X-Content-Encoding", "gzip");
    private static final Pattern COMMA_GZIP = Pattern.compile(".*, *gzip");
    private static final InflaterPool __inflaterPool = new InflaterPool(-1, true);
    private final HttpFields _fields;
    private Decoder _decoder;
    private GzipTransformer _gzipTransformer;

    public GzipRequest(Request request, int inflateBufferSize) {
        super(request);
        this._fields = this.updateRequestFields(request, inflateBufferSize > 0);
        if (inflateBufferSize > 0) {
            Components components = this.getComponents();
            this._decoder = new Decoder(__inflaterPool, components.getByteBufferPool(), inflateBufferSize);
            this._gzipTransformer = new GzipTransformer(this.getWrapped());
        }
    }

    private HttpFields updateRequestFields(Request request, boolean inflatable) {
        HttpFields fields = request.getHeaders();
        HttpFields.Mutable newFields = HttpFields.build((int)fields.size());
        block5: for (HttpField field : fields) {
            HttpHeader header = field.getHeader();
            if (header == null) {
                newFields.add(field);
                continue;
            }
            switch (header) {
                case CONTENT_ENCODING: {
                    if (inflatable) {
                        if (field.getValue().equalsIgnoreCase("gzip")) {
                            newFields.add(X_CE_GZIP);
                            continue block5;
                        }
                        if (COMMA_GZIP.matcher(field.getValue()).matches()) {
                            String v = field.getValue();
                            v = v.substring(0, v.lastIndexOf(44));
                            newFields.add(X_CE_GZIP);
                            newFields.add(new HttpField(HttpHeader.CONTENT_ENCODING, v));
                            continue block5;
                        }
                    }
                    newFields.add(field);
                    continue block5;
                }
                case IF_MATCH: 
                case IF_NONE_MATCH: {
                    String etags = field.getValue();
                    String etagsNoSuffix = CompressedContentFormat.GZIP.stripSuffixes(etags);
                    if (!etagsNoSuffix.equals(etags)) {
                        newFields.add(new HttpField(field.getHeader(), etagsNoSuffix));
                        request.setAttribute("o.e.j.s.h.gzip.GzipHandler.etag", etags);
                        continue block5;
                    }
                    newFields.add(field);
                    continue block5;
                }
                case CONTENT_LENGTH: {
                    newFields.add(inflatable ? new HttpField("X-Content-Length", field.getValue()) : field);
                    continue block5;
                }
            }
            newFields.add(field);
        }
        fields = newFields.takeAsImmutable();
        return fields;
    }

    @Override
    public HttpFields getHeaders() {
        if (this._fields == null) {
            return super.getHeaders();
        }
        return this._fields;
    }

    @Override
    public Content.Chunk read() {
        if (this._gzipTransformer != null) {
            return this._gzipTransformer.read();
        }
        return super.read();
    }

    @Override
    public void demand(Runnable demandCallback) {
        if (this._gzipTransformer != null) {
            this._gzipTransformer.demand(demandCallback);
        } else {
            super.demand(demandCallback);
        }
    }

    void destroy() {
        if (this._decoder != null) {
            this._decoder.destroy();
        }
    }

    private static class Decoder
    extends GZIPContentDecoder {
        private RetainableByteBuffer _decoded;

        private Decoder(InflaterPool inflaterPool, ByteBufferPool bufferPool, int bufferSize) {
            super(inflaterPool, bufferPool, bufferSize);
        }

        public RetainableByteBuffer decode(Content.Chunk chunk) {
            this.decodeChunks(chunk.getByteBuffer());
            RetainableByteBuffer decoded = this._decoded;
            this._decoded = null;
            return decoded;
        }

        protected boolean decodedChunk(RetainableByteBuffer decoded) {
            decoded.retain();
            this._decoded = decoded;
            return true;
        }

        public void decodeChunks(ByteBuffer compressed) {
            this._decoded = null;
            super.decodeChunks(compressed);
        }
    }

    private class GzipTransformer
    extends ContentSourceTransformer {
        private Content.Chunk _chunk;

        public GzipTransformer(Content.Source source) {
            super(source);
        }

        protected Content.Chunk transform(Content.Chunk inputChunk) {
            RetainableByteBuffer decodedBuffer;
            boolean retain;
            boolean bl = retain = this._chunk == null;
            if (this._chunk == null) {
                this._chunk = inputChunk;
            }
            if (this._chunk == null) {
                return null;
            }
            if (this._chunk instanceof Content.Chunk.Error) {
                return this._chunk;
            }
            if (this._chunk.isLast() && !this._chunk.hasRemaining()) {
                return Content.Chunk.EOF;
            }
            if (retain) {
                this._chunk.retain();
            }
            if ((decodedBuffer = GzipRequest.this._decoder.decode(this._chunk)) != null && decodedBuffer.hasRemaining()) {
                return Content.Chunk.from((ByteBuffer)decodedBuffer.getByteBuffer(), (this._chunk.isLast() && !this._chunk.hasRemaining() ? 1 : 0) != 0, () -> ((RetainableByteBuffer)decodedBuffer).release());
            }
            if (decodedBuffer != null) {
                decodedBuffer.release();
            }
            Content.Chunk result = this._chunk.isLast() ? Content.Chunk.EOF : null;
            this._chunk.release();
            this._chunk = null;
            return result;
        }
    }
}

