/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.HttpConnection;
import org.eclipse.jetty.server.internal.ResponseHttpFields;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelState
implements HttpChannel,
Components {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelState.class);
    private static final Throwable DO_NOT_SEND = new Throwable("No Send");
    private static final HttpField CONTENT_LENGTH_0 = new PreEncodedHttpField(HttpHeader.CONTENT_LENGTH, "0"){

        public int getIntValue() {
            return 0;
        }

        public long getLongValue() {
            return 0L;
        }
    };
    private static final MetaData.Request ERROR_REQUEST = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"/"), HttpVersion.HTTP_1_0, HttpFields.EMPTY);
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new PreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private final AutoLock _lock = new AutoLock();
    private final HandlerInvoker _handlerInvoker = new HandlerInvoker();
    private final ConnectionMetaData _connectionMetaData;
    private final SerializedInvoker _serializedInvoker;
    private final Attributes _requestAttributes = new Attributes.Lazy();
    private final ResponseHttpFields _responseHeaders = new ResponseHttpFields();
    private Thread _handling;
    private boolean _handled;
    private WriteState _writeState = WriteState.NOT_LAST;
    private boolean _callbackCompleted = false;
    private Throwable _failure;
    private ChannelRequest _request;
    private HttpStream _stream;
    private long _committedContentLength = -1L;
    private Runnable _onContentAvailable;
    private Callback _writeCallback;
    private Content.Chunk.Error _error;
    private Predicate<Throwable> _onError;
    private Attributes _cache;

    public HttpChannelState(ConnectionMetaData connectionMetaData) {
        this._connectionMetaData = connectionMetaData;
        this._serializedInvoker = new HttpChannelSerializedInvoker();
    }

    @Override
    public void recycle() {
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("recycling {}", (Object)this);
            }
            this._request._httpChannel = null;
            this._request = null;
            this._stream = null;
            this._requestAttributes.clearAttributes();
            this._responseHeaders.reset();
            this._handling = null;
            this._handled = false;
            this._writeState = WriteState.NOT_LAST;
            this._callbackCompleted = false;
            this._failure = null;
            this._committedContentLength = -1L;
            this._onContentAvailable = null;
            this._writeCallback = null;
            this._error = null;
            this._onError = null;
        }
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._connectionMetaData.getHttpConfiguration();
    }

    public HttpStream getHttpStream() {
        try (AutoLock ignored = this._lock.lock();){
            HttpStream httpStream = this._stream;
            return httpStream;
        }
    }

    @Override
    public void setHttpStream(HttpStream stream) {
        try (AutoLock ignored = this._lock.lock();){
            this._stream = stream;
        }
    }

    public Server getServer() {
        return this._connectionMetaData.getConnector().getServer();
    }

    @Override
    public ConnectionMetaData getConnectionMetaData() {
        return this._connectionMetaData;
    }

    public Connection getConnection() {
        return this._connectionMetaData.getConnection();
    }

    public Connector getConnector() {
        return this._connectionMetaData.getConnector();
    }

    public EndPoint getEndPoint() {
        return this.getConnection().getEndPoint();
    }

    @Override
    public ByteBufferPool getByteBufferPool() {
        return this.getConnectionMetaData().getConnector().getByteBufferPool();
    }

    @Override
    public Scheduler getScheduler() {
        return this.getServer().getScheduler();
    }

    @Override
    public ThreadPool getThreadPool() {
        return this.getServer().getThreadPool();
    }

    @Override
    public Attributes getCache() {
        if (this._cache == null) {
            this._cache = this.getConnectionMetaData().isPersistent() ? new Attributes.Mapped(new HashMap()) : Attributes.NULL;
        }
        return this._cache;
    }

    @Override
    public Runnable onRequest(MetaData.Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onRequest {} {}", (Object)request, (Object)this);
        }
        try (AutoLock ignored = this._lock.lock();){
            if (this._stream == null) {
                throw new IllegalStateException("No HttpStream");
            }
            if (this._request != null) {
                throw new IllegalStateException("duplicate request");
            }
            this._request = new ChannelRequest(this, request);
            HttpFields.Mutable responseHeaders = this._request._response.getHeaders();
            if (this.getHttpConfiguration().getSendServerVersion()) {
                responseHeaders.add(SERVER_VERSION);
            }
            if (this.getHttpConfiguration().getSendXPoweredBy()) {
                responseHeaders.add(POWERED_BY);
            }
            if (this.getHttpConfiguration().getSendDateHeader()) {
                responseHeaders.add(this.getConnectionMetaData().getConnector().getServer().getDateField());
            }
            HandlerInvoker handlerInvoker = this._handlerInvoker;
            return handlerInvoker;
        }
    }

    @Override
    public Request getRequest() {
        try (AutoLock ignored = this._lock.lock();){
            ChannelRequest channelRequest = this._request;
            return channelRequest;
        }
    }

    public Response getResponse() {
        try (AutoLock ignored = this._lock.lock();){
            ChannelResponse channelResponse = this._request == null ? null : this._request._response;
            return channelResponse;
        }
    }

    @Override
    public boolean isRequestHandled() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._handling != null || this._handled;
            return bl;
        }
    }

    @Override
    public Runnable onContentAvailable() {
        Runnable onContent;
        try (AutoLock ignored = this._lock.lock();){
            if (this._request == null) {
                Runnable runnable = null;
                return runnable;
            }
            onContent = this._onContentAvailable;
            this._onContentAvailable = null;
        }
        return this._serializedInvoker.offer(onContent);
    }

    public Invocable.InvocationType getInvocationType() {
        Runnable onContent;
        try (AutoLock ignored = this._lock.lock();){
            if (this._request == null) {
                Invocable.InvocationType invocationType = null;
                return invocationType;
            }
            onContent = this._onContentAvailable;
        }
        return Invocable.getInvocationType((Object)onContent);
    }

    @Override
    public Runnable onFailure(Throwable x) {
        Runnable task;
        HttpStream stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFailure {}", (Object)this, (Object)x);
        }
        try (AutoLock ignored = this._lock.lock();){
            if (this._stream == null) {
                Runnable runnable = null;
                return runnable;
            }
            stream = this._stream;
            if (this._request == null) {
                this._request = new ChannelRequest(this, ERROR_REQUEST);
            }
            if (this._error == null) {
                this._error = Content.Chunk.from((Throwable)x);
            } else if (this._error.getCause() != x) {
                this._error.getCause().addSuppressed(x);
                Runnable runnable = null;
                return runnable;
            }
            Runnable invokeOnContentAvailable = this._onContentAvailable;
            this._onContentAvailable = null;
            Callback writeCallback = this._writeCallback;
            this._writeCallback = null;
            Runnable invokeWriteFailure = writeCallback == null ? null : () -> writeCallback.failed(x);
            ChannelRequest request = this._request;
            Runnable invokeCallback = () -> {
                boolean handling;
                try (AutoLock ignore = this._lock.lock();){
                    handling = this._handling != null || this._handled;
                }
                if (handling) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("already handled, skipping failing callback in {}", (Object)this);
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("failing callback in {}", (Object)this, (Object)x);
                    }
                    request._callback.failed(x);
                }
            };
            Predicate<Throwable> onError = this._onError;
            this._onError = null;
            Runnable invokeOnErrorAndCallback = onError == null ? invokeCallback : () -> {
                if (!onError.test(x)) {
                    invokeCallback.run();
                }
            };
            task = this._serializedInvoker.offer(new Runnable[]{invokeOnContentAvailable, invokeWriteFailure, invokeOnErrorAndCallback});
        }
        Throwable unconsumed = stream.consumeAvailable();
        if (unconsumed != null && LOG.isDebugEnabled()) {
            LOG.debug("consuming content during error {}", (Object)unconsumed.toString());
        }
        return task;
    }

    public void addHttpStreamWrapper(Function<HttpStream, HttpStream> onStreamEvent) {
        while (true) {
            HttpStream stream;
            try (AutoLock ignored = this._lock.lock();){
                stream = this._stream;
            }
            if (this._stream == null) {
                throw new IllegalStateException("No active stream");
            }
            HttpStream combined = onStreamEvent.apply(stream);
            if (combined == null) {
                throw new IllegalArgumentException("Cannot remove stream");
            }
            AutoLock ignored = this._lock.lock();
            try {
                if (this._stream != stream) continue;
                this._stream = combined;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
                continue;
            }
            break;
        }
    }

    private void resetResponse() {
        try (AutoLock ignored = this._lock.lock();){
            if (this._responseHeaders.isCommitted()) {
                throw new IllegalStateException("response committed");
            }
            this._responseHeaders.clear();
        }
    }

    private Throwable lockedCheckWrite(boolean last, long length) {
        assert (this._request._lock.isHeldByCurrentThread());
        return switch (this._writeState) {
            default -> throw new IncompatibleClassChangeError();
            case WriteState.NOT_LAST -> {
                this._writeState = last ? WriteState.LAST_WRITTEN : WriteState.NOT_LAST;
                this._request._response._contentBytesWritten += length;
                yield null;
            }
            case WriteState.LAST_WRITTEN, WriteState.LAST_WRITE_COMPLETED -> length > 0L ? new IllegalStateException("last already written") : DO_NOT_SEND;
        };
    }

    public String toString() {
        try (AutoLock ignored = this._lock.lock();){
            String string = String.format("%s@%x{handling=%s, handled=%b, writeState=%s, completed=%b, writeCallback=%s, request=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._handling, this._handled, this._writeState, this._callbackCompleted, this._writeCallback, this._request});
            return string;
        }
    }

    private class HandlerInvoker
    implements Invocable.Task,
    Callback {
        private HandlerInvoker() {
        }

        public void run() {
            HttpStream stream;
            ChannelRequest request;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                assert (HttpChannelState.this._handling == null && !HttpChannelState.this._handled);
                HttpChannelState.this._handling = Thread.currentThread();
                request = HttpChannelState.this._request;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("invoking handler in {}", (Object)HttpChannelState.this);
            }
            Server server = HttpChannelState.this._connectionMetaData.getConnector().getServer();
            Throwable failure = null;
            try {
                String badMessage;
                if (!(HttpMethod.PRI.is(request.getMethod()) || HttpMethod.CONNECT.is(request.getMethod()) || Request.getPathInContext(HttpChannelState.this._request).startsWith("/") || HttpMethod.OPTIONS.is(request.getMethod()))) {
                    throw new BadMessageException("Bad URI path");
                }
                HttpURI uri = request.getHttpURI();
                if (uri.hasViolations() && (badMessage = UriCompliance.checkUriCompliance((UriCompliance)HttpChannelState.this.getConnectionMetaData().getHttpConfiguration().getUriCompliance(), (HttpURI)uri)) != null) {
                    throw new BadMessageException(badMessage);
                }
                HttpConfiguration configuration = HttpChannelState.this.getHttpConfiguration();
                ChannelRequest customized = request;
                HttpFields.Mutable responseHeaders = request._response.getHeaders();
                for (HttpConfiguration.Customizer customizer : configuration.getCustomizers()) {
                    Request next = customizer.customize(customized, responseHeaders);
                    customized = next == null ? customized : next;
                }
                if (customized != request && server.getRequestLog() != null) {
                    request.setLoggedRequest(customized);
                }
                if (!server.handle(customized, request._response, request._callback)) {
                    Response.writeError((Request)customized, (Response)request._response, (Callback)request._callback, 404);
                }
            }
            catch (Throwable t) {
                failure = t;
            }
            boolean completeStream = false;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                stream = HttpChannelState.this._stream;
                if (failure == null) {
                    HttpChannelState.this._handling = null;
                    HttpChannelState.this._handled = true;
                    failure = ExceptionUtil.combine((Throwable)HttpChannelState.this._failure, (Throwable)failure);
                    completeStream = HttpChannelState.this._callbackCompleted && (failure != null || HttpChannelState.this._writeState == WriteState.LAST_WRITE_COMPLETED);
                }
            }
            if (failure != null) {
                request._callback.failed(failure);
                ignored = HttpChannelState.this._lock.lock();
                try {
                    HttpChannelState.this._handling = null;
                    HttpChannelState.this._handled = true;
                    failure = ExceptionUtil.combine((Throwable)HttpChannelState.this._failure, (Throwable)failure);
                    completeStream = HttpChannelState.this._callbackCompleted && (failure != null || HttpChannelState.this._writeState == WriteState.LAST_WRITE_COMPLETED);
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            if (completeStream) {
                this.completeStream(stream, failure);
            }
        }

        public void succeeded() {
            HttpStream stream;
            boolean completeStream;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                HttpChannelState.this._writeState = WriteState.LAST_WRITE_COMPLETED;
                assert (HttpChannelState.this._callbackCompleted);
                completeStream = HttpChannelState.this._handling == null;
                stream = HttpChannelState.this._stream;
            }
            if (completeStream) {
                this.completeStream(stream, null);
            }
        }

        public void failed(Throwable failure) {
            HttpStream stream;
            boolean completeStream;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                HttpChannelState.this._writeState = WriteState.LAST_WRITE_COMPLETED;
                assert (HttpChannelState.this._callbackCompleted);
                completeStream = HttpChannelState.this._handling == null;
                stream = HttpChannelState.this._stream;
                if (HttpChannelState.this._failure == null) {
                    HttpChannelState.this._failure = failure;
                } else if (ExceptionUtil.areNotAssociated((Throwable)HttpChannelState.this._failure, (Throwable)failure)) {
                    HttpChannelState.this._failure.addSuppressed(failure);
                    failure = HttpChannelState.this._failure;
                }
            }
            if (completeStream) {
                this.completeStream(stream, failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeStream(HttpStream stream, Throwable failure) {
            try {
                MultiPartFormData.Parts parts;
                RequestLog requestLog = HttpChannelState.this.getServer().getRequestLog();
                if (requestLog != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("logging {}", (Object)HttpChannelState.this);
                    }
                    requestLog.log(HttpChannelState.this._request.getLoggedRequest(), HttpChannelState.this._request._response);
                }
                if ((parts = (MultiPartFormData.Parts)HttpChannelState.this._request.getAttribute(MultiPartFormData.Parts.class.getName())) != null) {
                    parts.close();
                }
            }
            finally {
                if (failure == null) {
                    stream.succeeded();
                } else {
                    stream.failed(failure);
                }
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return HttpChannelState.this.getConnectionMetaData().getConnector().getServer().getInvocationType();
        }
    }

    static enum WriteState {
        NOT_LAST,
        LAST_WRITTEN,
        LAST_WRITE_COMPLETED;

    }

    private class HttpChannelSerializedInvoker
    extends SerializedInvoker {
        private HttpChannelSerializedInvoker() {
        }

        protected void onError(Runnable task, Throwable failure) {
            Content.Chunk.Error error;
            ChannelRequest request;
            boolean callbackCompleted;
            try (AutoLock ignore = HttpChannelState.this._lock.lock();){
                callbackCompleted = HttpChannelState.this._callbackCompleted;
                request = HttpChannelState.this._request;
                error = HttpChannelState.this._request == null ? null : HttpChannelState.this._error;
            }
            if (request == null || callbackCompleted) {
                super.onError(task, failure);
            } else if (error == null) {
                try {
                    request._callback.failed(failure);
                }
                catch (Throwable t) {
                    if (ExceptionUtil.areNotAssociated((Throwable)failure, (Throwable)t)) {
                        failure.addSuppressed(t);
                    }
                    super.onError(task, failure);
                }
            } else {
                Throwable cause = error.getCause();
                if (cause != null && ExceptionUtil.areNotAssociated((Throwable)cause, (Throwable)failure)) {
                    error.getCause().addSuppressed(failure);
                }
            }
        }
    }

    public static class ChannelRequest
    implements Attributes,
    Request {
        private final long _timeStamp = System.currentTimeMillis();
        private final ChannelCallback _callback = new ChannelCallback(this);
        private final String _id;
        private final ConnectionMetaData _connectionMetaData;
        private final MetaData.Request _metaData;
        private final ChannelResponse _response;
        private final AutoLock _lock;
        private final LongAdder _contentBytesRead = new LongAdder();
        private HttpChannelState _httpChannel;
        private Request _loggedRequest;
        private HttpFields _trailers;

        ChannelRequest(HttpChannelState httpChannel, MetaData.Request metaData) {
            this._httpChannel = Objects.requireNonNull(httpChannel);
            this._id = httpChannel.getHttpStream().getId();
            this._connectionMetaData = httpChannel.getConnectionMetaData();
            this._metaData = Objects.requireNonNull(metaData);
            this._response = new ChannelResponse(this);
            this._lock = httpChannel._lock;
        }

        public void setLoggedRequest(Request request) {
            this._loggedRequest = request;
        }

        public Request getLoggedRequest() {
            return this._loggedRequest == null ? this : this._loggedRequest;
        }

        HttpStream getHttpStream() {
            return this.getHttpChannel()._stream;
        }

        public long getContentBytesRead() {
            return this._contentBytesRead.longValue();
        }

        public Object getAttribute(String name) {
            HttpChannelState httpChannel = this.getHttpChannel();
            if (name.startsWith("org.eclipse.jetty")) {
                if (Server.class.getName().equals(name)) {
                    return httpChannel.getConnectionMetaData().getConnector().getServer();
                }
                if (HttpChannelState.class.getName().equals(name)) {
                    return httpChannel;
                }
                if (HttpConnection.class.getName().equals(name) && this.getConnectionMetaData().getConnection() instanceof HttpConnection) {
                    return this.getConnectionMetaData().getConnection();
                }
            }
            return httpChannel._requestAttributes.getAttribute(name);
        }

        public Object removeAttribute(String name) {
            return this.getHttpChannel()._requestAttributes.removeAttribute(name);
        }

        public Object setAttribute(String name, Object attribute) {
            if (Server.class.getName().equals(name) || HttpChannelState.class.getName().equals(name) || HttpConnection.class.getName().equals(name)) {
                return null;
            }
            return this.getHttpChannel()._requestAttributes.setAttribute(name, attribute);
        }

        public Set<String> getAttributeNameSet() {
            return this.getHttpChannel()._requestAttributes.getAttributeNameSet();
        }

        public void clearAttributes() {
            this.getHttpChannel()._requestAttributes.clearAttributes();
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public Components getComponents() {
            return this.getHttpChannel();
        }

        @Override
        public ConnectionMetaData getConnectionMetaData() {
            return this._connectionMetaData;
        }

        HttpChannelState getHttpChannel() {
            try (AutoLock ignore = this._lock.lock();){
                HttpChannelState httpChannelState = this.lockedGetHttpChannel();
                return httpChannelState;
            }
        }

        private HttpChannelState lockedGetHttpChannel() {
            assert (this._lock.isHeldByCurrentThread());
            if (this._httpChannel == null) {
                throw new IllegalStateException("channel already completed");
            }
            return this._httpChannel;
        }

        @Override
        public String getMethod() {
            return this._metaData.getMethod();
        }

        @Override
        public HttpURI getHttpURI() {
            return this._metaData.getHttpURI();
        }

        @Override
        public Context getContext() {
            return this.getConnectionMetaData().getConnector().getServer().getContext();
        }

        @Override
        public HttpFields getHeaders() {
            return this._metaData.getHttpFields();
        }

        @Override
        public HttpFields getTrailers() {
            return this._trailers;
        }

        @Override
        public long getTimeStamp() {
            return this._timeStamp;
        }

        @Override
        public long getNanoTime() {
            HttpStream stream = this._httpChannel.getHttpStream();
            if (stream != null) {
                return stream.getNanoTime();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean isSecure() {
            return HttpScheme.HTTPS.is(this.getHttpURI().getScheme());
        }

        public long getLength() {
            return this._metaData.getContentLength();
        }

        @Override
        public Content.Chunk read() {
            HttpStream stream;
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannel();
                Content.Chunk.Error error = httpChannel._error;
                if (error != null) {
                    Content.Chunk.Error error2 = error;
                    return error2;
                }
                stream = httpChannel._stream;
            }
            Content.Chunk chunk = stream.read();
            if (LOG.isDebugEnabled()) {
                LOG.debug("read {}", (Object)chunk);
            }
            if (chunk != null && chunk.hasRemaining()) {
                this._contentBytesRead.add(chunk.getByteBuffer().remaining());
            }
            if (chunk instanceof Trailers) {
                Trailers trailers = (Trailers)chunk;
                this._trailers = trailers.getTrailers();
            }
            return chunk;
        }

        @Override
        public boolean consumeAvailable() {
            HttpStream stream;
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannel();
                stream = httpChannel._stream;
            }
            return stream.consumeAvailable() == null;
        }

        @Override
        public void demand(Runnable demandCallback) {
            HttpStream stream;
            boolean error;
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannel();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("demand {}", (Object)httpChannel);
                }
                boolean bl = error = httpChannel._error != null;
                if (!error) {
                    if (httpChannel._onContentAvailable != null) {
                        throw new IllegalArgumentException("demand pending");
                    }
                    httpChannel._onContentAvailable = demandCallback;
                }
                stream = httpChannel._stream;
            }
            if (error) {
                this.getHttpChannel()._serializedInvoker.run(demandCallback);
            } else {
                stream.demand();
            }
        }

        public void fail(Throwable failure) {
        }

        @Override
        public void push(MetaData.Request resource) {
            this.getHttpStream().push(resource);
        }

        @Override
        public boolean addErrorListener(Predicate<Throwable> onError) {
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannel();
                if (httpChannel._error != null) {
                    boolean bl = false;
                    return bl;
                }
                if (httpChannel._onError == null) {
                    httpChannel._onError = onError;
                } else {
                    Predicate<Throwable> previous = httpChannel._onError;
                    httpChannel._onError = throwable -> {
                        if (!previous.test((Throwable)throwable)) {
                            return onError.test((Throwable)throwable);
                        }
                        return true;
                    };
                }
                boolean bl = true;
                return bl;
            }
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return this.getHttpStream().getTunnelSupport();
        }

        @Override
        public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
            this.getHttpChannel().addHttpStreamWrapper(wrapper);
        }

        @Override
        public Session getSession(boolean create) {
            return null;
        }

        public String toString() {
            return String.format("%s@%x %s %s", this.getMethod(), this.hashCode(), this.getHttpURI(), this._metaData.getHttpVersion());
        }
    }

    public static class ChannelResponse
    implements Response,
    Callback {
        private final ChannelRequest _request;
        private int _status;
        private long _contentBytesWritten;
        private Supplier<HttpFields> _trailers;

        private ChannelResponse(ChannelRequest request) {
            this._request = request;
        }

        public long getContentBytesWritten() {
            return this._contentBytesWritten;
        }

        @Override
        public Request getRequest() {
            return this._request;
        }

        @Override
        public int getStatus() {
            return this._status;
        }

        @Override
        public void setStatus(int code) {
            if (!this.isCommitted()) {
                this._status = code;
            }
        }

        @Override
        public HttpFields.Mutable getHeaders() {
            return this._request.getHttpChannel()._responseHeaders;
        }

        @Override
        public Supplier<HttpFields> getTrailersSupplier() {
            try (AutoLock ignored = this._request._lock.lock();){
                Supplier<HttpFields> supplier = this._trailers;
                return supplier;
            }
        }

        @Override
        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
            try (AutoLock ignored = this._request._lock.lock();){
                this._trailers = trailers;
            }
        }

        @Override
        public void write(boolean last, ByteBuffer content, Callback callback) {
            Throwable failure;
            HttpChannelState httpChannel;
            long length = BufferUtil.length((ByteBuffer)content);
            HttpStream stream = null;
            MetaData.Response responseMetaData = null;
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannel = this._request.lockedGetHttpChannel();
                failure = httpChannel._writeCallback != null ? new IllegalStateException("write pending") : (httpChannel._error != null ? httpChannel._error.getCause() : httpChannel.lockedCheckWrite(last, length));
                if (failure == null) {
                    long committedContentLength;
                    httpChannel._writeCallback = callback;
                    stream = httpChannel._stream;
                    long totalWritten = this._contentBytesWritten;
                    if (httpChannel._responseHeaders.commit()) {
                        responseMetaData = this.lockedPrepareResponse(httpChannel, last);
                    }
                    if ((committedContentLength = httpChannel._committedContentLength) >= 0L) {
                        String lengthError;
                        String string = totalWritten > committedContentLength ? "written %d > %d content-length" : (lengthError = last && totalWritten < committedContentLength ? "written %d < %d content-length" : null);
                        if (lengthError != null) {
                            String message = lengthError.formatted(totalWritten, committedContentLength);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("fail {} {}", (Object)callback, (Object)message);
                            }
                            failure = new IOException(message);
                        }
                    }
                }
            }
            if (failure == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("writing last={} {} {}", new Object[]{last, BufferUtil.toDetailString((ByteBuffer)content), this});
                }
                stream.send(this._request._metaData, responseMetaData, last, content, this);
            } else if (failure == DO_NOT_SEND) {
                httpChannel._serializedInvoker.run(() -> ((Callback)callback).succeeded());
            } else {
                Throwable t = failure;
                httpChannel._serializedInvoker.run(() -> callback.failed(t));
            }
        }

        public void succeeded() {
            Callback callback;
            HttpChannelState httpChannel;
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannel = this._request.lockedGetHttpChannel();
                callback = httpChannel._writeCallback;
                httpChannel._writeCallback = null;
                if (httpChannel._writeState == WriteState.LAST_WRITTEN) {
                    httpChannel._writeState = WriteState.LAST_WRITE_COMPLETED;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("write succeeded {} {}", (Object)callback, (Object)this);
            }
            if (callback != null) {
                httpChannel._serializedInvoker.run(() -> ((Callback)callback).succeeded());
            }
        }

        public void failed(Throwable x) {
            Callback callback;
            HttpChannelState httpChannel;
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannel = this._request.lockedGetHttpChannel();
                callback = httpChannel._writeCallback;
                httpChannel._writeCallback = null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("write failed {}", (Object)callback, (Object)x);
            }
            if (callback != null) {
                httpChannel._serializedInvoker.run(() -> callback.failed(x));
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType((Object)this._request.getHttpChannel()._writeCallback);
        }

        @Override
        public boolean isCommitted() {
            return this._request.getHttpChannel()._responseHeaders.isCommitted();
        }

        @Override
        public boolean isCompletedSuccessfully() {
            try (AutoLock ignored = this._request._lock.lock();){
                if (this._request._httpChannel == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this._request._httpChannel._callbackCompleted && this._request._httpChannel._failure == null;
                return bl;
            }
        }

        @Override
        public void reset() {
            this._status = 0;
            this._trailers = null;
            this._request.getHttpChannel().resetResponse();
        }

        @Override
        public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
            Callback.Completable completable = new Callback.Completable();
            if (HttpStatus.isInterim((int)status)) {
                HttpChannelState channel = this._request.getHttpChannel();
                HttpVersion version = channel.getConnectionMetaData().getHttpVersion();
                MetaData.Response response = new MetaData.Response(status, null, version, headers);
                channel._stream.send(this._request._metaData, response, false, null, (Callback)completable);
            } else {
                completable.failed((Throwable)new IllegalArgumentException("Invalid interim status code: " + status));
            }
            return completable;
        }

        private MetaData.Response lockedPrepareResponse(HttpChannelState httpChannel, boolean last) {
            if (this._status == 0) {
                this._status = 200;
            }
            HttpFields.Mutable mutableHeaders = httpChannel._responseHeaders.getMutableHttpFields();
            httpChannel._committedContentLength = mutableHeaders.getLongField(HttpHeader.CONTENT_LENGTH);
            if (last && httpChannel._committedContentLength < 0L) {
                httpChannel._committedContentLength = this._contentBytesWritten;
                if (httpChannel._committedContentLength == 0L) {
                    mutableHeaders.put(CONTENT_LENGTH_0);
                } else {
                    mutableHeaders.putLongField(HttpHeader.CONTENT_LENGTH, httpChannel._committedContentLength);
                }
            }
            httpChannel._stream.prepareResponse(mutableHeaders);
            return new MetaData.Response(this._status, null, httpChannel.getConnectionMetaData().getHttpVersion(), (HttpFields)httpChannel._responseHeaders, httpChannel._committedContentLength, this.getTrailersSupplier());
        }
    }

    private static class ChannelCallback
    implements Callback {
        private final ChannelRequest _request;
        private Throwable _completedBy;

        private ChannelCallback(ChannelRequest request) {
            this._request = request;
        }

        public void succeeded() {
            HttpStream stream;
            boolean needLastWrite;
            boolean completeStream;
            HttpChannelState httpChannelState;
            Throwable failure = null;
            MetaData.Response responseMetaData = null;
            try (AutoLock ignored = this._request._lock.lock();){
                if (!this.lockedOnComplete()) {
                    return;
                }
                httpChannelState = this._request._httpChannel;
                boolean bl = completeStream = httpChannelState._handling == null && httpChannelState._writeState == WriteState.LAST_WRITE_COMPLETED;
                if (httpChannelState._onContentAvailable != null) {
                    throw new IllegalStateException("demand pending");
                }
                if (httpChannelState._writeCallback != null) {
                    throw new IllegalStateException("write pending");
                }
                needLastWrite = switch (httpChannelState._writeState) {
                    default -> throw new IncompatibleClassChangeError();
                    case WriteState.NOT_LAST -> true;
                    case WriteState.LAST_WRITTEN, WriteState.LAST_WRITE_COMPLETED -> false;
                };
                stream = httpChannelState._stream;
                if (httpChannelState._responseHeaders.commit()) {
                    responseMetaData = this._request._response.lockedPrepareResponse(httpChannelState, true);
                }
                long totalWritten = this._request._response._contentBytesWritten;
                long committedContentLength = httpChannelState._committedContentLength;
                if (committedContentLength >= 0L && committedContentLength != totalWritten) {
                    failure = httpChannelState._failure = new IOException("content-length %d != %d written".formatted(committedContentLength, totalWritten));
                }
                Throwable unconsumed = stream.consumeAvailable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("consumeAvailable: {} {} ", (Object)(unconsumed == null ? 1 : 0), (Object)httpChannelState);
                }
                if (unconsumed != null && httpChannelState.getConnectionMetaData().isPersistent()) {
                    if (failure == null) {
                        failure = httpChannelState._failure = unconsumed;
                    } else if (ExceptionUtil.areNotAssociated(failure, (Throwable)unconsumed)) {
                        failure.addSuppressed(unconsumed);
                    }
                }
            }
            if (failure == null && needLastWrite) {
                stream.send(this._request._metaData, responseMetaData, true, null, httpChannelState._handlerInvoker);
            } else if (completeStream) {
                httpChannelState._handlerInvoker.completeStream(stream, failure);
            }
        }

        public void failed(Throwable failure) {
            ChannelRequest request;
            HttpStream stream;
            boolean writeErrorResponse;
            boolean completeStream;
            HttpChannelState httpChannelState;
            try (AutoLock ignored = this._request._lock.lock();){
                if (!this.lockedOnComplete()) {
                    return;
                }
                httpChannelState = this._request._httpChannel;
                httpChannelState._failure = failure;
                completeStream = httpChannelState._handling == null;
                writeErrorResponse = !httpChannelState._stream.isCommitted();
                stream = httpChannelState._stream;
                request = this._request;
                Throwable unconsumed = stream.consumeAvailable();
                if (unconsumed != null && ExceptionUtil.areNotAssociated((Throwable)unconsumed, (Throwable)failure)) {
                    failure.addSuppressed(unconsumed);
                }
                if (writeErrorResponse) {
                    this._request._response._status = 500;
                    httpChannelState._responseHeaders.reset();
                    httpChannelState._writeState = WriteState.NOT_LAST;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("failed {}", (Object)httpChannelState, (Object)failure);
            }
            if (writeErrorResponse) {
                ErrorResponse response = new ErrorResponse(request, stream, failure);
                Response.writeError((Request)request, (Response)response, (Callback)response, failure);
            } else if (completeStream) {
                httpChannelState._handlerInvoker.completeStream(stream, failure);
            }
        }

        private boolean lockedOnComplete() {
            assert (this._request._lock.isHeldByCurrentThread());
            HttpChannelState httpChannelState = this._request._httpChannel;
            if (httpChannelState == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("already recycled after completion {} by", (Object)this._request, (Object)this._completedBy);
                }
                return false;
            }
            if (httpChannelState._callbackCompleted) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("already completed {} by", (Object)this._request, (Object)this._completedBy);
                    LOG.debug("Second complete", new Throwable("second complete"));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                this._completedBy = new Throwable(Thread.currentThread().getName());
            }
            httpChannelState._callbackCompleted = true;
            return true;
        }

        public Invocable.InvocationType getInvocationType() {
            return this._request.getHttpStream().getInvocationType();
        }
    }

    private static class ErrorResponse
    extends Response.Wrapper
    implements Callback {
        private final ChannelRequest _request;
        private final HttpStream _stream;
        private final Throwable _failure;

        public ErrorResponse(ChannelRequest request, HttpStream stream, Throwable failure) {
            super(request, request._response);
            this._request = request;
            this._stream = stream;
            this._failure = failure;
        }

        @Override
        public void write(boolean last, ByteBuffer content, Callback callback) {
            Throwable failure;
            HttpChannelState httpChannel;
            long length = BufferUtil.length((ByteBuffer)content);
            MetaData.Response responseMetaData = null;
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannel = this._request.lockedGetHttpChannel();
                httpChannel._writeCallback = callback;
                failure = httpChannel.lockedCheckWrite(last, length);
                if (httpChannel._responseHeaders.commit()) {
                    responseMetaData = this._request._response.lockedPrepareResponse(httpChannel, last);
                }
            }
            if (failure == null) {
                this._stream.send(this._request._metaData, responseMetaData, last, content, last ? Callback.from(this::lastWriteCompleted, (Callback)callback) : callback);
            } else if (failure == DO_NOT_SEND) {
                httpChannel._serializedInvoker.run(() -> ((Callback)callback).succeeded());
            } else {
                httpChannel._serializedInvoker.run(() -> callback.failed(failure));
            }
        }

        private void lastWriteCompleted() {
            try (AutoLock ignored = this._request._lock.lock();){
                this._request.lockedGetHttpChannel()._writeState = WriteState.LAST_WRITE_COMPLETED;
            }
        }

        public void succeeded() {
            boolean needLastWrite;
            HttpChannelState httpChannel;
            MetaData.Response responseMetaData = null;
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannel = this._request.getHttpChannel();
                boolean bl = needLastWrite = httpChannel._writeState.ordinal() <= WriteState.LAST_WRITTEN.ordinal();
                if (needLastWrite && httpChannel._responseHeaders.commit()) {
                    responseMetaData = this._request._response.lockedPrepareResponse(httpChannel, true);
                }
            }
            if (needLastWrite) {
                this._stream.send(this._request._metaData, responseMetaData, true, null, Callback.from(() -> httpChannel._handlerInvoker.failed(this._failure), x -> {
                    if (ExceptionUtil.areNotAssociated((Throwable)this._failure, (Throwable)x)) {
                        this._failure.addSuppressed((Throwable)x);
                    }
                    httpChannel._handlerInvoker.failed(this._failure);
                }));
            } else {
                httpChannel._handlerInvoker.failed(this._failure);
            }
        }

        public void failed(Throwable x) {
            if (ExceptionUtil.areNotAssociated((Throwable)this._failure, (Throwable)x)) {
                this._failure.addSuppressed(x);
            }
            this._request.getHttpChannel()._handlerInvoker.failed(this._failure);
        }
    }
}

