/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.StringUtil;

public class DelayedHandler
extends Handler.Wrapper {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        MimeTypes.Type mimeType;
        DelayedProcess delayed;
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        boolean contentExpected = false;
        String contentType = null;
        block6: for (HttpField field : request.getHeaders()) {
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_TYPE: {
                    contentType = field.getValue();
                    break;
                }
                case CONTENT_LENGTH: {
                    contentExpected = field.getLongValue() > 0L;
                    break;
                }
                case TRANSFER_ENCODING: {
                    contentExpected = field.contains(HttpHeaderValue.CHUNKED.asString());
                    break;
                }
                case EXPECT: {
                    if (!field.contains(HttpHeaderValue.CONTINUE.asString())) break;
                    contentExpected = false;
                    break block6;
                }
            }
        }
        if ((delayed = this.newDelayedProcess(contentExpected, contentType, mimeType = MimeTypes.getBaseType(contentType), next, request, response, callback)) == null) {
            return next.handle(request, response, callback);
        }
        delayed.delay();
        return true;
    }

    protected DelayedProcess newDelayedProcess(boolean contentExpected, String contentType, MimeTypes.Type mimeType, Handler handler, Request request, Response response, Callback callback) {
        if (!contentExpected) {
            return null;
        }
        if (!request.getConnectionMetaData().getHttpConfiguration().isDelayDispatchUntilContent()) {
            return null;
        }
        if (mimeType == null) {
            return new UntilContentDelayedProcess(handler, request, response, callback);
        }
        return switch (mimeType) {
            case MimeTypes.Type.FORM_ENCODED -> new UntilFormDelayedProcess(handler, request, response, callback, contentType);
            case MimeTypes.Type.MULTIPART_FORM_DATA -> new UntilMultiPartDelayedProcess(handler, request, response, callback, contentType);
            default -> new UntilContentDelayedProcess(handler, request, response, callback);
        };
    }

    protected static abstract class DelayedProcess {
        private final Handler _handler;
        private final Request _request;
        private final Response _response;
        private final Callback _callback;

        protected DelayedProcess(Handler handler, Request request, Response response, Callback callback) {
            this._handler = Objects.requireNonNull(handler);
            this._request = Objects.requireNonNull(request);
            this._response = Objects.requireNonNull(response);
            this._callback = Objects.requireNonNull(callback);
        }

        protected Handler getHandler() {
            return this._handler;
        }

        protected Request getRequest() {
            return this._request;
        }

        protected Response getResponse() {
            return this._response;
        }

        protected Callback getCallback() {
            return this._callback;
        }

        protected void process() {
            try {
                if (!this.getHandler().handle(this.getRequest(), this.getResponse(), this.getCallback())) {
                    Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), 404);
                }
            }
            catch (Throwable t) {
                Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), t);
            }
        }

        protected abstract void delay() throws Exception;
    }

    protected static class UntilContentDelayedProcess
    extends DelayedProcess {
        public UntilContentDelayedProcess(Handler handler, Request request, Response response, Callback callback) {
            super(handler, request, response, callback);
        }

        @Override
        protected void delay() {
            Content.Chunk chunk = super.getRequest().read();
            if (chunk == null) {
                this.getRequest().demand(this::onContent);
            } else {
                RewindChunkRequest request = new RewindChunkRequest(this.getRequest(), chunk);
                try {
                    this.getHandler().handle(request, this.getResponse(), this.getCallback());
                }
                catch (Throwable x) {
                    Response.writeError((Request)request, this.getResponse(), this.getCallback(), x);
                }
            }
        }

        public void onContent() {
            this.getRequest().getContext().execute(this::process);
        }

        private static class RewindChunkRequest
        extends Request.Wrapper {
            private final AtomicReference<Content.Chunk> _chunk;

            public RewindChunkRequest(Request wrapped, Content.Chunk chunk) {
                super(wrapped);
                this._chunk = new AtomicReference<Content.Chunk>(chunk);
            }

            @Override
            public Content.Chunk read() {
                Content.Chunk chunk = this._chunk.getAndSet(null);
                if (chunk != null) {
                    return chunk;
                }
                return super.read();
            }
        }
    }

    protected static class UntilFormDelayedProcess
    extends DelayedProcess {
        private final Charset _charset;

        public UntilFormDelayedProcess(Handler handler, Request wrapped, Response response, Callback callback, String contentType) {
            super(handler, wrapped, response, callback);
            String cs = MimeTypes.getCharsetFromContentType((String)contentType);
            this._charset = StringUtil.isEmpty((String)cs) ? StandardCharsets.UTF_8 : Charset.forName(cs);
        }

        @Override
        protected void delay() {
            CompletableFuture<Fields> futureFormFields;
            futureFormFields.whenComplete((BiConsumer)((futureFormFields = FormFields.from(this.getRequest(), this._charset)).isDone() ? this::process : this::executeProcess));
        }

        private void process(Fields fields, Throwable x) {
            if (x == null) {
                super.process();
            } else {
                Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), x);
            }
        }

        private void executeProcess(Fields fields, Throwable x) {
            if (x == null) {
                this.getRequest().getContext().execute(() -> super.process());
            } else {
                Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), x);
            }
        }
    }

    protected static class UntilMultiPartDelayedProcess
    extends DelayedProcess {
        private final MultiPartFormData _formData;

        public UntilMultiPartDelayedProcess(Handler handler, Request wrapped, Response response, Callback callback, String contentType) {
            super(handler, wrapped, response, callback);
            String boundary = MultiPart.extractBoundary((String)contentType);
            this._formData = boundary == null ? null : new MultiPartFormData(boundary);
        }

        private void process(MultiPartFormData.Parts parts, Throwable x) {
            if (x == null) {
                this.getRequest().setAttribute(MultiPartFormData.Parts.class.getName(), parts);
                super.process();
            } else {
                Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), x);
            }
        }

        private void executeProcess(MultiPartFormData.Parts parts, Throwable x) {
            if (x == null) {
                this.getRequest().getContext().execute(() -> this.process(parts, x));
            } else {
                Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), x);
            }
        }

        @Override
        public void delay() {
            if (this._formData == null) {
                this.process();
            } else {
                this._formData.setFilesDirectory(this.getRequest().getContext().getTempDirectory().toPath());
                this.readAndParse();
                if (this._formData.isDone()) {
                    try {
                        MultiPartFormData.Parts parts = (MultiPartFormData.Parts)this._formData.join();
                        this.process(parts, null);
                    }
                    catch (Throwable t) {
                        this.process(null, t);
                    }
                } else {
                    this._formData.whenComplete(this::executeProcess);
                }
            }
        }

        private void readAndParse() {
            while (!this._formData.isDone()) {
                Content.Chunk chunk = this.getRequest().read();
                if (chunk == null) {
                    this.getRequest().demand(this::readAndParse);
                    return;
                }
                if (chunk instanceof Content.Chunk.Error) {
                    Content.Chunk.Error error = (Content.Chunk.Error)chunk;
                    this._formData.completeExceptionally(error.getCause());
                    return;
                }
                this._formData.parse(chunk);
                chunk.release();
                if (!chunk.isLast()) continue;
                if (!this._formData.isDone()) {
                    this.process(null, new IOException("Incomplete multipart"));
                }
                return;
            }
        }
    }
}

