/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.time.Duration;
import java.util.List;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.content.FileMappingHttpContentFactory;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.PreCompressedHttpContentFactory;
import org.eclipse.jetty.http.content.ResourceHttpContentFactory;
import org.eclipse.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.eclipse.jetty.http.content.VirtualHttpContentFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;

public class ResourceHandler
extends Handler.Wrapper {
    private final ResourceService _resourceService = this.newResourceService();
    private ByteBufferPool _byteBufferPool;
    private Resource _baseResource;
    private Resource _styleSheet;
    private MimeTypes _mimeTypes;
    private List<String> _welcomes = List.of("index.html");

    protected ResourceService newResourceService() {
        return new HandlerResourceService();
    }

    public ResourceService getResourceService() {
        return this._resourceService;
    }

    @Override
    public void doStart() throws Exception {
        Context context = ContextHandler.getCurrentContext(this.getServer());
        if (this._baseResource == null && context != null) {
            this._baseResource = context.getBaseResource();
        }
        this.setMimeTypes(context == null ? MimeTypes.DEFAULTS : context.getMimeTypes());
        this._byteBufferPool = this.getByteBufferPool(context);
        ResourceService resourceService = this.getResourceService();
        resourceService.setHttpContentFactory(this.newHttpContentFactory());
        resourceService.setWelcomeFactory(this.setupWelcomeFactory());
        if (this.getStyleSheet() == null) {
            this.setStyleSheet(this.getServer().getDefaultStyleSheet());
        }
        super.doStart();
    }

    private ByteBufferPool getByteBufferPool(Context context) {
        if (context == null) {
            return new ByteBufferPool.NonPooling();
        }
        Server server = this.getServer();
        if (server == null) {
            return new ByteBufferPool.NonPooling();
        }
        return server.getByteBufferPool();
    }

    public HttpContent.Factory getHttpContentFactory() {
        return this._resourceService.getHttpContentFactory();
    }

    protected HttpContent.Factory newHttpContentFactory() {
        ResourceHttpContentFactory contentFactory = new ResourceHttpContentFactory(ResourceFactory.of((Resource)this.getBaseResource()), this.getMimeTypes());
        contentFactory = new FileMappingHttpContentFactory((HttpContent.Factory)contentFactory);
        contentFactory = new VirtualHttpContentFactory((HttpContent.Factory)contentFactory, this.getStyleSheet(), "text/css");
        contentFactory = new PreCompressedHttpContentFactory((HttpContent.Factory)contentFactory, this.getPrecompressedFormats());
        contentFactory = new ValidatingCachingHttpContentFactory((HttpContent.Factory)contentFactory, Duration.ofSeconds(1L).toMillis(), this.getByteBufferPool());
        return contentFactory;
    }

    protected ResourceService.WelcomeFactory setupWelcomeFactory() {
        return request -> {
            if (this._welcomes == null) {
                return null;
            }
            for (String welcome : this._welcomes) {
                String pathInContext = Request.getPathInContext(request);
                String welcomeInContext = URIUtil.addPaths((String)pathInContext, (String)welcome);
                Resource welcomePath = this._baseResource.resolve(pathInContext).resolve(welcome);
                if (!Resources.isReadableFile((Resource)welcomePath)) continue;
                return welcomeInContext;
            }
            return null;
        };
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (!HttpMethod.GET.is(request.getMethod()) && !HttpMethod.HEAD.is(request.getMethod())) {
            return super.handle(request, response, callback);
        }
        HttpContent content = this._resourceService.getContent(Request.getPathInContext(request), request);
        if (content == null) {
            return super.handle(request, response, callback);
        }
        this._resourceService.doGet(request, response, callback, content);
        return true;
    }

    public Resource getBaseResource() {
        return this._baseResource;
    }

    public ByteBufferPool getByteBufferPool() {
        return this._byteBufferPool;
    }

    public String getCacheControl() {
        return this._resourceService.getCacheControl();
    }

    public List<String> getGzipEquivalentFileExtensions() {
        return this._resourceService.getGzipEquivalentFileExtensions();
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public Resource getStyleSheet() {
        return this._styleSheet == null ? this.getServer().getDefaultStyleSheet() : this._styleSheet;
    }

    public List<String> getWelcomeFiles() {
        return this._welcomes;
    }

    public boolean isAcceptRanges() {
        return this._resourceService.isAcceptRanges();
    }

    public boolean isDirAllowed() {
        return this._resourceService.isDirAllowed();
    }

    public boolean isEtags() {
        return this._resourceService.isEtags();
    }

    public List<CompressedContentFormat> getPrecompressedFormats() {
        return this._resourceService.getPrecompressedFormats();
    }

    public ResourceService.WelcomeMode getWelcomeMode() {
        return this._resourceService.getWelcomeMode();
    }

    public void setAcceptRanges(boolean acceptRanges) {
        this._resourceService.setAcceptRanges(acceptRanges);
    }

    public void setBaseResource(Resource base) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._baseResource = base;
    }

    public void setBaseResourceAsString(String base) {
        this.setBaseResource(base == null ? null : ResourceFactory.of((Container)this).newResource(base));
    }

    public void setCacheControl(String cacheControl) {
        this._resourceService.setCacheControl(cacheControl);
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._resourceService.setDirAllowed(dirAllowed);
    }

    public void setEtags(boolean etags) {
        this._resourceService.setEtags(etags);
    }

    public void setGzipEquivalentFileExtensions(List<String> gzipEquivalentFileExtensions) {
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
    }

    public void setPrecompressedFormats(CompressedContentFormat ... precompressedFormats) {
        this.setPrecompressedFormats(List.of(precompressedFormats));
    }

    public void setPrecompressedFormats(List<CompressedContentFormat> precompressedFormats) {
        this._resourceService.setPrecompressedFormats(precompressedFormats);
    }

    public void setEncodingCacheSize(int encodingCacheSize) {
        this._resourceService.setEncodingCacheSize(encodingCacheSize);
    }

    public int getEncodingCacheSize() {
        return this._resourceService.getEncodingCacheSize();
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setWelcomeMode(ResourceService.WelcomeMode welcomeMode) {
        this._resourceService.setWelcomeMode(welcomeMode);
    }

    public void setStyleSheet(Resource styleSheet) {
        this._styleSheet = styleSheet;
    }

    public void setWelcomeFiles(String ... welcomeFiles) {
        this.setWelcomeFiles(List.of(welcomeFiles));
    }

    public void setWelcomeFiles(List<String> welcomeFiles) {
        this._welcomes = welcomeFiles;
    }

    private class HandlerResourceService
    extends ResourceService {
        private HandlerResourceService() {
        }

        @Override
        protected void rehandleWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws Exception {
            HttpURI.Mutable newHttpURI = HttpURI.build((HttpURI)request.getHttpURI()).pathQuery(welcomeTarget);
            Request.Wrapper newRequest = new Request.Wrapper(request, (HttpURI)newHttpURI){
                final /* synthetic */ HttpURI val$newHttpURI;
                {
                    this.val$newHttpURI = httpURI;
                    super(wrapped);
                }

                @Override
                public HttpURI getHttpURI() {
                    return this.val$newHttpURI;
                }
            };
            if (ResourceHandler.this.getServer().handle(newRequest, response, callback)) {
                return;
            }
            super.rehandleWelcome(request, response, callback, welcomeTarget);
        }
    }

    public static class ResourceContext
    extends ContextHandler {
        public ResourceContext() {
            this.setHandler(new ResourceHandler());
        }
    }
}

