/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.HttpConnection;
import org.eclipse.jetty.server.internal.ResponseHttpFields;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelState
implements HttpChannel,
Components {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelState.class);
    private static final Throwable DO_NOT_SEND = new Throwable("No Send");
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new PreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private final AutoLock _lock = new AutoLock();
    private final HandlerInvoker _handlerInvoker = new HandlerInvoker();
    private final ConnectionMetaData _connectionMetaData;
    private final SerializedInvoker _serializedInvoker;
    private final Attributes _requestAttributes = new Attributes.Lazy();
    private final ResponseHttpFields _responseHeaders = new ResponseHttpFields();
    private Thread _handling;
    private boolean _handled;
    private StreamSendState _streamSendState = StreamSendState.SENDING;
    private boolean _callbackCompleted = false;
    private ChannelRequest _request;
    private ChannelResponse _response;
    private long _oldIdleTimeout;
    private HttpStream _stream;
    private long _committedContentLength = -1L;
    private Runnable _onContentAvailable;
    private Predicate<TimeoutException> _onIdleTimeout;
    private Content.Chunk.Error _failure;
    private Consumer<Throwable> _onFailure;
    private Throwable _callbackFailure;
    private Attributes _cache;

    public HttpChannelState(ConnectionMetaData connectionMetaData) {
        this._connectionMetaData = connectionMetaData;
        this._serializedInvoker = new HttpChannelSerializedInvoker();
    }

    @Override
    public void recycle() {
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("recycling {}", (Object)this);
            }
            this._request._httpChannelState = null;
            this._request = null;
            this._response = null;
            this._stream = null;
            this._streamSendState = StreamSendState.SENDING;
            this._requestAttributes.clearAttributes();
            this._responseHeaders.reset();
            this._handling = null;
            this._handled = false;
            this._callbackCompleted = false;
            this._callbackFailure = null;
            this._committedContentLength = -1L;
            this._onContentAvailable = null;
            this._failure = null;
            this._onFailure = null;
        }
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._connectionMetaData.getHttpConfiguration();
    }

    public HttpStream getHttpStream() {
        try (AutoLock ignored = this._lock.lock();){
            HttpStream httpStream = this._stream;
            return httpStream;
        }
    }

    @Override
    public void setHttpStream(HttpStream stream) {
        try (AutoLock ignored = this._lock.lock();){
            this._stream = stream;
        }
    }

    public Server getServer() {
        return this._connectionMetaData.getConnector().getServer();
    }

    @Override
    public ConnectionMetaData getConnectionMetaData() {
        return this._connectionMetaData;
    }

    public Connection getConnection() {
        return this._connectionMetaData.getConnection();
    }

    public Connector getConnector() {
        return this._connectionMetaData.getConnector();
    }

    public EndPoint getEndPoint() {
        return this.getConnection().getEndPoint();
    }

    @Override
    public ByteBufferPool getByteBufferPool() {
        return this.getConnectionMetaData().getConnector().getByteBufferPool();
    }

    @Override
    public Scheduler getScheduler() {
        return this.getServer().getScheduler();
    }

    @Override
    public ThreadPool getThreadPool() {
        return this.getServer().getThreadPool();
    }

    @Override
    public Attributes getCache() {
        if (this._cache == null) {
            this._cache = this.getConnectionMetaData().isPersistent() ? new Attributes.Mapped(new HashMap()) : Attributes.NULL;
        }
        return this._cache;
    }

    @Override
    public Runnable onRequest(MetaData.Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onRequest {} {}", (Object)request, (Object)this);
        }
        try (AutoLock ignored = this._lock.lock();){
            if (this._stream == null) {
                throw new IllegalStateException("No HttpStream");
            }
            if (this._request != null) {
                throw new IllegalStateException("duplicate request");
            }
            this._request = new ChannelRequest(this, request);
            this._response = new ChannelResponse(this._request);
            HttpFields.Mutable responseHeaders = this._response.getHeaders();
            HttpConfiguration httpConfiguration = this.getHttpConfiguration();
            if (httpConfiguration.getSendServerVersion()) {
                responseHeaders.add(SERVER_VERSION);
            }
            if (httpConfiguration.getSendXPoweredBy()) {
                responseHeaders.add(POWERED_BY);
            }
            if (httpConfiguration.getSendDateHeader()) {
                responseHeaders.add(this.getConnectionMetaData().getConnector().getServer().getDateField());
            }
            long idleTO = httpConfiguration.getIdleTimeout();
            this._oldIdleTimeout = this._stream.getIdleTimeout();
            if (idleTO >= 0L && this._oldIdleTimeout != idleTO) {
                this._stream.setIdleTimeout(idleTO);
            }
            HandlerInvoker handlerInvoker = this._handlerInvoker;
            return handlerInvoker;
        }
    }

    @Override
    public Request getRequest() {
        try (AutoLock ignored = this._lock.lock();){
            ChannelRequest channelRequest = this._request;
            return channelRequest;
        }
    }

    public Response getResponse() {
        try (AutoLock ignored = this._lock.lock();){
            ChannelResponse channelResponse = this._response;
            return channelResponse;
        }
    }

    @Override
    public boolean isRequestHandled() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._handling != null || this._handled;
            return bl;
        }
    }

    @Override
    public Runnable onContentAvailable() {
        Runnable onContent;
        try (AutoLock ignored = this._lock.lock();){
            if (this._request == null) {
                Runnable runnable = null;
                return runnable;
            }
            onContent = this._onContentAvailable;
            this._onContentAvailable = null;
        }
        return this._serializedInvoker.offer(onContent);
    }

    public Invocable.InvocationType getInvocationType() {
        Runnable onContent;
        try (AutoLock ignored = this._lock.lock();){
            if (this._request == null) {
                Invocable.InvocationType invocationType = null;
                return invocationType;
            }
            onContent = this._onContentAvailable;
        }
        return Invocable.getInvocationType((Object)onContent);
    }

    @Override
    public Runnable onIdleTimeout(TimeoutException t) {
        Predicate<TimeoutException> onIdleTimeout;
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onIdleTimeout {}", (Object)this, (Object)t);
            }
            onIdleTimeout = this._onIdleTimeout;
        }
        if (onIdleTimeout != null) {
            Runnable onIdle = () -> {
                Runnable task;
                if (onIdleTimeout.test(t) && (task = this.onFailure(t)) != null) {
                    task.run();
                }
            };
            return this._serializedInvoker.offer(onIdle);
        }
        return this.onFailure(t);
    }

    @Override
    public Runnable onFailure(Throwable x) {
        Runnable task;
        HttpStream stream;
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onFailure {}", (Object)this, (Object)x);
            }
            if (this._stream == null) {
                Runnable runnable = null;
                return runnable;
            }
            stream = this._stream;
            if (this._request == null) {
                MetaData.Request errorRequest = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"/"), HttpVersion.HTTP_1_0, HttpFields.EMPTY);
                this._request = new ChannelRequest(this, errorRequest);
                this._response = new ChannelResponse(this._request);
            }
            if (this._failure == null) {
                this._failure = Content.Chunk.from((Throwable)x);
            } else if (ExceptionUtil.areNotAssociated((Throwable)this._failure.getCause(), (Throwable)x) && this._failure.getCause().getClass() != x.getClass()) {
                this._failure.getCause().addSuppressed(x);
            }
            if (!this._handled && this._handling == null) {
                task = () -> this._request._callback.failed(x);
            } else {
                Runnable invokeOnContentAvailable = this._onContentAvailable;
                this._onContentAvailable = null;
                Runnable invokeWriteFailure = this._response.lockedFailWrite(x);
                ChannelRequest request = this._request;
                Runnable invokeListeners = () -> {
                    block12: {
                        Consumer<Throwable> onFailure;
                        try (AutoLock ignore = this._lock.lock();){
                            onFailure = this._onFailure;
                        }
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("invokeListeners {} {}", new Object[]{this, onFailure, x});
                            }
                            onFailure.accept(x);
                        }
                        catch (Throwable throwable) {
                            if (!ExceptionUtil.areNotAssociated((Throwable)x, (Throwable)throwable)) break block12;
                            x.addSuppressed(throwable);
                        }
                    }
                    if (invokeOnContentAvailable == null && invokeWriteFailure == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("failing callback in {}", (Object)this, (Object)x);
                        }
                        request._callback.failed(x);
                    }
                };
                task = this._serializedInvoker.offer(new Runnable[]{invokeOnContentAvailable, invokeWriteFailure, invokeListeners});
            }
        }
        Throwable unconsumed = stream.consumeAvailable();
        if (unconsumed != null && LOG.isDebugEnabled()) {
            LOG.debug("consuming content during error {}", (Object)unconsumed.toString());
        }
        return task;
    }

    public void addHttpStreamWrapper(Function<HttpStream, HttpStream> onStreamEvent) {
        while (true) {
            HttpStream stream;
            try (AutoLock ignored = this._lock.lock();){
                stream = this._stream;
            }
            if (this._stream == null) {
                throw new IllegalStateException("No active stream");
            }
            HttpStream combined = onStreamEvent.apply(stream);
            if (combined == null) {
                throw new IllegalArgumentException("Cannot remove stream");
            }
            AutoLock ignored = this._lock.lock();
            try {
                if (this._stream != stream) continue;
                this._stream = combined;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
                continue;
            }
            break;
        }
    }

    private void resetResponse() {
        try (AutoLock ignored = this._lock.lock();){
            if (this._responseHeaders.isCommitted()) {
                throw new IllegalStateException("response committed");
            }
            this._responseHeaders.clear();
        }
    }

    private Throwable lockedStreamSend(boolean last, long length) {
        assert (this._lock.isHeldByCurrentThread());
        return switch (this._streamSendState) {
            default -> throw new IncompatibleClassChangeError();
            case StreamSendState.SENDING -> {
                this._streamSendState = last ? StreamSendState.LAST_SENDING : StreamSendState.SENDING;
                yield null;
            }
            case StreamSendState.LAST_SENDING, StreamSendState.LAST_COMPLETE -> length > 0L ? new IllegalStateException("last already written") : DO_NOT_SEND;
        };
    }

    private void lockedStreamSendCompleted(boolean success) {
        assert (this._lock.isHeldByCurrentThread());
        if (this._streamSendState == StreamSendState.LAST_SENDING) {
            this._streamSendState = success ? StreamSendState.LAST_COMPLETE : StreamSendState.SENDING;
        }
    }

    private boolean lockedIsLastStreamSendCompleted() {
        assert (this._lock.isHeldByCurrentThread());
        return this._streamSendState == StreamSendState.LAST_COMPLETE;
    }

    private boolean lockedLastStreamSend() {
        assert (this._lock.isHeldByCurrentThread());
        if (this._streamSendState != StreamSendState.SENDING) {
            return false;
        }
        this._streamSendState = StreamSendState.LAST_SENDING;
        return true;
    }

    public String toString() {
        try (AutoLock ignored = this._lock.lock();){
            String string = String.format("%s@%x{handling=%s, handled=%b, send=%s, completed=%b, request=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._handling, this._handled, this._streamSendState, this._callbackCompleted, this._request});
            return string;
        }
    }

    private class HandlerInvoker
    implements Invocable.Task,
    Callback {
        private HandlerInvoker() {
        }

        public void run() {
            boolean completeStream;
            boolean callbackCompleted;
            Throwable failure;
            HttpStream stream;
            ChannelResponse response;
            ChannelRequest request;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                assert (HttpChannelState.this._handling == null && !HttpChannelState.this._handled);
                HttpChannelState.this._handling = Thread.currentThread();
                request = HttpChannelState.this._request;
                response = HttpChannelState.this._response;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("invoking handler in {}", (Object)HttpChannelState.this);
            }
            Server server = HttpChannelState.this._connectionMetaData.getConnector().getServer();
            try {
                String badMessage;
                if (!(HttpMethod.PRI.is(request.getMethod()) || HttpMethod.CONNECT.is(request.getMethod()) || Request.getPathInContext(HttpChannelState.this._request).startsWith("/") || HttpMethod.OPTIONS.is(request.getMethod()))) {
                    throw new BadMessageException("Bad URI path");
                }
                HttpURI uri = request.getHttpURI();
                if (uri.hasViolations() && (badMessage = UriCompliance.checkUriCompliance((UriCompliance)HttpChannelState.this.getConnectionMetaData().getHttpConfiguration().getUriCompliance(), (HttpURI)uri)) != null) {
                    throw new BadMessageException(badMessage);
                }
                HttpConfiguration configuration = HttpChannelState.this.getHttpConfiguration();
                ChannelRequest customized = request;
                HttpFields.Mutable responseHeaders = response.getHeaders();
                for (HttpConfiguration.Customizer customizer : configuration.getCustomizers()) {
                    Request next = customizer.customize(customized, responseHeaders);
                    customized = next == null ? customized : next;
                }
                if (customized != request && server.getRequestLog() != null) {
                    request.setLoggedRequest(customized);
                }
                if (!server.handle(customized, response, request._callback)) {
                    Response.writeError((Request)customized, (Response)response, (Callback)request._callback, 404);
                }
            }
            catch (Throwable t) {
                request._callback.failed(t);
            }
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                stream = HttpChannelState.this._stream;
                HttpChannelState.this._handling = null;
                HttpChannelState.this._handled = true;
                failure = HttpChannelState.this._callbackFailure;
                callbackCompleted = HttpChannelState.this._callbackCompleted;
                boolean lastStreamSendComplete = HttpChannelState.this.lockedIsLastStreamSendCompleted();
                boolean bl = completeStream = callbackCompleted && lastStreamSendComplete;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handler invoked: completeStream={} failure={} callbackCompleted={} {}", new Object[]{completeStream, failure, callbackCompleted, HttpChannelState.this});
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("stream={}, failure={}, callbackCompleted={}, completeStream={}", new Object[]{stream, failure, callbackCompleted, completeStream});
            }
            if (completeStream) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("completeStream({}, {})", (Object)stream, (Object)Objects.toString(failure));
                }
                this.completeStream(stream, failure);
            }
        }

        public void succeeded() {
            HttpStream stream;
            boolean completeStream;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                assert (HttpChannelState.this._callbackCompleted);
                HttpChannelState.this._streamSendState = StreamSendState.LAST_COMPLETE;
                completeStream = HttpChannelState.this._handling == null;
                stream = HttpChannelState.this._stream;
            }
            if (completeStream) {
                this.completeStream(stream, null);
            }
        }

        public void failed(Throwable failure) {
            HttpStream stream;
            boolean completeStream;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                assert (HttpChannelState.this._callbackCompleted);
                HttpChannelState.this._streamSendState = StreamSendState.LAST_COMPLETE;
                completeStream = HttpChannelState.this._handling == null;
                stream = HttpChannelState.this._stream;
                failure = HttpChannelState.this._callbackFailure = ExceptionUtil.combine((Throwable)HttpChannelState.this._callbackFailure, (Throwable)failure);
            }
            if (completeStream) {
                this.completeStream(stream, failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeStream(HttpStream stream, Throwable failure) {
            try {
                long idleTO;
                MultiPartFormData.Parts parts;
                RequestLog requestLog = HttpChannelState.this.getServer().getRequestLog();
                if (requestLog != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("logging {}", (Object)HttpChannelState.this);
                    }
                    requestLog.log(HttpChannelState.this._request.getLoggedRequest(), HttpChannelState.this._response);
                }
                if ((parts = (MultiPartFormData.Parts)HttpChannelState.this._request.getAttribute(MultiPartFormData.Parts.class.getName())) != null) {
                    parts.close();
                }
                if ((idleTO = HttpChannelState.this.getHttpConfiguration().getIdleTimeout()) > 0L && HttpChannelState.this._oldIdleTimeout != idleTO) {
                    stream.setIdleTimeout(HttpChannelState.this._oldIdleTimeout);
                }
            }
            finally {
                if (failure == null) {
                    stream.succeeded();
                } else {
                    stream.failed(failure);
                }
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return HttpChannelState.this.getConnectionMetaData().getConnector().getServer().getInvocationType();
        }
    }

    private static enum StreamSendState {
        SENDING,
        LAST_SENDING,
        LAST_COMPLETE;

    }

    private class HttpChannelSerializedInvoker
    extends SerializedInvoker {
        private HttpChannelSerializedInvoker() {
        }

        protected void onError(Runnable task, Throwable failure) {
            Content.Chunk.Error error;
            ChannelRequest request;
            boolean callbackCompleted;
            try (AutoLock ignore = HttpChannelState.this._lock.lock();){
                callbackCompleted = HttpChannelState.this._callbackCompleted;
                request = HttpChannelState.this._request;
                error = HttpChannelState.this._request == null ? null : HttpChannelState.this._failure;
            }
            if (request == null || callbackCompleted) {
                super.onError(task, failure);
            } else if (error == null) {
                try {
                    request._callback.failed(failure);
                }
                catch (Throwable t) {
                    if (ExceptionUtil.areNotAssociated((Throwable)failure, (Throwable)t)) {
                        failure.addSuppressed(t);
                    }
                    super.onError(task, failure);
                }
            } else {
                Throwable cause = error.getCause();
                if (ExceptionUtil.areNotAssociated((Throwable)cause, (Throwable)failure)) {
                    error.getCause().addSuppressed(failure);
                }
            }
        }
    }

    public static class ChannelRequest
    implements Attributes,
    Request {
        private final long _headersNanoTime = NanoTime.now();
        private final ChannelCallback _callback = new ChannelCallback(this);
        private final String _id;
        private final ConnectionMetaData _connectionMetaData;
        private final MetaData.Request _metaData;
        private final AutoLock _lock;
        private final LongAdder _contentBytesRead = new LongAdder();
        private HttpChannelState _httpChannelState;
        private Request _loggedRequest;
        private HttpFields _trailers;

        ChannelRequest(HttpChannelState httpChannelState, MetaData.Request metaData) {
            this._httpChannelState = Objects.requireNonNull(httpChannelState);
            this._id = httpChannelState.getHttpStream().getId();
            this._connectionMetaData = httpChannelState.getConnectionMetaData();
            this._metaData = Objects.requireNonNull(metaData);
            this._lock = httpChannelState._lock;
        }

        public void setLoggedRequest(Request request) {
            this._loggedRequest = request;
        }

        public Request getLoggedRequest() {
            return this._loggedRequest == null ? this : this._loggedRequest;
        }

        HttpStream getHttpStream() {
            return this.getHttpChannelState()._stream;
        }

        public long getContentBytesRead() {
            return this._contentBytesRead.longValue();
        }

        public Object getAttribute(String name) {
            HttpChannelState httpChannel = this.getHttpChannelState();
            if (name.startsWith("org.eclipse.jetty")) {
                if (Server.class.getName().equals(name)) {
                    return httpChannel.getConnectionMetaData().getConnector().getServer();
                }
                if (HttpChannelState.class.getName().equals(name)) {
                    return httpChannel;
                }
                if (HttpConnection.class.getName().equals(name) && this.getConnectionMetaData().getConnection() instanceof HttpConnection) {
                    return this.getConnectionMetaData().getConnection();
                }
            }
            return httpChannel._requestAttributes.getAttribute(name);
        }

        public Object removeAttribute(String name) {
            return this.getHttpChannelState()._requestAttributes.removeAttribute(name);
        }

        public Object setAttribute(String name, Object attribute) {
            if (Server.class.getName().equals(name) || HttpChannelState.class.getName().equals(name) || HttpConnection.class.getName().equals(name)) {
                return null;
            }
            return this.getHttpChannelState()._requestAttributes.setAttribute(name, attribute);
        }

        public Set<String> getAttributeNameSet() {
            return this.getHttpChannelState()._requestAttributes.getAttributeNameSet();
        }

        public void clearAttributes() {
            this.getHttpChannelState()._requestAttributes.clearAttributes();
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public Components getComponents() {
            return this.getHttpChannelState();
        }

        @Override
        public ConnectionMetaData getConnectionMetaData() {
            return this._connectionMetaData;
        }

        HttpChannelState getHttpChannelState() {
            try (AutoLock ignore = this._lock.lock();){
                HttpChannelState httpChannelState = this.lockedGetHttpChannelState();
                return httpChannelState;
            }
        }

        private HttpChannelState lockedGetHttpChannelState() {
            assert (this._lock.isHeldByCurrentThread());
            if (this._httpChannelState == null) {
                throw new IllegalStateException("channel already completed");
            }
            return this._httpChannelState;
        }

        @Override
        public String getMethod() {
            return this._metaData.getMethod();
        }

        @Override
        public HttpURI getHttpURI() {
            return this._metaData.getHttpURI();
        }

        @Override
        public Context getContext() {
            return this.getConnectionMetaData().getConnector().getServer().getContext();
        }

        @Override
        public HttpFields getHeaders() {
            return this._metaData.getHttpFields();
        }

        @Override
        public HttpFields getTrailers() {
            return this._trailers;
        }

        @Override
        public long getBeginNanoTime() {
            return this._metaData.getBeginNanoTime();
        }

        @Override
        public long getHeadersNanoTime() {
            return this._headersNanoTime;
        }

        @Override
        public boolean isSecure() {
            return HttpScheme.HTTPS.is(this.getHttpURI().getScheme());
        }

        public long getLength() {
            return this._metaData.getContentLength();
        }

        @Override
        public Content.Chunk read() {
            HttpStream stream;
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                Content.Chunk.Error error = httpChannel._failure;
                if (error != null) {
                    Content.Chunk.Error error2 = error;
                    return error2;
                }
                stream = httpChannel._stream;
            }
            Content.Chunk chunk = stream.read();
            if (LOG.isDebugEnabled()) {
                LOG.debug("read {}", (Object)chunk);
            }
            if (chunk != null && chunk.hasRemaining()) {
                this._contentBytesRead.add(chunk.getByteBuffer().remaining());
            }
            if (chunk instanceof Trailers) {
                Trailers trailers = (Trailers)chunk;
                this._trailers = trailers.getTrailers();
            }
            return chunk;
        }

        @Override
        public boolean consumeAvailable() {
            HttpStream stream;
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                stream = httpChannel._stream;
            }
            return stream.consumeAvailable() == null;
        }

        @Override
        public void demand(Runnable demandCallback) {
            HttpStream stream;
            boolean error;
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("demand {}", (Object)httpChannel);
                }
                boolean bl = error = httpChannel._failure != null;
                if (!error) {
                    if (httpChannel._onContentAvailable != null) {
                        throw new IllegalArgumentException("demand pending");
                    }
                    httpChannel._onContentAvailable = demandCallback;
                }
                stream = httpChannel._stream;
            }
            if (error) {
                this.getHttpChannelState()._serializedInvoker.run(demandCallback);
            } else {
                stream.demand();
            }
        }

        public void fail(Throwable failure) {
            this._httpChannelState.onFailure(failure);
        }

        @Override
        public void push(MetaData.Request resource) {
            this.getHttpStream().push(resource);
        }

        @Override
        public void addIdleTimeoutListener(Predicate<TimeoutException> onIdleTimeout) {
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                if (httpChannel._failure != null) {
                    return;
                }
                if (httpChannel._onIdleTimeout == null) {
                    httpChannel._onIdleTimeout = onIdleTimeout;
                } else {
                    Predicate<TimeoutException> previous = httpChannel._onIdleTimeout;
                    httpChannel._onIdleTimeout = throwable -> {
                        if (!previous.test((TimeoutException)throwable)) {
                            return onIdleTimeout.test((TimeoutException)throwable);
                        }
                        return true;
                    };
                }
            }
        }

        @Override
        public void addFailureListener(Consumer<Throwable> onFailure) {
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                if (httpChannel._failure != null) {
                    return;
                }
                if (httpChannel._onFailure == null) {
                    httpChannel._onFailure = onFailure;
                } else {
                    Consumer<Throwable> previous = httpChannel._onFailure;
                    httpChannel._onFailure = throwable -> {
                        try {
                            previous.accept((Throwable)throwable);
                        }
                        catch (Throwable t) {
                            if (ExceptionUtil.areNotAssociated((Throwable)throwable, (Throwable)t)) {
                                throwable.addSuppressed(t);
                            }
                        }
                        finally {
                            onFailure.accept((Throwable)throwable);
                        }
                    };
                }
            }
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return this.getHttpStream().getTunnelSupport();
        }

        @Override
        public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
            this.getHttpChannelState().addHttpStreamWrapper(wrapper);
        }

        @Override
        public Session getSession(boolean create) {
            return null;
        }

        public String toString() {
            return String.format("%s@%x %s %s", this.getMethod(), this.hashCode(), this.getHttpURI(), this._metaData.getHttpVersion());
        }
    }

    public static class ChannelResponse
    implements Response,
    Callback {
        private final ChannelRequest _request;
        private final ResponseHttpFields _httpFields;
        protected int _status;
        private long _contentBytesWritten;
        private Supplier<HttpFields> _trailers;
        private Callback _writeCallback;

        private ChannelResponse(ChannelRequest request) {
            this._request = request;
            this._httpFields = this.getResponseHttpFields(this._request.lockedGetHttpChannelState());
        }

        protected ResponseHttpFields getResponseHttpFields(HttpChannelState httpChannelState) {
            return httpChannelState._responseHeaders;
        }

        protected ResponseHttpFields getResponseHttpFields() {
            return this._httpFields;
        }

        private boolean lockedIsWriting() {
            assert (this._request._lock.isHeldByCurrentThread());
            return this._writeCallback != null;
        }

        private Runnable lockedFailWrite(Throwable x) {
            assert (this._request._lock.isHeldByCurrentThread());
            Callback writeCallback = this._writeCallback;
            this._writeCallback = null;
            return writeCallback == null ? null : () -> writeCallback.failed(x);
        }

        public long getContentBytesWritten() {
            return this._contentBytesWritten;
        }

        @Override
        public Request getRequest() {
            return this._request;
        }

        @Override
        public int getStatus() {
            return this._status;
        }

        @Override
        public void setStatus(int code) {
            if (!this.isCommitted()) {
                this._status = code;
            }
        }

        @Override
        public HttpFields.Mutable getHeaders() {
            return this._httpFields;
        }

        @Override
        public Supplier<HttpFields> getTrailersSupplier() {
            try (AutoLock ignored = this._request._lock.lock();){
                Supplier<HttpFields> supplier = this._trailers;
                return supplier;
            }
        }

        @Override
        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
            try (AutoLock ignored = this._request._lock.lock();){
                this._trailers = trailers;
            }
        }

        @Override
        public void write(boolean last, ByteBuffer content, Callback callback) {
            long length = BufferUtil.length((ByteBuffer)content);
            HttpStream stream = null;
            Throwable failure = null;
            MetaData.Response responseMetaData = null;
            try (AutoLock ignored = this._request._lock.lock();){
                long contentLength;
                HttpChannelState httpChannelState = this._request.lockedGetHttpChannelState();
                long committedContentLength = httpChannelState._committedContentLength;
                long totalWritten = this._contentBytesWritten + length;
                long l = contentLength = committedContentLength >= 0L ? committedContentLength : this.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH);
                if (this._writeCallback != null) {
                    failure = new IllegalStateException("write pending");
                } else {
                    failure = this.getFailure(httpChannelState);
                    if (failure == null && contentLength >= 0L) {
                        String lengthError;
                        String string = totalWritten > contentLength ? "written %d > %d content-length" : (lengthError = last && totalWritten < contentLength ? "written %d < %d content-length" : null);
                        if (lengthError != null) {
                            String message = lengthError.formatted(totalWritten, contentLength);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("fail {} {}", (Object)callback, (Object)message);
                            }
                            failure = new IOException(message);
                        }
                    }
                }
                if (failure == null) {
                    failure = httpChannelState.lockedStreamSend(last, length);
                }
                if (failure == DO_NOT_SEND) {
                    httpChannelState._serializedInvoker.run(() -> ((Callback)callback).succeeded());
                } else if (failure != null) {
                    Throwable throwable = failure;
                    httpChannelState._serializedInvoker.run(() -> callback.failed(throwable));
                } else {
                    this._writeCallback = callback;
                    this._contentBytesWritten = totalWritten;
                    stream = httpChannelState._stream;
                    if (this._httpFields.commit()) {
                        responseMetaData = this.lockedPrepareResponse(httpChannelState, last);
                    }
                }
            }
            if (failure == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("writing last={} {} {}", new Object[]{last, BufferUtil.toDetailString((ByteBuffer)content), this});
                }
                stream.send(this._request._metaData, responseMetaData, last, content, this);
            }
        }

        protected Throwable getFailure(HttpChannelState httpChannelState) {
            Content.Chunk.Error failure = httpChannelState._failure;
            return failure == null ? null : failure.getCause();
        }

        public void succeeded() {
            Callback callback;
            HttpChannelState httpChannel;
            if (LOG.isDebugEnabled()) {
                LOG.debug("write succeeded {}", (Object)this);
            }
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannel = this._request.lockedGetHttpChannelState();
                callback = this._writeCallback;
                this._writeCallback = null;
                httpChannel.lockedStreamSendCompleted(true);
            }
            if (callback != null) {
                httpChannel._serializedInvoker.run(() -> ((Callback)callback).succeeded());
            }
        }

        public void failed(Throwable x) {
            Callback callback;
            HttpChannelState httpChannel;
            if (LOG.isDebugEnabled()) {
                LOG.debug("write failed {}", (Object)this, (Object)x);
            }
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannel = this._request.lockedGetHttpChannelState();
                callback = this._writeCallback;
                this._writeCallback = null;
                httpChannel.lockedStreamSendCompleted(false);
            }
            if (callback != null) {
                httpChannel._serializedInvoker.run(() -> callback.failed(x));
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType((Object)this._writeCallback);
        }

        @Override
        public boolean isCommitted() {
            return this._httpFields.isCommitted();
        }

        @Override
        public boolean isCompletedSuccessfully() {
            try (AutoLock ignored = this._request._lock.lock();){
                if (this._request._httpChannelState == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this._request._httpChannelState._callbackCompleted && this._request._httpChannelState._callbackFailure == null;
                return bl;
            }
        }

        @Override
        public void reset() {
            this._status = 0;
            this._trailers = null;
            this._contentBytesWritten = 0L;
            this._request.getHttpChannelState().resetResponse();
        }

        @Override
        public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
            Callback.Completable completable = new Callback.Completable();
            if (HttpStatus.isInterim((int)status)) {
                HttpChannelState channel = this._request.getHttpChannelState();
                HttpVersion version = channel.getConnectionMetaData().getHttpVersion();
                MetaData.Response response = new MetaData.Response(status, null, version, headers);
                channel._stream.send(this._request._metaData, response, false, null, (Callback)completable);
            } else {
                completable.failed((Throwable)new IllegalArgumentException("Invalid interim status code: " + status));
            }
            return completable;
        }

        MetaData.Response lockedPrepareResponse(HttpChannelState httpChannel, boolean last) {
            if (this._status == 0) {
                this._status = 200;
            }
            HttpFields.Mutable mutableHeaders = this._httpFields.getMutableHttpFields();
            httpChannel._committedContentLength = mutableHeaders.getLongField(HttpHeader.CONTENT_LENGTH);
            if (last && httpChannel._committedContentLength < 0L) {
                httpChannel._committedContentLength = this._contentBytesWritten;
                mutableHeaders.put(HttpHeader.CONTENT_LENGTH, httpChannel._committedContentLength);
            }
            httpChannel._stream.prepareResponse(mutableHeaders);
            return new MetaData.Response(this._status, null, httpChannel.getConnectionMetaData().getHttpVersion(), (HttpFields)this._httpFields, httpChannel._committedContentLength, this.getTrailersSupplier());
        }

        public String toString() {
            return "%s@%x{%s,%s}".formatted(this.getClass().getSimpleName(), this.hashCode(), this.getStatus(), this.getRequest());
        }
    }

    private static class ChannelCallback
    implements Callback {
        private final ChannelRequest _request;
        private Throwable _completedBy;

        private ChannelCallback(ChannelRequest request) {
            this._request = request;
        }

        public void succeeded() {
            boolean completeStream;
            boolean needLastStreamSend;
            HttpStream stream;
            HttpChannelState httpChannelState;
            ChannelRequest request;
            Throwable failure = null;
            MetaData.Response responseMetaData = null;
            ErrorResponse errorResponse = null;
            try (AutoLock ignored = this._request._lock.lock();){
                request = this._request;
                httpChannelState = this._request._httpChannelState;
                ChannelResponse response = httpChannelState._response;
                stream = httpChannelState._stream;
                if (httpChannelState._onContentAvailable != null) {
                    throw new IllegalStateException("demand pending");
                }
                if (response.lockedIsWriting()) {
                    throw new IllegalStateException("write pending");
                }
                if (this.lockedCompleteCallback()) {
                    return;
                }
                assert (httpChannelState._callbackFailure == null);
                needLastStreamSend = httpChannelState.lockedLastStreamSend();
                boolean bl = completeStream = !needLastStreamSend && httpChannelState._handling == null && httpChannelState.lockedIsLastStreamSendCompleted();
                if (httpChannelState._responseHeaders.commit()) {
                    responseMetaData = response.lockedPrepareResponse(httpChannelState, true);
                }
                long totalWritten = response._contentBytesWritten;
                long committedContentLength = httpChannelState._committedContentLength;
                if (committedContentLength >= 0L && committedContentLength != totalWritten) {
                    failure = new IOException("content-length %d != %d written".formatted(committedContentLength, totalWritten));
                }
                Throwable unconsumed = stream.consumeAvailable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("consumeAvailable: {} {} ", (Object)(unconsumed == null ? 1 : 0), (Object)httpChannelState);
                }
                if (unconsumed != null && httpChannelState.getConnectionMetaData().isPersistent()) {
                    failure = ExceptionUtil.combine(failure, (Throwable)unconsumed);
                }
                if (failure != null) {
                    httpChannelState._callbackFailure = failure;
                    if (!stream.isCommitted()) {
                        errorResponse = new ErrorResponse(request);
                    } else {
                        completeStream = true;
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("succeeded: failure={} needLastStreamSend={} {}", new Object[]{failure, needLastStreamSend, this});
            }
            if (errorResponse != null) {
                Response.writeError((Request)request, (Response)errorResponse, (Callback)new ErrorCallback(request, errorResponse, stream, failure), failure);
            } else if (needLastStreamSend) {
                stream.send(this._request._metaData, responseMetaData, true, null, httpChannelState._handlerInvoker);
            } else if (completeStream) {
                httpChannelState._handlerInvoker.completeStream(stream, failure);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No action on succeeded {}", (Object)this);
            }
        }

        public void failed(Throwable failure) {
            ChannelRequest request;
            HttpStream stream;
            ErrorResponse errorResponse = null;
            try (AutoLock ignored = this._request._lock.lock();){
                HttpChannelState httpChannelState = this._request._httpChannelState;
                stream = httpChannelState._stream;
                request = this._request;
                if (this.lockedCompleteCallback()) {
                    return;
                }
                assert (httpChannelState._callbackFailure == null);
                httpChannelState._callbackFailure = failure;
                Throwable unconsumed = stream.consumeAvailable();
                if (ExceptionUtil.areNotAssociated((Throwable)unconsumed, (Throwable)failure)) {
                    failure.addSuppressed(unconsumed);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("failed stream.isCommitted={}, response.isCommitted={} {}", new Object[]{httpChannelState._stream.isCommitted(), httpChannelState._response.isCommitted(), this});
                }
                if (!stream.isCommitted()) {
                    errorResponse = new ErrorResponse(request);
                }
            }
            if (errorResponse != null) {
                Response.writeError((Request)request, (Response)errorResponse, (Callback)new ErrorCallback(request, errorResponse, stream, failure), failure);
            } else {
                this._request.getHttpChannelState()._handlerInvoker.failed(failure);
            }
        }

        private boolean lockedCompleteCallback() {
            assert (this._request._lock.isHeldByCurrentThread());
            HttpChannelState httpChannelState = this._request._httpChannelState;
            if (httpChannelState == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("already recycled after completion {} by", (Object)this._request, (Object)this._completedBy);
                }
                return true;
            }
            if (httpChannelState._callbackCompleted) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("already completed {} by", (Object)this._request, (Object)this._completedBy);
                    LOG.debug("Second complete", new Throwable("second complete"));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                this._completedBy = new Throwable(Thread.currentThread().getName());
            }
            httpChannelState._callbackCompleted = true;
            return false;
        }

        public Invocable.InvocationType getInvocationType() {
            return this._request.getHttpStream().getInvocationType();
        }
    }

    private static class ErrorCallback
    implements Callback {
        private final ChannelRequest _request;
        private final ErrorResponse _errorResponse;
        private final HttpStream _stream;
        private final Throwable _failure;

        public ErrorCallback(ChannelRequest request, ErrorResponse response, HttpStream stream, Throwable failure) {
            this._request = request;
            this._errorResponse = response;
            this._stream = stream;
            this._failure = failure;
        }

        public void succeeded() {
            boolean needLastWrite;
            Throwable failure;
            HttpChannelState httpChannelState;
            if (LOG.isDebugEnabled()) {
                LOG.debug("ErrorWrite succeeded: {}", (Object)this);
            }
            MetaData.Response responseMetaData = null;
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannelState = this._request.getHttpChannelState();
                failure = this._failure;
                needLastWrite = httpChannelState.lockedLastStreamSend();
                if (needLastWrite && this._errorResponse.getResponseHttpFields().commit()) {
                    responseMetaData = this._errorResponse.lockedPrepareResponse(httpChannelState, true);
                }
            }
            if (needLastWrite) {
                this._stream.send(this._request._metaData, responseMetaData, true, null, Callback.from(() -> httpChannelState._handlerInvoker.failed(failure), x -> {
                    if (ExceptionUtil.areNotAssociated((Throwable)failure, (Throwable)x)) {
                        failure.addSuppressed((Throwable)x);
                    }
                    httpChannelState._handlerInvoker.failed(failure);
                }));
            } else {
                httpChannelState._handlerInvoker.failed(failure);
            }
        }

        public void failed(Throwable x) {
            HttpChannelState httpChannelState;
            Throwable failure;
            if (LOG.isDebugEnabled()) {
                LOG.debug("ErrorWrite failed: {}", (Object)this, (Object)x);
            }
            try (AutoLock ignored = this._request._lock.lock();){
                failure = this._failure;
                httpChannelState = this._request.lockedGetHttpChannelState();
                httpChannelState._response._status = this._errorResponse._status;
            }
            if (ExceptionUtil.areNotAssociated((Throwable)failure, (Throwable)x)) {
                failure.addSuppressed(x);
            }
            httpChannelState._handlerInvoker.failed(failure);
        }

        public String toString() {
            return "%s@%x".formatted(this.getClass().getSimpleName(), this.hashCode());
        }
    }

    private static class ErrorResponse
    extends ChannelResponse {
        public ErrorResponse(ChannelRequest request) {
            super(request);
            this._status = 500;
        }

        @Override
        protected Throwable getFailure(HttpChannelState httpChannelState) {
            return null;
        }

        @Override
        protected ResponseHttpFields getResponseHttpFields(HttpChannelState httpChannelState) {
            httpChannelState._committedContentLength = -1L;
            ResponseHttpFields original = super.getResponseHttpFields(httpChannelState);
            ResponseHttpFields httpFields = new ResponseHttpFields();
            Iterator iterator = original.iterator();
            while (iterator.hasNext()) {
                HttpField field = (HttpField)iterator.next();
                HttpHeader header = field.getHeader();
                if (header != HttpHeader.SERVER && header != HttpHeader.DATE) continue;
                httpFields.add(field);
            }
            return httpFields;
        }

        @Override
        MetaData.Response lockedPrepareResponse(HttpChannelState httpChannelState, boolean last) {
            MetaData.Response httpFields = super.lockedPrepareResponse(httpChannelState, last);
            httpChannelState._response._status = this._status;
            HttpFields.Mutable originalResponseFields = httpChannelState._responseHeaders.getMutableHttpFields();
            originalResponseFields.clear();
            originalResponseFields.add((HttpFields)this.getResponseHttpFields());
            return httpFields;
        }
    }
}

