/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHttpFields
implements HttpFields.Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHttpFields.class);
    private final HttpFields.Mutable _fields = HttpFields.build();
    private final AtomicBoolean _committed = new AtomicBoolean();

    public HttpFields.Mutable getMutableHttpFields() {
        return this._fields;
    }

    public boolean commit() {
        boolean committed = this._committed.compareAndSet(false, true);
        if (committed && LOG.isDebugEnabled()) {
            LOG.debug("{} committed", (Object)this);
        }
        return committed;
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    public void reset() {
        this._committed.set(false);
        this._fields.clear();
    }

    public HttpField getField(int index) {
        return this._fields.getField(index);
    }

    public int size() {
        return this._fields.size();
    }

    public Stream<HttpField> stream() {
        return this._fields.stream();
    }

    public HttpFields takeAsImmutable() {
        if (this._committed.get()) {
            return this;
        }
        return this._fields.asImmutable();
    }

    public HttpFields.Mutable add(HttpField field) {
        if (field != null && !this._committed.get()) {
            this._fields.add(field);
        }
        return this;
    }

    public HttpFields asImmutable() {
        return this._committed.get() ? this : this._fields.asImmutable();
    }

    public HttpFields.Mutable clear() {
        return this._committed.get() ? this : this._fields.clear();
    }

    public void ensureField(HttpField field) {
        if (!this._committed.get()) {
            this._fields.ensureField(field);
        }
    }

    public Iterator<HttpField> iterator() {
        final Iterator i = this._fields.iterator();
        return new Iterator<HttpField>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public HttpField next() {
                return (HttpField)i.next();
            }

            @Override
            public void remove() {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                i.remove();
            }
        };
    }

    public ListIterator<HttpField> listIterator() {
        final ListIterator i = this._fields.listIterator();
        return new ListIterator<HttpField>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public HttpField next() {
                return (HttpField)i.next();
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public HttpField previous() {
                return (HttpField)i.previous();
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                i.remove();
            }

            @Override
            public void set(HttpField field) {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                if (field == null) {
                    i.remove();
                } else {
                    i.set(field);
                }
            }

            @Override
            public void add(HttpField field) {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                if (field != null) {
                    i.add(field);
                }
            }
        };
    }

    public String toString() {
        return this._fields.toString();
    }
}

