/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.Deployable;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContextHandler
extends ContextHandler
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(CoreContextHandler.class);
    private static final String ORIGINAL_BASE_RESOURCE = "org.eclipse.jetty.webapp.originalBaseResource";
    private boolean _initialized = false;
    private List<Resource> _extraClasspath;
    private ClassLoader _previousClassLoader;
    private Boolean deferredDirAllowed;

    public CoreContextHandler() {
        this((String)null);
    }

    public CoreContextHandler(String contextPath) {
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
    }

    @ManagedAttribute(value="extra classpath for context classloader", readonly=true)
    public List<Resource> getExtraClasspath() {
        return this._extraClasspath == null ? Collections.emptyList() : this._extraClasspath;
    }

    @Override
    protected void initializeDefault(String keyName, Object value) {
        switch (keyName) {
            case "jetty.deploy.baseResource.dirAllowed": {
                if (value instanceof String) {
                    String str = (String)value;
                    this.setDirAllowed(Boolean.parseBoolean(str));
                    break;
                }
                if (!(value instanceof Boolean)) break;
                Boolean bool = (Boolean)value;
                this.setDirAllowed(bool);
                break;
            }
            case "jetty.deploy.paths.main": {
                Path mainPath = (Path)value;
                if (!Files.isDirectory(mainPath, new LinkOption[0]) && !FileID.isArchive((Path)mainPath)) break;
                ResourceFactory resourceFactory = ResourceFactory.of((Container)this);
                Resource baseResource = resourceFactory.newResource((Path)value);
                this.setBaseResource(baseResource);
                break;
            }
            case "jetty.deploy.paths.other": {
                Collection deployablePaths = (Collection)value;
                Path mainDir = null;
                for (Path path : deployablePaths) {
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    if (mainDir == null) {
                        mainDir = path;
                        continue;
                    }
                    throw new IllegalArgumentException("More than one directory is not supported: " + deployablePaths.stream().map(Path::toString).collect(Collectors.joining(", ", "[", "]")));
                }
                if (mainDir == null) break;
                ResourceFactory resourceFactory = ResourceFactory.of((Container)this);
                Resource resourceDir = resourceFactory.newResource(mainDir);
                this.setBaseResource(resourceDir);
            }
        }
    }

    private void setDirAllowed(Boolean bool) {
        ResourceHandler resourceHandler = (ResourceHandler)this.getBean(ResourceHandler.class);
        if (resourceHandler != null) {
            resourceHandler.setDirAllowed(bool);
        } else {
            this.deferredDirAllowed = bool;
        }
    }

    @Override
    protected void initializeDefaultsComplete() {
        try {
            this.initWebApp();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to init " + TypeUtil.toShortName(this.getClass()), e);
        }
    }

    public void setExtraClasspath(String extraClasspath) {
        this.setExtraClasspath(this.getResourceFactory().split(extraClasspath));
    }

    public void setExtraClasspath(List<Resource> extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public ResourceFactory getResourceFactory() {
        return ResourceFactory.of((Container)this);
    }

    @Override
    public void setBaseResource(Resource baseResource) {
        if (baseResource == null || Resources.isDirectory((Resource)baseResource)) {
            super.setBaseResource(baseResource);
            return;
        }
        if (Resources.isReadableFile((Resource)baseResource)) {
            URI uri = baseResource.getURI();
            if (FileID.isArchive((URI)uri)) {
                Resource jarResource = this.getResourceFactory().newJarFileResource(uri);
                super.setBaseResource(jarResource);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignored base resource: {}", (Object)baseResource);
            }
            return;
        }
        super.setBaseResource(baseResource);
    }

    protected Resource unpack(Resource dir) throws IOException {
        Path tempDir = this.getTempDirectory().toPath();
        dir.copyTo(tempDir);
        return ResourceFactory.of((Container)this).newResource(tempDir);
    }

    protected ClassLoader newClassLoader(Resource base, ClassLoader parentClassLoader) throws IOException {
        List<Resource> extraEntries;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (Resources.isDirectory((Resource)base)) {
            Resource classesDir;
            Resource libDir = base.resolve("lib");
            if (Resources.isDirectory((Resource)libDir)) {
                for (Resource entry : libDir.list()) {
                    URI uri = entry.getURI();
                    if (!FileID.isJavaArchive((URI)uri)) continue;
                    urls.add(uri.toURL());
                }
            }
            if (Resources.isDirectory((Resource)(classesDir = base.resolve("classes")))) {
                urls.add(classesDir.getURI().toURL());
            }
        }
        if ((extraEntries = this.getExtraClasspath()) != null && !extraEntries.isEmpty()) {
            for (Resource entry : extraEntries) {
                urls.add(entry.getURI().toURL());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Core webapp classloader: {}", urls);
        }
        if (urls.isEmpty()) {
            return parentClassLoader;
        }
        return new URLClassLoader((URL[])urls.toArray(URL[]::new), parentClassLoader);
    }

    protected void initWebApp() throws IOException {
        ClassLoader classLoader;
        Environment environment;
        Resource staticDir;
        if (this._initialized) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Already initialized, not initializing again");
            }
            return;
        }
        this._initialized = true;
        Resource baseResource = this.getBaseResource();
        if (baseResource == null) {
            return;
        }
        if (!Resources.isDirectory((Resource)baseResource)) {
            if (FileID.isArchive((URI)baseResource.getURI())) {
                this.setAttribute(ORIGINAL_BASE_RESOURCE, baseResource.getURI());
                try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();){
                    URI archiveURI = URIUtil.toJarFileUri((URI)baseResource.getURI());
                    Resource mountedArchive = resourceFactory.newResource(archiveURI);
                    baseResource = this.unpack(mountedArchive);
                    this.setBaseResource(baseResource);
                }
            } else {
                throw new IllegalArgumentException("Unrecognized non-directory base resource type: " + String.valueOf(baseResource));
            }
        }
        if (Resources.isDirectory((Resource)(staticDir = baseResource.resolve("static"))) && !this.isResourceHandlerAlreadyPresent(staticDir)) {
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setBaseResource(staticDir);
            if (this.deferredDirAllowed != null) {
                resourceHandler.setDirAllowed(this.deferredDirAllowed);
            }
            this.setHandler(resourceHandler);
        }
        if ((environment = Environment.get((String)"core")) == null) {
            throw new IllegalStateException("Could not find environment [core]");
        }
        this._previousClassLoader = classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = environment.getClassLoader();
        }
        this.setClassLoader(this.newClassLoader(baseResource, classLoader));
    }

    private boolean isResourceHandlerAlreadyPresent(Resource staticDir) {
        for (Handler handler : this.getHandlers()) {
            URI baseResourceURI;
            ResourceHandler resourceHandler;
            Resource baseResource;
            if (!(handler instanceof ResourceHandler) || (baseResource = (resourceHandler = (ResourceHandler)handler).getBaseResource()) == null || !(baseResourceURI = baseResource.getURI()).equals(staticDir.getURI())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        this.initWebApp();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._initialized = false;
        this.setClassLoader(this._previousClassLoader);
        this._previousClassLoader = null;
        super.doStop();
    }
}

