/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationEvent;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AsyncContext;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class AsyncRequest
implements AsyncContext,
Continuation {
    private static final int __IDLE = 0;
    private static final int __DISPATCHED = 1;
    private static final int __SUSPENDING = 2;
    private static final int __REDISPATCHING = 3;
    private static final int __SUSPENDED = 4;
    private static final int __UNSUSPENDING = 5;
    private static final int __REDISPATCHED = 6;
    private static final int __COMPLETING = 7;
    private static final int __UNCOMPLETED = 8;
    private static final int __COMPLETE = 9;
    protected HttpConnection _connection;
    private Object _listeners;
    private int _state = 0;
    private boolean _initial = true;
    private boolean _resumed;
    private boolean _expired;
    private boolean _keepWrappers;
    private long _timeoutMs;
    private AsyncEventState _event;

    protected AsyncRequest() {
    }

    protected void setConnection(HttpConnection connection) {
        this._connection = connection;
    }

    public void addContinuationListener(ContinuationListener listener) {
        this._listeners = LazyList.add((Object)this._listeners, (Object)listener);
    }

    public void setAsyncTimeout(long ms) {
        this._timeoutMs = ms;
    }

    public long getAsyncTimeout() {
        return this._timeoutMs;
    }

    public AsyncEventState getAsyncEventState() {
        return this._event;
    }

    public void keepWrappers() {
        this._keepWrappers = true;
    }

    public boolean wrappersKept() {
        return this._keepWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitial() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            return this._initial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            switch (this._state) {
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    return true;
                }
            }
            return false;
        }
    }

    public String toString() {
        return this.getStatusString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusString() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            return (this._state == 0 ? "IDLE" : (this._state == 1 ? "DISPATCHED" : (this._state == 2 ? "SUSPENDING" : (this._state == 4 ? "SUSPENDED" : (this._state == 3 ? "REDISPATCHING" : (this._state == 5 ? "UNSUSPENDING" : (this._state == 6 ? "REDISPATCHED" : (this._state == 7 ? "COMPLETING" : (this._state == 8 ? "UNCOMPLETED" : (this._state == 9 ? "COMPLETE" : "UNKNOWN?" + this._state)))))))))) + (this._initial ? ",initial" : "");
        }
    }

    protected boolean handling() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            this._keepWrappers = false;
            switch (this._state) {
                case 1: 
                case 6: 
                case 9: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 0: {
                    this._initial = true;
                    this._state = 1;
                    return true;
                }
                case 2: 
                case 3: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 7: {
                    this._state = 8;
                    return false;
                }
                case 4: {
                    this.cancelTimeout();
                }
                case 5: {
                    this._state = 6;
                    return true;
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    protected void suspend(ServletContext context, ServletRequest request, ServletResponse response) {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            this._resumed = false;
            this._expired = false;
            if (this._event == null || request != this._event.getRequest() || response != this._event.getResponse() || context != this._event.getServletContext()) {
                this._event = new AsyncEventState(context, request, response);
            } else {
                this._event._dispatchContext = null;
                this._event._path = null;
            }
            switch (this._state) {
                case 1: 
                case 6: {
                    this._state = 2;
                    return;
                }
                case 0: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: 
                case 3: {
                    return;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    protected boolean unhandle() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            switch (this._state) {
                case 1: 
                case 6: {
                    this._state = 8;
                    return true;
                }
                case 0: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: {
                    this._initial = false;
                    this._state = 4;
                    this.scheduleTimeout();
                    if (this._state == 4) {
                        return true;
                    }
                    if (this._state == 7) {
                        this._state = 8;
                        return true;
                    }
                    this._initial = false;
                    this._state = 6;
                    return false;
                }
                case 3: {
                    this._initial = false;
                    this._state = 6;
                    return false;
                }
                case 7: {
                    this._initial = false;
                    this._state = 8;
                    return true;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        boolean dispatch = false;
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            switch (this._state) {
                case 0: 
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return;
                }
                case 2: {
                    this._state = 3;
                    this._resumed = true;
                    return;
                }
                case 4: {
                    dispatch = true;
                    this._state = 5;
                    this._resumed = true;
                    break;
                }
                case 5: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expired() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            switch (this._state) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    return;
                }
            }
            this._expired = true;
        }
        if (this._listeners != null) {
            for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
                try {
                    ContinuationListener listener = (ContinuationListener)LazyList.get((Object)this._listeners, (int)i);
                    listener.onTimeout((ContinuationEvent)this._event);
                    continue;
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
            }
        }
        AsyncRequest asyncRequest2 = this;
        synchronized (asyncRequest2) {
            switch (this._state) {
                case 2: 
                case 4: {
                    this.dispatch();
                    return;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        boolean dispatch = false;
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            switch (this._state) {
                case 0: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    return;
                }
                case 1: 
                case 6: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: {
                    this._state = 7;
                    return;
                }
                case 4: {
                    this._state = 7;
                    dispatch = true;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doComplete() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            switch (this._state) {
                case 8: {
                    this._state = 9;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (this._listeners != null) {
            for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
                try {
                    ((ContinuationListener)LazyList.get((Object)this._listeners, (int)i)).onComplete((ContinuationEvent)this._event);
                    continue;
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            switch (this._state) {
                case 1: 
                case 6: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._state = 0;
            this._initial = true;
            this._resumed = false;
            this._expired = false;
            this._keepWrappers = false;
            this.cancelTimeout();
            this._timeoutMs = 60000L;
            this._listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            this._state = 9;
            this._initial = false;
            this.cancelTimeout();
            this._listeners = null;
        }
    }

    protected void scheduleDispatch() {
        EndPoint endp = this._connection.getEndPoint();
        if (!endp.isBlocking()) {
            ((AsyncEndPoint)endp).dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTimeout() {
        EndPoint endp = this._connection.getEndPoint();
        if (endp.isBlocking()) {
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                long expire_at = System.currentTimeMillis() + this._timeoutMs;
                long wait = this._timeoutMs;
                while (this._timeoutMs > 0L && wait > 0L) {
                    try {
                        this.wait(wait);
                    }
                    catch (InterruptedException e) {
                        Log.ignore((Throwable)e);
                    }
                    wait = expire_at - System.currentTimeMillis();
                }
                if (this._timeoutMs > 0L && wait <= 0L) {
                    this.expired();
                }
            }
        }
        this._connection.scheduleTimeout(this._event._timeout, this._timeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTimeout() {
        EndPoint endp = this._connection.getEndPoint();
        if (endp.isBlocking()) {
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                this._timeoutMs = 0L;
                this.notifyAll();
            }
        } else {
            AsyncEventState event = this._event;
            if (event != null) {
                this._connection.cancelTimeout(event._timeout);
            }
        }
    }

    public boolean isCompleting() {
        return this._state == 7;
    }

    boolean isUncompleted() {
        return this._state == 8;
    }

    public boolean isComplete() {
        return this._state == 9;
    }

    public boolean isAsyncStarted() {
        switch (this._state) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isAsync() {
        switch (this._state) {
            case 0: 
            case 1: {
                return false;
            }
        }
        return true;
    }

    public void dispatch(ServletContext context, String path) {
        this._event._dispatchContext = context;
        this._event._path = path;
        this.dispatch();
    }

    public void dispatch(String path) {
        this._event._path = path;
        this.dispatch();
    }

    public ServletRequest getRequest() {
        if (this._event != null) {
            return this._event.getRequest();
        }
        return this._connection.getRequest();
    }

    public ServletResponse getResponse() {
        if (this._event != null) {
            return this._event.getResponse();
        }
        return this._connection.getResponse();
    }

    public void start(Runnable run) {
        ((ContextHandler.Context)this._event.getServletContext()).getContextHandler().handle(run);
    }

    public boolean hasOriginalRequestAndResponse() {
        return this._event != null && this._event.getRequest() == this._connection._request && this._event.getResponse() == this._connection._response;
    }

    public ContextHandler getContextHandler() {
        if (this._event != null) {
            return ((ContextHandler.Context)this._event.getServletContext()).getContextHandler();
        }
        return null;
    }

    public boolean isResumed() {
        return this._resumed;
    }

    public boolean isExpired() {
        return this._expired;
    }

    public void resume() {
        this.dispatch();
    }

    public void setTimeout(long timeoutMs) {
        this.setAsyncTimeout(timeoutMs);
    }

    public void suspend() {
        this.suspend(this._connection.getRequest().getServletContext(), (ServletRequest)this._connection.getRequest(), (ServletResponse)this._connection.getResponse());
    }

    public class AsyncEventState
    implements ContinuationEvent {
        private final ServletContext _suspendedContext;
        private final ServletRequest _request;
        private final ServletResponse _response;
        ServletContext _dispatchContext;
        String _path;
        final Timeout.Task _timeout = new Timeout.Task(){

            public void expired() {
                AsyncRequest.this.expired();
            }
        };

        public AsyncEventState(ServletContext context, ServletRequest request, ServletResponse response) {
            this._suspendedContext = context;
            this._request = request;
            this._response = response;
        }

        public ServletContext getSuspendedContext() {
            return this._suspendedContext;
        }

        public ServletContext getDispatchContext() {
            return this._dispatchContext;
        }

        public ServletContext getServletContext() {
            return this._dispatchContext == null ? this._suspendedContext : this._dispatchContext;
        }

        public ServletRequest getRequest() {
            return this._request;
        }

        public ServletResponse getResponse() {
            return this._response;
        }

        public String getPath() {
            return this._path;
        }
    }
}

