/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class Dispatcher
implements RequestDispatcher {
    public static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    public static final String __JSP_FILE = "org.apache.catalina.jsp_file";
    private ContextHandler _contextHandler;
    private String _uri;
    private String _path;
    private String _dQuery;
    private String _named;

    public Dispatcher(ContextHandler contextHandler, String uri, String pathInContext, String query) {
        this._contextHandler = contextHandler;
        this._uri = uri;
        this._path = pathInContext;
        this._dQuery = query;
    }

    public Dispatcher(ContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._named = name;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.FORWARD);
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        request.removeAttribute(__JSP_FILE);
        DispatcherType old_type = base_request.getDispatcherType();
        Attributes old_attr = base_request.getAttributes();
        MultiMap old_params = base_request.getParameters();
        try {
            base_request.setDispatcherType(DispatcherType.INCLUDE);
            base_request.getConnection().include();
            if (this._named != null) {
                this._contextHandler.doHandle(this._named, base_request, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    MultiMap parameters = new MultiMap();
                    UrlEncoded.decodeTo((String)query, (MultiMap)parameters, (String)request.getCharacterEncoding());
                    if (old_params != null && old_params.size() > 0) {
                        for (Map.Entry entry : old_params.entrySet()) {
                            String name = (String)entry.getKey();
                            Object values = entry.getValue();
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add((Object)name, LazyList.get(values, (int)i));
                            }
                        }
                    }
                    base_request.setParameters(parameters);
                }
                IncludeAttributes attr = new IncludeAttributes(old_attr);
                attr._requestURI = this._uri;
                attr._contextPath = this._contextHandler.getContextPath();
                attr._servletPath = null;
                attr._pathInfo = this._path;
                attr._query = query;
                base_request.setAttributes(attr);
                this._contextHandler.doHandle(this._named == null ? this._path : this._named, base_request, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            Object var15_14 = null;
            base_request.setAttributes(old_attr);
            base_request.getConnection().included();
            base_request.setParameters(old_params);
            base_request.setDispatcherType(old_type);
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            base_request.setAttributes(old_attr);
            base_request.getConnection().included();
            base_request.setParameters(old_params);
            base_request.setDispatcherType(old_type);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest request, ServletResponse response, DispatcherType dispatch) throws ServletException, IOException {
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        Response base_response = base_request.getResponse();
        base_response.fwdReset();
        request.removeAttribute(__JSP_FILE);
        String old_uri = base_request.getRequestURI();
        String old_context_path = base_request.getContextPath();
        String old_servlet_path = base_request.getServletPath();
        String old_path_info = base_request.getPathInfo();
        String old_query = base_request.getQueryString();
        Attributes old_attr = base_request.getAttributes();
        MultiMap old_params = base_request.getParameters();
        DispatcherType old_type = base_request.getDispatcherType();
        try {
            base_request.setDispatcherType(dispatch);
            if (this._named != null) {
                this._contextHandler.doHandle(this._named, base_request, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    MultiMap parameters = new MultiMap();
                    UrlEncoded.decodeTo((String)query, (MultiMap)parameters, (String)request.getCharacterEncoding());
                    boolean rewrite_old_query = false;
                    if (old_params == null) {
                        base_request.getParameterNames();
                        old_params = base_request.getParameters();
                    }
                    if (old_params != null && old_params.size() > 0) {
                        for (Map.Entry entry : old_params.entrySet()) {
                            String name = (String)entry.getKey();
                            if (parameters.containsKey((Object)name)) {
                                rewrite_old_query = true;
                                continue;
                            }
                            Object values = entry.getValue();
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add((Object)name, LazyList.get(values, (int)i));
                            }
                        }
                    }
                    if (old_query != null && old_query.length() > 0) {
                        if (rewrite_old_query) {
                            StringBuilder overridden_query_string = new StringBuilder();
                            MultiMap overridden_old_query = new MultiMap();
                            UrlEncoded.decodeTo((String)old_query, (MultiMap)overridden_old_query, (String)request.getCharacterEncoding());
                            MultiMap overridden_new_query = new MultiMap();
                            UrlEncoded.decodeTo((String)query, (MultiMap)overridden_new_query, (String)request.getCharacterEncoding());
                            for (Map.Entry entry : overridden_old_query.entrySet()) {
                                String name = (String)entry.getKey();
                                if (overridden_new_query.containsKey((Object)name)) continue;
                                Object values = entry.getValue();
                                for (int i = 0; i < LazyList.size(values); ++i) {
                                    overridden_query_string.append("&" + name + "=" + LazyList.get(values, (int)i));
                                }
                            }
                            query = query + overridden_query_string;
                        } else {
                            query = query + "&" + old_query;
                        }
                    }
                    base_request.setParameters(parameters);
                    base_request.setQueryString(query);
                }
                ForwardAttributes attr = new ForwardAttributes(old_attr);
                if ((String)old_attr.getAttribute(FORWARD_REQUEST_URI) != null) {
                    attr._pathInfo = (String)old_attr.getAttribute(FORWARD_PATH_INFO);
                    attr._query = (String)old_attr.getAttribute(FORWARD_QUERY_STRING);
                    attr._requestURI = (String)old_attr.getAttribute(FORWARD_REQUEST_URI);
                    attr._contextPath = (String)old_attr.getAttribute(FORWARD_CONTEXT_PATH);
                    attr._servletPath = (String)old_attr.getAttribute(FORWARD_SERVLET_PATH);
                } else {
                    attr._pathInfo = old_path_info;
                    attr._query = old_query;
                    attr._requestURI = old_uri;
                    attr._contextPath = old_context_path;
                    attr._servletPath = old_servlet_path;
                }
                base_request.setRequestURI(this._uri);
                base_request.setContextPath(this._contextHandler.getContextPath());
                base_request.setAttributes(attr);
                base_request.setQueryString(query);
                this._contextHandler.doHandle(this._path, base_request, (HttpServletRequest)request, (HttpServletResponse)response);
                if (base_request.getConnection().getResponse().isWriting()) {
                    try {
                        response.getWriter().close();
                    }
                    catch (IllegalStateException e) {
                        response.getOutputStream().close();
                    }
                } else {
                    try {
                        response.getOutputStream().close();
                    }
                    catch (IllegalStateException e) {
                        response.getWriter().close();
                    }
                }
            }
            Object var26_29 = null;
            base_request.setRequestURI(old_uri);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            base_request.setAttributes(old_attr);
            base_request.setParameters(old_params);
            base_request.setQueryString(old_query);
            base_request.setDispatcherType(old_type);
        }
        catch (Throwable throwable) {
            Object var26_30 = null;
            base_request.setRequestURI(old_uri);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            base_request.setAttributes(old_attr);
            base_request.setParameters(old_params);
            base_request.setQueryString(old_query);
            base_request.setDispatcherType(old_type);
            throw throwable;
        }
    }

    private class IncludeAttributes
    implements Attributes {
        Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        IncludeAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.INCLUDE_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (key.equals(Dispatcher.INCLUDE_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (key.equals(Dispatcher.INCLUDE_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (key.equals(Dispatcher.INCLUDE_QUERY_STRING)) {
                    return this._query;
                }
                if (key.equals(Dispatcher.INCLUDE_REQUEST_URI)) {
                    return this._requestURI;
                }
            } else if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add(Dispatcher.INCLUDE_PATH_INFO);
                } else {
                    set.remove(Dispatcher.INCLUDE_PATH_INFO);
                }
                set.add(Dispatcher.INCLUDE_REQUEST_URI);
                set.add(Dispatcher.INCLUDE_SERVLET_PATH);
                set.add(Dispatcher.INCLUDE_CONTEXT_PATH);
                if (this._query != null) {
                    set.add(Dispatcher.INCLUDE_QUERY_STRING);
                } else {
                    set.remove(Dispatcher.INCLUDE_QUERY_STRING);
                }
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.INCLUDE_PATH_INFO)) {
                    this._pathInfo = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_REQUEST_URI)) {
                    this._requestURI = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_SERVLET_PATH)) {
                    this._servletPath = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_CONTEXT_PATH)) {
                    this._contextPath = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_QUERY_STRING)) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.FORWARD_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (key.equals(Dispatcher.FORWARD_REQUEST_URI)) {
                    return this._requestURI;
                }
                if (key.equals(Dispatcher.FORWARD_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (key.equals(Dispatcher.FORWARD_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (key.equals(Dispatcher.FORWARD_QUERY_STRING)) {
                    return this._query;
                }
            }
            if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX) || name.startsWith(Dispatcher.__FORWARD_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add(Dispatcher.FORWARD_PATH_INFO);
                } else {
                    set.remove(Dispatcher.FORWARD_PATH_INFO);
                }
                set.add(Dispatcher.FORWARD_REQUEST_URI);
                set.add(Dispatcher.FORWARD_SERVLET_PATH);
                set.add(Dispatcher.FORWARD_CONTEXT_PATH);
                if (this._query != null) {
                    set.add(Dispatcher.FORWARD_QUERY_STRING);
                } else {
                    set.remove(Dispatcher.FORWARD_QUERY_STRING);
                }
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.FORWARD_PATH_INFO)) {
                    this._pathInfo = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_REQUEST_URI)) {
                    this._requestURI = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_SERVLET_PATH)) {
                    this._servletPath = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_CONTEXT_PATH)) {
                    this._contextPath = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_QUERY_STRING)) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }
}

