/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;

public class HandlerWrapper
extends AbstractHandlerContainer {
    private Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    public Handler[] getHandlers() {
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Handler old_handler = this._handler;
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)old_handler, (Object)handler, "handler");
        }
        if (handler != null) {
            handler.setServer(this.getServer());
        }
        this._handler = handler;
    }

    protected void doStart() throws Exception {
        if (this._handler != null) {
            this._handler.start();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._handler != null) {
            this._handler.stop();
        }
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, request, response);
        }
    }

    public void setServer(Server server) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Server old_server = this.getServer();
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, (Object)this._handler, "handler");
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        return this.expandHandler(this._handler, list, byClass);
    }
}

