/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;

public class HotSwapHandler
extends AbstractHandlerContainer {
    private volatile Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    public Handler[] getHandlers() {
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("RUNNING");
            }
            Handler old_handler = this._handler;
            if (this.getServer() != null) {
                this.getServer().getContainer().update((Object)this, (Object)old_handler, (Object)handler, "handler");
            }
            if (handler != null) {
                handler.setServer(this.getServer());
                if (this.isStarted()) {
                    handler.start();
                }
            }
            this._handler = handler;
            if (this.isStarted()) {
                old_handler.stop();
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doStart() throws Exception {
        if (this._handler != null) {
            this._handler.start();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._handler != null) {
            this._handler.stop();
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    public void setServer(Server server) {
        if (this.isRunning()) {
            throw new IllegalStateException("RUNNING");
        }
        Server old_server = this.getServer();
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, (Object)this._handler, "handler");
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        return this.expandHandler(this._handler, list, byClass);
    }
}

