/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AsyncRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.CompleteHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.LazyList;

public class StatisticsHandler
extends HandlerWrapper
implements CompleteHandler {
    transient long _statsStartedAt;
    transient int _requests;
    transient long _requestsDurationMin;
    transient long _requestsDurationMax;
    transient long _requestsDurationTotal;
    transient long _requestsActiveDurationMin;
    transient long _requestsActiveDurationMax;
    transient long _requestsActiveDurationTotal;
    transient int _requestsActive;
    transient int _requestsActiveMin;
    transient int _requestsActiveMax;
    transient int _requestsResumed;
    transient int _requestsTimedout;
    transient int _responses1xx;
    transient int _responses2xx;
    transient int _responses3xx;
    transient int _responses4xx;
    transient int _responses5xx;
    transient long _responsesBytesTotal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statsReset() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            if (this.isStarted()) {
                this._statsStartedAt = System.currentTimeMillis();
            }
            this._requests = 0;
            this._responses1xx = 0;
            this._responses2xx = 0;
            this._responses3xx = 0;
            this._responses4xx = 0;
            this._responses5xx = 0;
            this._requestsActiveMin = this._requestsActive;
            this._requestsActiveMax = this._requestsActive;
            this._requestsDurationMin = 0L;
            this._requestsDurationMax = 0L;
            this._requestsDurationTotal = 0L;
            this._requestsActiveDurationMin = 0L;
            this._requestsActiveDurationMax = 0L;
            this._requestsActiveDurationTotal = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StatisticsHandler statisticsHandler;
        long timestamp0;
        Response base_response = baseRequest.getResponse();
        long timestamp1 = timestamp0 = baseRequest.getTimeStamp();
        try {
            StatisticsHandler statisticsHandler2 = this;
            synchronized (statisticsHandler2) {
                AsyncRequest asyncContextState = baseRequest.getAsyncRequest();
                if (asyncContextState == null) {
                    ++this._requests;
                } else if (asyncContextState.isInitial()) {
                    ++this._requests;
                } else {
                    timestamp1 = System.currentTimeMillis();
                }
                ++this._requestsActive;
                if (this._requestsActive > this._requestsActiveMax) {
                    this._requestsActiveMax = this._requestsActive;
                }
            }
            super.handle(target, baseRequest, request, response);
            Object var14_11 = null;
            statisticsHandler = this;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            StatisticsHandler statisticsHandler3 = this;
            synchronized (statisticsHandler3) {
                --this._requestsActive;
                if (this._requestsActive < 0) {
                    this._requestsActive = 0;
                }
                if (this._requestsActive < this._requestsActiveMin) {
                    this._requestsActiveMin = this._requestsActive;
                }
                long duration = System.currentTimeMillis() - timestamp1;
                this._requestsActiveDurationTotal += duration;
                if (this._requestsActiveDurationMin == 0L || duration < this._requestsActiveDurationMin) {
                    this._requestsActiveDurationMin = duration;
                }
                if (duration > this._requestsActiveDurationMax) {
                    this._requestsActiveDurationMax = duration;
                }
                if (baseRequest.isAsyncStarted()) {
                    Object list = baseRequest.getAttribute("org.eclipse.jetty.server.handler.CompleteHandlers");
                    baseRequest.setAttribute("org.eclipse.jetty.server.handler.CompleteHandlers", LazyList.add((Object)list, (Object)this));
                } else {
                    duration = System.currentTimeMillis() - timestamp0;
                    this.addRequestsDurationTotal(duration);
                    switch (base_response.getStatus() / 100) {
                        case 1: {
                            ++this._responses1xx;
                            break;
                        }
                        case 2: {
                            ++this._responses2xx;
                            break;
                        }
                        case 3: {
                            ++this._responses3xx;
                            break;
                        }
                        case 4: {
                            ++this._responses4xx;
                            break;
                        }
                        case 5: {
                            ++this._responses5xx;
                        }
                    }
                    this._responsesBytesTotal += base_response.getContentCount();
                }
            }
            throw throwable;
        }
        synchronized (statisticsHandler) {
            --this._requestsActive;
            if (this._requestsActive < 0) {
                this._requestsActive = 0;
            }
            if (this._requestsActive < this._requestsActiveMin) {
                this._requestsActiveMin = this._requestsActive;
            }
            long duration = System.currentTimeMillis() - timestamp1;
            this._requestsActiveDurationTotal += duration;
            if (this._requestsActiveDurationMin == 0L || duration < this._requestsActiveDurationMin) {
                this._requestsActiveDurationMin = duration;
            }
            if (duration > this._requestsActiveDurationMax) {
                this._requestsActiveDurationMax = duration;
            }
            if (baseRequest.isAsyncStarted()) {
                Object list = baseRequest.getAttribute("org.eclipse.jetty.server.handler.CompleteHandlers");
                baseRequest.setAttribute("org.eclipse.jetty.server.handler.CompleteHandlers", LazyList.add((Object)list, (Object)this));
            } else {
                duration = System.currentTimeMillis() - timestamp0;
                this.addRequestsDurationTotal(duration);
                switch (base_response.getStatus() / 100) {
                    case 1: {
                        ++this._responses1xx;
                        break;
                    }
                    case 2: {
                        ++this._responses2xx;
                        break;
                    }
                    case 3: {
                        ++this._responses3xx;
                        break;
                    }
                    case 4: {
                        ++this._responses4xx;
                        break;
                    }
                    case 5: {
                        ++this._responses5xx;
                    }
                }
                this._responsesBytesTotal += base_response.getContentCount();
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._statsStartedAt = System.currentTimeMillis();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public int getRequests() {
        return this._requests;
    }

    public int getRequestsActive() {
        return this._requestsActive;
    }

    public int getRequestsResumed() {
        return this._requestsResumed;
    }

    public int getRequestsTimedout() {
        return this._requestsTimedout;
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax;
    }

    public int getResponses1xx() {
        return this._responses1xx;
    }

    public int getResponses2xx() {
        return this._responses2xx;
    }

    public int getResponses3xx() {
        return this._responses3xx;
    }

    public int getResponses4xx() {
        return this._responses4xx;
    }

    public int getResponses5xx() {
        return this._responses5xx;
    }

    public long getStatsOnMs() {
        return System.currentTimeMillis() - this._statsStartedAt;
    }

    public int getRequestsActiveMin() {
        return this._requestsActiveMin;
    }

    public long getRequestsDurationMin() {
        return this._requestsDurationMin;
    }

    public long getRequestsDurationTotal() {
        return this._requestsDurationTotal;
    }

    public long getRequestsDurationAve() {
        return this._requests == 0 ? 0L : this._requestsDurationTotal / (long)this._requests;
    }

    public long getRequestsDurationMax() {
        return this._requestsDurationMax;
    }

    public long getRequestsActiveDurationMin() {
        return this._requestsActiveDurationMin;
    }

    public long getRequestsActiveDurationTotal() {
        return this._requestsActiveDurationTotal;
    }

    public long getRequestsActiveDurationAve() {
        return this._requests == 0 ? 0L : this._requestsActiveDurationTotal / (long)this._requests;
    }

    public long getRequestsActiveDurationMax() {
        return this._requestsActiveDurationMax;
    }

    public long getResponsesBytesTotal() {
        return this._responsesBytesTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequestsDurationTotal(long duration) {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            this._requestsDurationTotal += duration;
            if (this._requestsDurationMin == 0L || duration < this._requestsDurationMin) {
                this._requestsDurationMin = duration;
            }
            if (duration > this._requestsDurationMax) {
                this._requestsDurationMax = duration;
            }
        }
    }

    public void complete(Request request) {
        long duration = System.currentTimeMillis() - request.getTimeStamp();
        this.addRequestsDurationTotal(duration);
    }
}

