/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class StatisticsHandler
extends HandlerWrapper {
    private final AtomicLong _statsStartedAt = new AtomicLong();
    private final AtomicInteger _requests = new AtomicInteger();
    private final AtomicInteger _requestsActive = new AtomicInteger();
    private final AtomicInteger _requestsActiveMax = new AtomicInteger();
    private final AtomicLong _requestTimeMax = new AtomicLong();
    private final AtomicLong _requestTimeTotal = new AtomicLong();
    private final AtomicInteger _dispatched = new AtomicInteger();
    private final AtomicInteger _dispatchedActive = new AtomicInteger();
    private final AtomicInteger _dispatchedActiveMax = new AtomicInteger();
    private final AtomicLong _dispatchedTimeMax = new AtomicLong();
    private final AtomicLong _dispatchedTimeTotal = new AtomicLong();
    private final AtomicInteger _suspends = new AtomicInteger();
    private final AtomicInteger _suspendsActive = new AtomicInteger();
    private final AtomicInteger _suspendsActiveMax = new AtomicInteger();
    private final AtomicInteger _resumes = new AtomicInteger();
    private final AtomicInteger _expires = new AtomicInteger();
    private final AtomicInteger _responses1xx = new AtomicInteger();
    private final AtomicInteger _responses2xx = new AtomicInteger();
    private final AtomicInteger _responses3xx = new AtomicInteger();
    private final AtomicInteger _responses4xx = new AtomicInteger();
    private final AtomicInteger _responses5xx = new AtomicInteger();
    private final AtomicLong _responsesTotalBytes = new AtomicLong();
    private final ContinuationListener _onCompletion = new ContinuationListener(){

        public void onComplete(Continuation continuation) {
            Request request = ((AsyncContinuation)continuation).getBaseRequest();
            long elapsed = System.currentTimeMillis() - request.getTimeStamp();
            StatisticsHandler.this._requestsActive.decrementAndGet();
            StatisticsHandler.this._requests.incrementAndGet();
            StatisticsHandler.this.updateMax(StatisticsHandler.this._requestTimeMax, elapsed);
            StatisticsHandler.this._requestTimeTotal.addAndGet(elapsed);
            StatisticsHandler.this.updateResponse(request);
            if (!continuation.isResumed()) {
                StatisticsHandler.this._suspendsActive.decrementAndGet();
            }
        }

        public void onTimeout(Continuation continuation) {
            StatisticsHandler.this._expires.incrementAndGet();
        }
    };

    public void statsReset() {
        this._statsStartedAt.set(System.currentTimeMillis());
        this._requests.set(0);
        this._requestsActive.set(0);
        this._requestsActiveMax.set(0);
        this._requestTimeMax.set(0L);
        this._requestTimeTotal.set(0L);
        this._dispatched.set(0);
        this._dispatchedActive.set(0);
        this._dispatchedActiveMax.set(0);
        this._dispatchedTimeMax.set(0L);
        this._dispatchedTimeTotal.set(0L);
        this._suspends.set(0);
        this._suspendsActive.set(0);
        this._suspendsActiveMax.set(0);
        this._resumes.set(0);
        this._expires.set(0);
        this._responses1xx.set(0);
        this._responses2xx.set(0);
        this._responses3xx.set(0);
        this._responses4xx.set(0);
        this._responses5xx.set(0);
        this._responsesTotalBytes.set(0L);
    }

    private void updateMax(AtomicInteger valueHolder, int value) {
        int oldValue = valueHolder.get();
        while (value > oldValue && !valueHolder.compareAndSet(oldValue, value)) {
            oldValue = valueHolder.get();
        }
    }

    private void updateMax(AtomicLong valueHolder, long value) {
        long oldValue = valueHolder.get();
        while (value > oldValue && !valueHolder.compareAndSet(oldValue, value)) {
            oldValue = valueHolder.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        long start;
        this.updateMax(this._dispatchedActiveMax, this._dispatchedActive.incrementAndGet());
        AsyncContinuation continuation = request.getAsyncContinuation();
        if (continuation.isInitial()) {
            this.updateMax(this._requestsActiveMax, this._requestsActive.incrementAndGet());
            start = request.getTimeStamp();
        } else {
            start = System.currentTimeMillis();
            this._suspendsActive.decrementAndGet();
            if (continuation.isResumed()) {
                this._resumes.incrementAndGet();
            }
        }
        try {
            super.handle(path, request, httpRequest, httpResponse);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            long now = System.currentTimeMillis();
            long dispatched = now - start;
            this._dispatchedActive.decrementAndGet();
            this._dispatched.incrementAndGet();
            this._dispatchedTimeTotal.addAndGet(dispatched);
            this.updateMax(this._dispatchedTimeMax, dispatched);
            if (continuation.isSuspended()) {
                if (continuation.isInitial()) {
                    continuation.addContinuationListener(this._onCompletion);
                }
                this._suspends.incrementAndGet();
                this.updateMax(this._suspendsActiveMax, this._suspendsActive.incrementAndGet());
            } else if (continuation.isInitial()) {
                this._requestsActive.decrementAndGet();
                this._requests.incrementAndGet();
                this.updateMax(this._requestTimeMax, dispatched);
                this._requestTimeTotal.addAndGet(dispatched);
                this.updateResponse(request);
            }
            throw throwable;
        }
        long now = System.currentTimeMillis();
        long dispatched = now - start;
        this._dispatchedActive.decrementAndGet();
        this._dispatched.incrementAndGet();
        this._dispatchedTimeTotal.addAndGet(dispatched);
        this.updateMax(this._dispatchedTimeMax, dispatched);
        if (continuation.isSuspended()) {
            if (continuation.isInitial()) {
                continuation.addContinuationListener(this._onCompletion);
            }
            this._suspends.incrementAndGet();
            this.updateMax(this._suspendsActiveMax, this._suspendsActive.incrementAndGet());
        } else if (continuation.isInitial()) {
            this._requestsActive.decrementAndGet();
            this._requests.incrementAndGet();
            this.updateMax(this._requestTimeMax, dispatched);
            this._requestTimeTotal.addAndGet(dispatched);
            this.updateResponse(request);
        }
    }

    private void updateResponse(Request request) {
        Response response = request.getResponse();
        switch (response.getStatus() / 100) {
            case 1: {
                this._responses1xx.incrementAndGet();
                break;
            }
            case 2: {
                this._responses2xx.incrementAndGet();
                break;
            }
            case 3: {
                this._responses3xx.incrementAndGet();
                break;
            }
            case 4: {
                this._responses4xx.incrementAndGet();
                break;
            }
            case 5: {
                this._responses5xx.incrementAndGet();
                break;
            }
        }
        this._responsesTotalBytes.addAndGet(response.getContentCount());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.statsReset();
    }

    public int getRequests() {
        return this._requests.get();
    }

    public int getRequestsActive() {
        return this._requestsActive.get();
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax.get();
    }

    public long getRequestTimeMax() {
        return this._requestTimeMax.get();
    }

    public long getRequestTimeTotal() {
        return this._requestTimeTotal.get();
    }

    public long getRequestTimeAverage() {
        int requests = this.getRequests();
        return requests == 0 ? 0L : this.getRequestTimeTotal() / (long)requests;
    }

    public int getDispatched() {
        return this._dispatched.get();
    }

    public int getDispatchedActive() {
        return this._dispatchedActive.get();
    }

    public int getDispatchedActiveMax() {
        return this._dispatchedActiveMax.get();
    }

    public long getDispatchedTimeMax() {
        return this._dispatchedTimeMax.get();
    }

    public long getDispatchedTimeTotal() {
        return this._dispatchedTimeTotal.get();
    }

    public long getDispatchedTimeAverage() {
        int requests = this.getDispatched();
        return requests == 0 ? 0L : this.getDispatchedTimeTotal() / (long)requests;
    }

    public int getSuspends() {
        return this._suspends.get();
    }

    public int getSuspendsActive() {
        return this._suspendsActive.get();
    }

    public int getSuspendsActiveMax() {
        return this._suspendsActiveMax.get();
    }

    public int getResumes() {
        return this._resumes.get();
    }

    public int getExpires() {
        return this._expires.get();
    }

    public int getResponses1xx() {
        return this._responses1xx.get();
    }

    public int getResponses2xx() {
        return this._responses2xx.get();
    }

    public int getResponses3xx() {
        return this._responses3xx.get();
    }

    public int getResponses4xx() {
        return this._responses4xx.get();
    }

    public int getResponses5xx() {
        return this._responses5xx.get();
    }

    public long getStatsOnMs() {
        return System.currentTimeMillis() - this._statsStartedAt.get();
    }

    public long getResponsesBytesTotal() {
        return this._responsesTotalBytes.get();
    }

    public String toStatsHTML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>Statistics:</h1>\n");
        sb.append("Statistics gathering started ").append(this.getStatsOnMs()).append("ms ago").append("<br />\n");
        sb.append("<h2>Requests:</h2>\n");
        sb.append("Total requests: ").append(this.getRequests()).append("<br />\n");
        sb.append("Active requests: ").append(this.getRequestsActive()).append("<br />\n");
        sb.append("Max active requests: ").append(this.getRequestsActiveMax()).append("<br />\n");
        sb.append("Total requests time: ").append(this.getRequestTimeTotal()).append("<br />\n");
        sb.append("Average request time: ").append(this.getRequestTimeAverage()).append("<br />\n");
        sb.append("Max request time: ").append(this.getRequestTimeMax()).append("<br />\n");
        sb.append("<h2>Dispatches:</h2>\n");
        sb.append("Total dispatched: ").append(this.getDispatched()).append("<br />\n");
        sb.append("Active dispatched: ").append(this.getDispatchedActive()).append("<br />\n");
        sb.append("Max active dispatched: ").append(this.getDispatchedActiveMax()).append("<br />\n");
        sb.append("Total dispatched time: ").append(this.getDispatchedTimeTotal()).append("<br />\n");
        sb.append("Average dispatched time: ").append(this.getDispatchedTimeAverage()).append("<br />\n");
        sb.append("Max dispatched time: ").append(this.getDispatchedTimeMax()).append("<br />\n");
        sb.append("Total requests suspended: ").append(this.getSuspends()).append("<br />\n");
        sb.append("Total requests expired: ").append(this.getExpires()).append("<br />\n");
        sb.append("Total requests resumed: ").append(this.getResumes()).append("<br />\n");
        sb.append("<h2>Responses:</h2>\n");
        sb.append("1xx responses: ").append(this.getResponses1xx()).append("<br />\n");
        sb.append("2xx responses: ").append(this.getResponses2xx()).append("<br />\n");
        sb.append("3xx responses: ").append(this.getResponses3xx()).append("<br />\n");
        sb.append("4xx responses: ").append(this.getResponses4xx()).append("<br />\n");
        sb.append("5xx responses: ").append(this.getResponses5xx()).append("<br />\n");
        sb.append("Bytes sent total: ").append(this.getResponsesBytesTotal()).append("<br />\n");
        return sb.toString();
    }
}

