/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.ssl.SslCertificates;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SslSocketConnector
extends SocketConnector
implements SslConnector {
    private static final Logger LOG = Log.getLogger(SslSocketConnector.class);
    private final SslContextFactory _sslContextFactory;
    private int _handshakeTimeout = 0;

    public SslSocketConnector() {
        this(new SslContextFactory(SslContextFactory.DEFAULT_KEYSTORE_PATH));
    }

    public SslSocketConnector(SslContextFactory sslContextFactory) {
        this._sslContextFactory = sslContextFactory;
    }

    public boolean isAllowRenegotiate() {
        return this._sslContextFactory.isAllowRenegotiate();
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._sslContextFactory.setAllowRenegotiate(allowRenegotiate);
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        SslConnectorEndPoint connection = new SslConnectorEndPoint(socket);
        ((SocketConnector.ConnectorEndPoint)connection).dispatch();
    }

    protected void configure(Socket socket) throws IOException {
        super.configure(socket);
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        SocketEndPoint socket_end_point = (SocketEndPoint)endpoint;
        SSLSocket sslSocket = (SSLSocket)socket_end_point.getTransport();
        SSLSession sslSession = sslSocket.getSession();
        SslCertificates.customize(sslSession, endpoint, request);
    }

    @Deprecated
    public String[] getExcludeCipherSuites() {
        return this._sslContextFactory.getExcludeCipherSuites();
    }

    @Deprecated
    public String[] getIncludeCipherSuites() {
        return this._sslContextFactory.getIncludeCipherSuites();
    }

    @Deprecated
    public String getKeystore() {
        return this._sslContextFactory.getKeyStore();
    }

    @Deprecated
    public String getKeystoreType() {
        return this._sslContextFactory.getKeyStoreType();
    }

    @Deprecated
    public boolean getNeedClientAuth() {
        return this._sslContextFactory.getNeedClientAuth();
    }

    @Deprecated
    public String getProtocol() {
        return this._sslContextFactory.getProtocol();
    }

    @Deprecated
    public String getProvider() {
        return this._sslContextFactory.getProvider();
    }

    @Deprecated
    public String getSecureRandomAlgorithm() {
        return this._sslContextFactory.getSecureRandomAlgorithm();
    }

    @Deprecated
    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslContextFactory.getSslKeyManagerFactoryAlgorithm();
    }

    @Deprecated
    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslContextFactory.getTrustManagerFactoryAlgorithm();
    }

    @Deprecated
    public String getTruststore() {
        return this._sslContextFactory.getTrustStore();
    }

    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    @Deprecated
    public String getTruststoreType() {
        return this._sslContextFactory.getTrustStoreType();
    }

    @Deprecated
    public boolean getWantClientAuth() {
        return this._sslContextFactory.getWantClientAuth();
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    public void open() throws IOException {
        this._sslContextFactory.checkKeyStore();
        try {
            this._sslContextFactory.start();
        }
        catch (Exception e) {
            throw new RuntimeIOException((Throwable)e);
        }
        super.open();
    }

    protected void doStart() throws Exception {
        this._sslContextFactory.checkKeyStore();
        this._sslContextFactory.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._sslContextFactory.stop();
        super.doStop();
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        return this._sslContextFactory.newSslServerSocket(host, port, backlog);
    }

    @Deprecated
    public void setExcludeCipherSuites(String[] cipherSuites) {
        this._sslContextFactory.setExcludeCipherSuites(cipherSuites);
    }

    @Deprecated
    public void setIncludeCipherSuites(String[] cipherSuites) {
        this._sslContextFactory.setIncludeCipherSuites(cipherSuites);
    }

    @Deprecated
    public void setKeyPassword(String password) {
        this._sslContextFactory.setKeyManagerPassword(password);
    }

    @Deprecated
    public void setKeystore(String keystore) {
        this._sslContextFactory.setKeyStore(keystore);
    }

    @Deprecated
    public void setKeystoreType(String keystoreType) {
        this._sslContextFactory.setKeyStoreType(keystoreType);
    }

    @Deprecated
    public void setNeedClientAuth(boolean needClientAuth) {
        this._sslContextFactory.setNeedClientAuth(needClientAuth);
    }

    @Deprecated
    public void setPassword(String password) {
        this._sslContextFactory.setKeyStorePassword(password);
    }

    @Deprecated
    public void setTrustPassword(String password) {
        this._sslContextFactory.setTrustStorePassword(password);
    }

    @Deprecated
    public void setProtocol(String protocol) {
        this._sslContextFactory.setProtocol(protocol);
    }

    @Deprecated
    public void setProvider(String provider) {
        this._sslContextFactory.setProvider(provider);
    }

    @Deprecated
    public void setSecureRandomAlgorithm(String algorithm) {
        this._sslContextFactory.setSecureRandomAlgorithm(algorithm);
    }

    @Deprecated
    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslContextFactory.setSslKeyManagerFactoryAlgorithm(algorithm);
    }

    @Deprecated
    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslContextFactory.setTrustManagerFactoryAlgorithm(algorithm);
    }

    @Deprecated
    public void setTruststore(String truststore) {
        this._sslContextFactory.setTrustStore(truststore);
    }

    @Deprecated
    public void setTruststoreType(String truststoreType) {
        this._sslContextFactory.setTrustStoreType(truststoreType);
    }

    @Deprecated
    public void setSslContext(SSLContext sslContext) {
        this._sslContextFactory.setSslContext(sslContext);
    }

    @Deprecated
    public SSLContext getSslContext() {
        return this._sslContextFactory.getSslContext();
    }

    @Deprecated
    public void setWantClientAuth(boolean wantClientAuth) {
        this._sslContextFactory.setWantClientAuth(wantClientAuth);
    }

    public void setHandshakeTimeout(int msec) {
        this._handshakeTimeout = msec;
    }

    public int getHandshakeTimeout() {
        return this._handshakeTimeout;
    }

    @Deprecated
    public String getAlgorithm() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setAlgorithm(String algorithm) {
        throw new UnsupportedOperationException();
    }

    public class SslConnectorEndPoint
    extends SocketConnector.ConnectorEndPoint {
        public SslConnectorEndPoint(Socket socket) throws IOException {
            super(socket);
        }

        public void shutdownOutput() throws IOException {
            this.close();
        }

        public void shutdownInput() throws IOException {
            this.close();
        }

        public void run() {
            try {
                int handshakeTimeout = SslSocketConnector.this.getHandshakeTimeout();
                int oldTimeout = this._socket.getSoTimeout();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(handshakeTimeout);
                }
                final SSLSocket ssl = (SSLSocket)this._socket;
                ssl.addHandshakeCompletedListener(new HandshakeCompletedListener(){
                    boolean handshook = false;

                    public void handshakeCompleted(HandshakeCompletedEvent event) {
                        if (this.handshook) {
                            if (!SslSocketConnector.this._sslContextFactory.isAllowRenegotiate()) {
                                LOG.warn("SSL renegotiate denied: " + ssl, new Object[0]);
                                try {
                                    ssl.close();
                                }
                                catch (IOException e) {
                                    LOG.warn((Throwable)e);
                                }
                            }
                        } else {
                            this.handshook = true;
                        }
                    }
                });
                ssl.startHandshake();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(oldTimeout);
                }
                super.run();
            }
            catch (SSLException e) {
                LOG.debug((Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
        }
    }
}

