/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession
implements AbstractSessionManager.SessionIf {
    static final Logger LOG = SessionHandler.LOG;
    private final AbstractSessionManager _manager;
    private final String _clusterId;
    private final String _nodeId;
    private final Map<String, Object> _attributes = new HashMap<String, Object>();
    private boolean _idChanged;
    private final long _created;
    private long _cookieSet;
    private long _accessed;
    private long _lastAccessed;
    private boolean _invalid;
    private boolean _doInvalidate;
    private long _maxIdleMs;
    private boolean _newSession;
    private int _requests;
    protected final Map<String, Object> _jdbcAttributes = this._attributes;

    protected AbstractSession(AbstractSessionManager abstractSessionManager, HttpServletRequest request) {
        this._manager = abstractSessionManager;
        this._newSession = true;
        this._created = System.currentTimeMillis();
        this._clusterId = this._manager._sessionIdManager.newSessionId(request, this._created);
        this._nodeId = this._manager._sessionIdManager.getNodeId(this._clusterId, request);
        this._accessed = this._created;
        this._lastAccessed = this._created;
        this._requests = 1;
        long l = this._maxIdleMs = this._manager._dftMaxIdleSecs > 0 ? (long)(this._manager._dftMaxIdleSecs * 1000) : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new session & id " + this._nodeId + " " + this._clusterId, new Object[0]);
        }
    }

    protected AbstractSession(AbstractSessionManager abstractSessionManager, long created, long accessed, String clusterId) {
        this._manager = abstractSessionManager;
        this._created = created;
        this._clusterId = clusterId;
        this._nodeId = this._manager._sessionIdManager.getNodeId(this._clusterId, null);
        this._accessed = accessed;
        this._lastAccessed = accessed;
        this._requests = 1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new session " + this._nodeId + " " + this._clusterId, new Object[0]);
        }
    }

    protected void checkValid() throws IllegalStateException {
        if (this._invalid) {
            throw new IllegalStateException();
        }
    }

    @Override
    public AbstractSession getSession() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAccessed() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return this._accessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            return this._attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttributes() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            return this._attributes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            List<Object> names = this._attributes == null ? Collections.EMPTY_LIST : new ArrayList<String>(this._attributes.keySet());
            return Collections.enumeration(names);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNames() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return new HashSet<String>(this._attributes.keySet());
        }
    }

    public long getCookieSetTime() {
        return this._cookieSet;
    }

    public long getCreationTime() throws IllegalStateException {
        return this._created;
    }

    public String getId() throws IllegalStateException {
        return this._manager._nodeIdInSessionId ? this._nodeId : this._clusterId;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public String getClusterId() {
        return this._clusterId;
    }

    public long getLastAccessedTime() throws IllegalStateException {
        this.checkValid();
        return this._lastAccessed;
    }

    public int getMaxInactiveInterval() {
        this.checkValid();
        return (int)(this._maxIdleMs / 1000L);
    }

    public ServletContext getServletContext() {
        return this._manager._context;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() throws IllegalStateException {
        this.checkValid();
        return AbstractSessionManager.__nullSessionContext;
    }

    @Deprecated
    public Object getValue(String name) throws IllegalStateException {
        return this.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String[] getValueNames() throws IllegalStateException {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            if (this._attributes == null) {
                return new String[0];
            }
            String[] a = new String[this._attributes.size()];
            return this._attributes.keySet().toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean access(long time) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (this._invalid) {
                return false;
            }
            this._newSession = false;
            this._lastAccessed = this._accessed;
            this._accessed = time;
            if (this._maxIdleMs > 0L && this._lastAccessed > 0L && this._lastAccessed + this._maxIdleMs < time) {
                this.invalidate();
                return false;
            }
            ++this._requests;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            --this._requests;
            if (this._doInvalidate && this._requests <= 0) {
                this.doInvalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeout() throws IllegalStateException {
        this._manager.removeSession(this, true);
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (!this._invalid) {
                if (this._requests <= 0) {
                    this.doInvalidate();
                } else {
                    this._doInvalidate = true;
                }
            }
        }
    }

    public void invalidate() throws IllegalStateException {
        this._manager.removeSession(this, true);
        this.doInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvalidate() throws IllegalStateException {
        AbstractSession abstractSession;
        try {
            LOG.debug("invalidate {}", new Object[]{this._clusterId});
            if (this.isValid()) {
                this.clearAttributes();
            }
            Object var2_1 = null;
            abstractSession = this;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            AbstractSession abstractSession2 = this;
            synchronized (abstractSession2) {
                this._invalid = true;
            }
            throw throwable;
        }
        synchronized (abstractSession) {
            this._invalid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAttributes() {
        while (this._attributes != null && this._attributes.size() > 0) {
            ArrayList<String> keys;
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                keys = new ArrayList<String>(this._attributes.keySet());
            }
            for (String key : keys) {
                Object value;
                AbstractSession abstractSession2 = this;
                synchronized (abstractSession2) {
                    value = this.doPutOrRemove(key, null);
                }
                this.unbindValue(key, value);
                this._manager.doSessionAttributeListeners(this, key, value, null);
            }
        }
        if (this._attributes != null) {
            this._attributes.clear();
        }
    }

    public boolean isIdChanged() {
        return this._idChanged;
    }

    public boolean isNew() throws IllegalStateException {
        this.checkValid();
        return this._newSession;
    }

    @Deprecated
    public void putValue(String name, Object value) throws IllegalStateException {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    @Deprecated
    public void removeValue(String name) throws IllegalStateException {
        this.removeAttribute(name);
    }

    protected Object doPutOrRemove(String name, Object value) {
        return value == null ? this._attributes.remove(name) : this._attributes.put(name, value);
    }

    protected Object doGet(String name) {
        return this._attributes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object old = null;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            old = this.doPutOrRemove(name, value);
        }
        if (value == null || !value.equals(old)) {
            if (old != null) {
                this.unbindValue(name, old);
            }
            if (value != null) {
                this.bindValue(name, value);
            }
            this._manager.doSessionAttributeListeners(this, name, old, value);
        }
    }

    public void setIdChanged(boolean changed) {
        this._idChanged = changed;
    }

    public void setMaxInactiveInterval(int secs) {
        this._maxIdleMs = (long)secs * 1000L;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
    }

    public void bindValue(String name, Object value) {
        if (value != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
    }

    public boolean isValid() {
        return !this._invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cookieSet() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this._cookieSet = this._accessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequests() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return this._requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequests(int requests) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this._requests = requests;
        }
    }

    public void unbindValue(String name, Object value) {
        if (value != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void willPassivate() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (Object value : this._attributes.values()) {
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                listener.sessionWillPassivate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didActivate() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (Object value : this._attributes.values()) {
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                listener.sessionDidActivate(event);
            }
        }
    }
}

