/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.BlockingHttpConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LocalConnector
extends AbstractConnector {
    private static final Logger LOG = Log.getLogger(LocalConnector.class);
    private final BlockingQueue<Request> _requests = new LinkedBlockingQueue<Request>();

    public LocalConnector() {
        this.setMaxIdleTime(30000);
    }

    public Object getConnection() {
        return this;
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, false);
    }

    public String getResponses(String requests, boolean keepOpen) throws Exception {
        ByteArrayBuffer result = this.getResponses(new ByteArrayBuffer(requests, "ISO-8859-1"), keepOpen);
        return result == null ? null : result.toString("ISO-8859-1");
    }

    public ByteArrayBuffer getResponses(ByteArrayBuffer requestsBuffer, boolean keepOpen) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Request request = new Request(requestsBuffer, keepOpen, latch);
        this._requests.add(request);
        latch.await(this.getMaxIdleTime(), TimeUnit.MILLISECONDS);
        return request.getResponsesBuffer();
    }

    protected void accept(int acceptorID) throws IOException, InterruptedException {
        Request request = this._requests.take();
        this.getThreadPool().dispatch((Runnable)request);
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public int getLocalPort() {
        return -1;
    }

    public void executeRequest(String rawRequest) throws IOException {
        Request request = new Request(new ByteArrayBuffer(rawRequest, "UTF-8"), true, null);
        this._requests.add(request);
    }

    private class Request
    implements Runnable {
        private final ByteArrayBuffer _requestsBuffer;
        private final boolean _keepOpen;
        private final CountDownLatch _latch;
        private volatile ByteArrayBuffer _responsesBuffer;

        private Request(ByteArrayBuffer requestsBuffer, boolean keepOpen, CountDownLatch latch) {
            this._requestsBuffer = requestsBuffer;
            this._keepOpen = keepOpen;
            this._latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block14: {
                    ByteArrayEndPoint endPoint;
                    block12: {
                        endPoint = new ByteArrayEndPoint(this._requestsBuffer.asArray(), 1024){

                            public void setConnection(Connection connection) {
                                if (this.getConnection() != null && connection != this.getConnection()) {
                                    LocalConnector.this.connectionUpgraded(this.getConnection(), connection);
                                }
                                super.setConnection(connection);
                            }
                        };
                        endPoint.setGrowOutput(true);
                        BlockingHttpConnection connection = new BlockingHttpConnection(LocalConnector.this, (EndPoint)endPoint, LocalConnector.this.getServer());
                        endPoint.setConnection((Connection)connection);
                        LocalConnector.this.connectionOpened((Connection)connection);
                        boolean leaveOpen = this._keepOpen;
                        try {
                            try {
                                while (endPoint.getIn().length() > 0 && endPoint.isOpen()) {
                                    Connection con;
                                    Connection next;
                                    while ((next = (con = endPoint.getConnection()).handle()) != con) {
                                        endPoint.setConnection(next);
                                    }
                                }
                                Object var7_8 = null;
                                if (leaveOpen) break block12;
                            }
                            catch (IOException x) {
                                LOG.debug((Throwable)x);
                                leaveOpen = false;
                                Object var7_9 = null;
                                if (!leaveOpen) {
                                    LocalConnector.this.connectionClosed((Connection)connection);
                                }
                                this._responsesBuffer = endPoint.getOut();
                                break block14;
                            }
                            catch (Exception x) {
                                LOG.warn((Throwable)x);
                                leaveOpen = false;
                                Object var7_10 = null;
                                if (!leaveOpen) {
                                    LocalConnector.this.connectionClosed((Connection)connection);
                                }
                                this._responsesBuffer = endPoint.getOut();
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            if (!leaveOpen) {
                                LocalConnector.this.connectionClosed((Connection)connection);
                            }
                            this._responsesBuffer = endPoint.getOut();
                            throw throwable;
                        }
                        LocalConnector.this.connectionClosed((Connection)connection);
                    }
                    this._responsesBuffer = endPoint.getOut();
                }
                Object var9_13 = null;
                if (this._latch == null) return;
                this._latch.countDown();
                return;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                if (this._latch == null) throw throwable;
                this._latch.countDown();
                throw throwable;
            }
        }

        public ByteArrayBuffer getResponsesBuffer() {
            return this._responsesBuffer;
        }
    }
}

