/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.eclipse.jetty.http.AbstractGenerator;
import org.eclipse.jetty.http.EncodedHttpURI;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpBuffers;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpMethods;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.UncheckedPrintWriter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.Timeout;

public class HttpConnection
implements Connection {
    private static final int UNKNOWN = -2;
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private final long _timeStamp = System.currentTimeMillis();
    private int _requests;
    private volatile boolean _handling;
    protected final Connector _connector;
    protected final EndPoint _endp;
    protected final Server _server;
    protected final HttpURI _uri;
    protected final Parser _parser;
    protected final HttpFields _requestFields;
    protected final Request _request;
    protected ServletInputStream _in;
    protected final Generator _generator;
    protected final HttpFields _responseFields;
    protected final Response _response;
    protected Output _out;
    protected OutputWriter _writer;
    protected PrintWriter _printWriter;
    int _include;
    private Object _associatedObject;
    private int _version = -2;
    private boolean _expect = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;
    private boolean _head = false;
    private boolean _host = false;
    private boolean _delayedHandling = false;

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static void setCurrentConnection(HttpConnection connection) {
        __currentConnection.set(connection);
    }

    public HttpConnection(Connector connector, EndPoint endpoint, Server server) {
        this._uri = "UTF-8".equals(URIUtil.__CHARSET) ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._endp = endpoint;
        HttpBuffers ab = (HttpBuffers)this._connector;
        this._parser = new HttpParser(ab.getRequestBuffers(), endpoint, (HttpParser.EventHandler)new RequestHandler());
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields(server.getMaxCookieVersion());
        this._request = new Request(this);
        this._response = new Response(this);
        this._generator = new HttpGenerator(ab.getResponseBuffers(), this._endp);
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    protected HttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
        this._uri = URIUtil.__CHARSET.equals("UTF-8") ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._endp = endpoint;
        this._parser = parser;
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields(server.getMaxCookieVersion());
        this._request = request;
        this._response = new Response(this);
        this._generator = generator;
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    public Parser getParser() {
        return this._parser;
    }

    public int getRequests() {
        return this._requests;
    }

    public Server getServer() {
        return this._server;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this._associatedObject = associatedObject;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public HttpFields getResponseFields() {
        return this._responseFields;
    }

    public boolean isConfidential(Request request) {
        if (this._connector != null) {
            return this._connector.isConfidential(request);
        }
        return false;
    }

    public boolean isIntegral(Request request) {
        if (this._connector != null) {
            return this._connector.isIntegral(request);
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    public boolean getResolveNames() {
        return this._connector.getResolveNames();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._expect100Continue) {
            if (((HttpParser)this._parser).getHeaderBuffer() == null || ((HttpParser)this._parser).getHeaderBuffer().length() < 2) {
                if (this._generator.isCommitted()) {
                    throw new IllegalStateException("Committed before 100 Continues");
                }
                ((HttpGenerator)this._generator).send1xx(100);
            }
            this._expect100Continue = false;
        }
        if (this._in == null) {
            this._in = new HttpInput((HttpParser)this._parser, this._connector.getMaxIdleTime());
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() {
        if (this._out == null) {
            this._out = new Output();
        }
        return this._out;
    }

    public PrintWriter getPrintWriter(String encoding) {
        this.getOutputStream();
        if (this._writer == null) {
            this._writer = new OutputWriter();
            this._printWriter = new UncheckedPrintWriter((Writer)this._writer);
        }
        this._writer.setCharacterEncoding(encoding);
        return this._printWriter;
    }

    public boolean isResponseCommitted() {
        return this._generator.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection handle() throws IOException {
        HttpConnection connection = this;
        boolean more_in_buffer = true;
        boolean progress = true;
        try {
            assert (HttpConnection.getCurrentConnection() == null);
            assert (!this._handling);
            this._handling = true;
            HttpConnection.setCurrentConnection(this);
            while (more_in_buffer && this._endp.isOpen()) {
                block53: {
                    long written22;
                    if (this._request._async.isAsync()) {
                        Log.debug((String)"async request", (Object)this._request);
                        if (!this._request._async.isComplete()) {
                            this.handleRequest();
                        } else if (!this._parser.isComplete()) {
                            long parsed = this._parser.parseAvailable();
                            progress |= parsed > 0L;
                        }
                        if (this._generator.isCommitted() && !this._generator.isComplete()) {
                            progress |= this._generator.flushBuffer() > 0L;
                        }
                        if (this._endp.isBufferingOutput()) {
                            this._endp.flush();
                        }
                        break block53;
                    }
                    if (!this._parser.isComplete()) {
                        progress |= this._parser.parseAvailable() > 0L;
                    }
                    while (this._generator.isCommitted() && !this._generator.isComplete() && (written22 = this._generator.flushBuffer()) > 0L) {
                        progress = true;
                        if (!this._endp.isBufferingOutput()) continue;
                        this._endp.flush();
                    }
                    if (this._endp.isBufferingOutput()) {
                        this._endp.flush();
                        if (!this._endp.isBufferingOutput()) {
                            progress = true;
                        }
                    }
                    if (progress) break block53;
                    HttpConnection written22 = this;
                    boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                        Connection switched;
                        Connection connection2 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                        if (switched != null) {
                            this._parser.reset(true);
                            this._generator.reset(true);
                            connection = switched;
                        } else {
                            if (!this._generator.isPersistent()) {
                                this._parser.reset(true);
                                more_in_buffer = false;
                                this._endp.close();
                            }
                            if (more_in_buffer) {
                                this.reset(false);
                                more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            } else {
                                this.reset(true);
                            }
                            progress = true;
                        }
                    }
                    if (this._request.isAsyncStarted()) {
                        Log.debug((String)"return with suspended request");
                        more_in_buffer = false;
                        return written22;
                    } else {
                        if (!this._generator.isCommitted() || this._generator.isComplete() || !(this._endp instanceof AsyncEndPoint)) return written22;
                        ((AsyncEndPoint)this._endp).setWritable(false);
                    }
                    return written22;
                }
                try {
                    progress = false;
                }
                catch (HttpException e) {
                    try {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("uri=" + this._uri));
                            Log.debug((String)("fields=" + this._requestFields));
                            Log.debug((Throwable)e);
                        }
                        this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                        this._parser.reset(true);
                        this._endp.close();
                    }
                    catch (Throwable throwable) {
                        boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                        if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                            Connection switched;
                            Connection connection3 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                            if (switched != null) {
                                this._parser.reset(true);
                                this._generator.reset(true);
                                connection = switched;
                            } else {
                                if (!this._generator.isPersistent()) {
                                    this._parser.reset(true);
                                    more_in_buffer = false;
                                    this._endp.close();
                                }
                                if (more_in_buffer) {
                                    this.reset(false);
                                    more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                                } else {
                                    this.reset(true);
                                }
                                progress = true;
                            }
                        }
                        if (this._request.isAsyncStarted()) {
                            Log.debug((String)"return with suspended request");
                            more_in_buffer = false;
                            throw throwable;
                        } else {
                            if (!this._generator.isCommitted() || this._generator.isComplete() || !(this._endp instanceof AsyncEndPoint)) throw throwable;
                            ((AsyncEndPoint)this._endp).setWritable(false);
                        }
                        throw throwable;
                        return connection;
                    }
                    boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                        Connection switched;
                        Connection connection4 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                        if (switched != null) {
                            this._parser.reset(true);
                            this._generator.reset(true);
                            connection = switched;
                        } else {
                            if (!this._generator.isPersistent()) {
                                this._parser.reset(true);
                                more_in_buffer = false;
                                this._endp.close();
                            }
                            if (more_in_buffer) {
                                this.reset(false);
                                more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            } else {
                                this.reset(true);
                            }
                            progress = true;
                        }
                    }
                    if (this._request.isAsyncStarted()) {
                        Log.debug((String)"return with suspended request");
                        more_in_buffer = false;
                        continue;
                    }
                    if (!this._generator.isCommitted() || this._generator.isComplete() || !(this._endp instanceof AsyncEndPoint)) continue;
                    ((AsyncEndPoint)this._endp).setWritable(false);
                    continue;
                }
                boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                    Connection switched;
                    Connection connection5 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                    if (switched != null) {
                        this._parser.reset(true);
                        this._generator.reset(true);
                        connection = switched;
                    } else {
                        if (!this._generator.isPersistent()) {
                            this._parser.reset(true);
                            more_in_buffer = false;
                            this._endp.close();
                        }
                        if (more_in_buffer) {
                            this.reset(false);
                            more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                        } else {
                            this.reset(true);
                        }
                        progress = true;
                    }
                }
                if (this._request.isAsyncStarted()) {
                    Log.debug((String)"return with suspended request");
                    more_in_buffer = false;
                    continue;
                }
                if (!this._generator.isCommitted() || this._generator.isComplete() || !(this._endp instanceof AsyncEndPoint)) continue;
                ((AsyncEndPoint)this._endp).setWritable(false);
            }
        }
        finally {
            HttpConnection.setCurrentConnection(null);
            this._handling = false;
        }
    }

    public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
        throw new UnsupportedOperationException();
    }

    public void cancelTimeout(Timeout.Task task) {
        throw new UnsupportedOperationException();
    }

    public void reset(boolean returnBuffers) {
        this._parser.reset(returnBuffers);
        this._requestFields.clear();
        this._request.recycle();
        this._generator.reset(returnBuffers);
        this._responseFields.clear();
        this._response.recycle();
        this._uri.clear();
    }

    /*
     * Exception decompiling
     */
    protected void handleRequest() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void commitResponse(boolean last) throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            try {
                if (this._expect100Continue && this._response.getStatus() != 100) {
                    this._generator.setPersistent(false);
                }
                this._generator.completeHeader(this._responseFields, last);
            }
            catch (IOException io) {
                throw io;
            }
            catch (RuntimeException e) {
                Log.warn((String)("header full: " + e));
                this._response.reset();
                this._generator.reset(true);
                this._generator.setResponse(500, null);
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw new HttpException(500);
            }
        }
        if (last) {
            this._generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            try {
                this._generator.completeHeader(this._responseFields, true);
            }
            catch (IOException io) {
                throw io;
            }
            catch (RuntimeException e) {
                Log.warn((String)("header full: " + e));
                Log.debug((Throwable)e);
                this._response.reset();
                this._generator.reset(true);
                this._generator.setResponse(500, null);
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw new HttpException(500);
            }
        }
        this._generator.complete();
    }

    public void flushResponse() throws IOException {
        try {
            this.commitResponse(false);
            this._generator.flushBuffer();
        }
        catch (IOException e) {
            throw e instanceof EofException ? e : new EofException((Throwable)e);
        }
    }

    public Generator getGenerator() {
        return this._generator;
    }

    public boolean isIncluding() {
        return this._include > 0;
    }

    public void include() {
        ++this._include;
    }

    public void included() {
        --this._include;
        if (this._out != null) {
            this._out.reopen();
        }
    }

    public boolean isIdle() {
        return this._generator.isIdle() && (this._parser.isIdle() || this._delayedHandling);
    }

    public boolean isSuspended() {
        return this._request.getAsyncContinuation().isSuspended();
    }

    public boolean isExpecting100Continues() {
        return this._expect100Continue;
    }

    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public class OutputWriter
    extends HttpWriter {
        OutputWriter() {
            super(HttpConnection.this._out);
        }
    }

    public class Output
    extends HttpOutput {
        Output() {
            super((AbstractGenerator)HttpConnection.this._generator, HttpConnection.this._connector.isLowResources() ? (long)HttpConnection.this._connector.getLowResourceMaxIdleTime() : (long)HttpConnection.this._connector.getMaxIdleTime());
        }

        @Override
        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            if (!HttpConnection.this.isIncluding() && !this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(true);
            } else {
                HttpConnection.this.flushResponse();
            }
            super.close();
        }

        @Override
        public void flush() throws IOException {
            if (!this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(false);
            }
            super.flush();
        }

        @Override
        public void print(String s) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            PrintWriter writer = HttpConnection.this.getPrintWriter(null);
            writer.print(s);
        }

        public void sendResponse(Buffer response) throws IOException {
            ((HttpGenerator)this._generator).sendResponse(response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendContent(Object content) throws IOException {
            Resource resource = null;
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (this._generator.getContentWritten() > 0L) {
                throw new IllegalStateException("!empty");
            }
            if (content instanceof HttpContent) {
                HttpContent c = (HttpContent)content;
                Buffer contentType = c.getContentType();
                if (contentType != null && !HttpConnection.this._responseFields.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                    String enc = HttpConnection.this._response.getSetCharacterEncoding();
                    if (enc == null) {
                        HttpConnection.this._responseFields.add(HttpHeaders.CONTENT_TYPE_BUFFER, contentType);
                    } else if (contentType instanceof BufferCache.CachedBuffer) {
                        BufferCache.CachedBuffer content_type = ((BufferCache.CachedBuffer)contentType).getAssociate((Object)enc);
                        if (content_type != null) {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, (Buffer)content_type);
                        } else {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)enc, (String)";= "));
                        }
                    } else {
                        HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)enc, (String)";= "));
                    }
                }
                if (c.getContentLength() > 0L) {
                    HttpConnection.this._responseFields.putLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, c.getContentLength());
                }
                Buffer lm = c.getLastModified();
                long lml = c.getResource().lastModified();
                if (lm != null) {
                    HttpConnection.this._responseFields.put(HttpHeaders.LAST_MODIFIED_BUFFER, lm, lml);
                } else if (c.getResource() != null && lml != -1L) {
                    HttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, lml);
                }
                content = c.getBuffer();
                if (content == null) {
                    content = c.getInputStream();
                }
            } else if (content instanceof Resource) {
                resource = (Resource)content;
                HttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, resource.lastModified());
                content = resource.getInputStream();
            }
            if (content instanceof Buffer) {
                this._generator.addContent((Buffer)content, true);
                HttpConnection.this.commitResponse(true);
            } else if (content instanceof InputStream) {
                InputStream in = (InputStream)content;
                try {
                    int max = this._generator.prepareUncheckedAddContent();
                    Buffer buffer = this._generator.getUncheckedBuffer();
                    int len = buffer.readFrom(in, max);
                    while (len >= 0) {
                        this._generator.completeUncheckedAddContent();
                        HttpConnection.this._out.flush();
                        max = this._generator.prepareUncheckedAddContent();
                        buffer = this._generator.getUncheckedBuffer();
                        len = buffer.readFrom(in, max);
                    }
                    this._generator.completeUncheckedAddContent();
                    HttpConnection.this._out.flush();
                }
                finally {
                    if (resource != null) {
                        resource.release();
                    } else {
                        in.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown content type?");
            }
        }
    }

    private class RequestHandler
    extends HttpParser.EventHandler {
        private String _charset;

        private RequestHandler() {
        }

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            HttpConnection.this._host = false;
            HttpConnection.this._expect = false;
            HttpConnection.this._expect100Continue = false;
            HttpConnection.this._expect102Processing = false;
            HttpConnection.this._delayedHandling = false;
            this._charset = null;
            if (HttpConnection.this._request.getTimeStamp() == 0L) {
                HttpConnection.this._request.setTimeStamp(System.currentTimeMillis());
            }
            HttpConnection.this._request.setMethod(method.toString());
            try {
                switch (HttpMethods.CACHE.getOrdinal(method)) {
                    case 8: {
                        HttpConnection.this._uri.parseConnect(uri.array(), uri.getIndex(), uri.length());
                        break;
                    }
                    case 3: {
                        HttpConnection.this._head = true;
                    }
                    default: {
                        HttpConnection.this._uri.parse(uri.array(), uri.getIndex(), uri.length());
                    }
                }
                HttpConnection.this._request.setUri(HttpConnection.this._uri);
                if (version == null) {
                    HttpConnection.this._request.setProtocol("");
                    HttpConnection.this._version = 9;
                } else {
                    version = HttpVersions.CACHE.get(version);
                    HttpConnection.this._version = HttpVersions.CACHE.getOrdinal(version);
                    if (HttpConnection.this._version <= 0) {
                        HttpConnection.this._version = 10;
                    }
                    HttpConnection.this._request.setProtocol(version.toString());
                }
            }
            catch (Exception e) {
                Log.debug((Throwable)e);
                throw new HttpException(400, null, (Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void parsedHeader(Buffer name, Buffer value) {
            int ho = HttpHeaders.CACHE.getOrdinal(name);
            block0 : switch (ho) {
                case 27: {
                    HttpConnection.this._host = true;
                    break;
                }
                case 24: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    switch (HttpHeaderValues.CACHE.getOrdinal(value)) {
                        case 6: {
                            HttpConnection.this._expect100Continue = HttpConnection.this._generator instanceof HttpGenerator;
                            break block0;
                        }
                        case 7: {
                            HttpConnection.this._expect102Processing = HttpConnection.this._generator instanceof HttpGenerator;
                            break block0;
                        }
                    }
                    String[] values = value.toString().split(",");
                    block24: for (int i = 0; values != null && i < values.length; ++i) {
                        BufferCache.CachedBuffer cb = HttpHeaderValues.CACHE.get(values[i].trim());
                        if (cb == null) {
                            HttpConnection.this._expect = true;
                            continue;
                        }
                        switch (cb.getOrdinal()) {
                            case 6: {
                                HttpConnection.this._expect100Continue = HttpConnection.this._generator instanceof HttpGenerator;
                                continue block24;
                            }
                            case 7: {
                                HttpConnection.this._expect102Processing = HttpConnection.this._generator instanceof HttpGenerator;
                                continue block24;
                            }
                            default: {
                                HttpConnection.this._expect = true;
                            }
                        }
                    }
                    break;
                }
                case 21: 
                case 40: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    break;
                }
                case 16: {
                    value = MimeTypes.CACHE.lookup(value);
                    this._charset = MimeTypes.getCharsetFromContentType((Buffer)value);
                    break;
                }
                case 1: {
                    switch (HttpHeaderValues.CACHE.getOrdinal(value)) {
                        case -1: {
                            String[] values = value.toString().split(",");
                            block25: for (int i = 0; values != null && i < values.length; ++i) {
                                BufferCache.CachedBuffer cb = HttpHeaderValues.CACHE.get(values[i].trim());
                                if (cb == null) continue;
                                switch (cb.getOrdinal()) {
                                    case 1: {
                                        HttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                                        HttpConnection.this._generator.setPersistent(false);
                                        continue block25;
                                    }
                                    case 5: {
                                        if (HttpConnection.this._version != 10) continue block25;
                                        HttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                                        continue block25;
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                            HttpConnection.this._generator.setPersistent(false);
                            break;
                        }
                        case 5: {
                            if (HttpConnection.this._version != 10) break;
                            HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                        }
                    }
                    break;
                }
            }
            HttpConnection.this._requestFields.add(name, value);
        }

        public void headerComplete() throws IOException {
            if (HttpConnection.this._endp instanceof AsyncEndPoint) {
                ((AsyncEndPoint)HttpConnection.this._endp).scheduleIdle();
            }
            HttpConnection.this._requests++;
            HttpConnection.this._generator.setVersion(HttpConnection.this._version);
            switch (HttpConnection.this._version) {
                case 9: {
                    break;
                }
                case 10: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    if (!HttpConnection.this._server.getSendDateHeader()) break;
                    HttpConnection.this._generator.setDate(HttpConnection.this._request.getTimeStampBuffer());
                    break;
                }
                case 11: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    if (HttpConnection.this._server.getSendDateHeader()) {
                        HttpConnection.this._generator.setDate(HttpConnection.this._request.getTimeStampBuffer());
                    }
                    if (!HttpConnection.this._host) {
                        HttpConnection.this._generator.setResponse(400, null);
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        HttpConnection.this._generator.completeHeader(HttpConnection.this._responseFields, true);
                        HttpConnection.this._generator.complete();
                        return;
                    }
                    if (!HttpConnection.this._expect) break;
                    HttpConnection.this._generator.setResponse(417, null);
                    HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                    HttpConnection.this._generator.completeHeader(HttpConnection.this._responseFields, true);
                    HttpConnection.this._generator.complete();
                    return;
                }
            }
            if (this._charset != null) {
                HttpConnection.this._request.setCharacterEncodingUnchecked(this._charset);
            }
            if (((HttpParser)HttpConnection.this._parser).getContentLength() <= 0L && !((HttpParser)HttpConnection.this._parser).isChunking() || HttpConnection.this._expect100Continue) {
                HttpConnection.this.handleRequest();
            } else {
                HttpConnection.this._delayedHandling = true;
            }
        }

        public void content(Buffer ref) throws IOException {
            if (HttpConnection.this._endp instanceof AsyncEndPoint) {
                ((AsyncEndPoint)HttpConnection.this._endp).scheduleIdle();
            }
            if (HttpConnection.this._delayedHandling) {
                HttpConnection.this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        public void messageComplete(long contentLength) throws IOException {
            if (HttpConnection.this._delayedHandling) {
                HttpConnection.this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            Log.debug((String)("Bad request!: " + version + " " + status + " " + reason));
        }
    }
}

