/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AbstractConnectorTest {
    private static final Logger LOG = Log.getLogger(AbstractConnectorTest.class);
    private static Server _server;
    private static AbstractConnector _connector;
    private static CyclicBarrier _connect;
    private static CountDownLatch _closed;
    private Socket[] _socket;
    private PrintWriter[] _out;
    private BufferedReader[] _in;

    @BeforeClass
    public static void init() throws Exception {
        _connect = new CyclicBarrier(2);
        _server = new Server();
        _connector = new SelectChannelConnector(){

            public void connectionClosed(Connection connection) {
                super.connectionClosed(connection);
                _closed.countDown();
            }
        };
        _connector.setStatsOn(true);
        _server.addConnector((Connector)_connector);
        HandlerWrapper wrapper = new HandlerWrapper(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                try {
                    _connect.await();
                }
                catch (Exception ex) {
                    LOG.debug((Throwable)ex);
                }
                finally {
                    super.handle(path, request, httpRequest, httpResponse);
                }
            }
        };
        _server.setHandler((Handler)wrapper);
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                baseRequest.setHandled(true);
                PrintWriter out = response.getWriter();
                out.write("Server response\n");
                out.close();
                response.setStatus(200);
            }
        };
        wrapper.setHandler((Handler)handler);
        _server.start();
    }

    @AfterClass
    public static void destroy() throws Exception {
        _server.stop();
        _server.join();
    }

    @Before
    public void reset() {
        _connector.statsReset();
    }

    @Test
    public void testSingleRequest() throws Exception {
        this.doInit(1);
        this.sendRequest(1, 1);
        this.doClose(1);
        Assert.assertEquals((long)1L, (long)_connector.getConnections());
        Assert.assertEquals((long)0L, (long)_connector.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)_connector.getConnectionsOpenMax());
        Assert.assertTrue((_connector.getConnectionsOpen() <= _connector.getConnectionsOpenMax() ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMean() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMax() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMean() <= (double)_connector.getConnectionsDurationMax() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)_connector.getRequests());
        Assert.assertEquals((double)1.0, (double)_connector.getConnectionsRequestsMean(), (double)0.01);
        Assert.assertEquals((long)1L, (long)_connector.getConnectionsRequestsMax());
        Assert.assertTrue((_connector.getConnectionsRequestsMean() <= (double)_connector.getConnectionsRequestsMax() ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleRequests() throws Exception {
        this.doInit(1);
        this.sendRequest(1, 1);
        this.sendRequest(1, 1);
        this.doClose(1);
        Assert.assertEquals((long)1L, (long)_connector.getConnections());
        Assert.assertEquals((long)0L, (long)_connector.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)_connector.getConnectionsOpenMax());
        Assert.assertTrue((_connector.getConnectionsOpen() <= _connector.getConnectionsOpenMax() ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMean() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMax() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMean() <= (double)_connector.getConnectionsDurationMax() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)_connector.getRequests());
        Assert.assertEquals((double)2.0, (double)_connector.getConnectionsRequestsMean(), (double)0.01);
        Assert.assertEquals((long)2L, (long)_connector.getConnectionsRequestsMax());
        Assert.assertTrue((_connector.getConnectionsRequestsMean() <= (double)_connector.getConnectionsRequestsMax() ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleConnections() throws Exception {
        this.doInit(3);
        this.sendRequest(1, 1);
        this.sendRequest(2, 2);
        this.sendRequest(3, 3);
        this.sendRequest(2, 3);
        this.sendRequest(3, 3);
        this.sendRequest(3, 3);
        this.doClose(3);
        Assert.assertEquals((long)3L, (long)_connector.getConnections());
        Assert.assertEquals((long)0L, (long)_connector.getConnectionsOpen());
        Assert.assertEquals((long)3L, (long)_connector.getConnectionsOpenMax());
        Assert.assertTrue((_connector.getConnectionsOpen() <= _connector.getConnectionsOpenMax() ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMean() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMax() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((_connector.getConnectionsDurationMean() <= (double)_connector.getConnectionsDurationMax() ? 1 : 0) != 0);
        Assert.assertEquals((long)6L, (long)_connector.getRequests());
        Assert.assertEquals((double)2.0, (double)_connector.getConnectionsRequestsMean(), (double)0.01);
        Assert.assertEquals((long)3L, (long)_connector.getConnectionsRequestsMax());
        Assert.assertTrue((_connector.getConnectionsRequestsMean() <= (double)_connector.getConnectionsRequestsMax() ? 1 : 0) != 0);
    }

    protected void doInit(int count) {
        this._socket = new Socket[count];
        this._out = new PrintWriter[count];
        this._in = new BufferedReader[count];
        _closed = new CountDownLatch(count);
    }

    private void doClose(int count) throws Exception {
        for (int idx = 0; idx < count; ++idx) {
            if (this._socket[idx] == null) continue;
            this._socket[idx].close();
        }
        _closed.await();
    }

    private void sendRequest(int id, int count) throws Exception {
        int idx = id - 1;
        if (idx < 0) {
            throw new IllegalArgumentException("Connection ID <= 0");
        }
        this._socket[idx] = this._socket[idx] == null ? new Socket("localhost", _connector.getLocalPort()) : this._socket[idx];
        this._out[idx] = this._out[idx] == null ? new PrintWriter(this._socket[idx].getOutputStream(), true) : this._out[idx];
        this._in[idx] = this._in[idx] == null ? new BufferedReader(new InputStreamReader(this._socket[idx].getInputStream())) : this._in[idx];
        _connect.reset();
        this._out[idx].write("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n");
        this._out[idx].flush();
        _connect.await();
        Assert.assertEquals((long)count, (long)_connector.getConnectionsOpen());
        while (this._in[idx].ready()) {
            this._in[idx].readLine();
        }
    }
}

