/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.IO;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class AsyncRequestReadTest {
    private static Server server;
    private static Connector connector;
    private static final Exchanger<Long> __total;

    @BeforeClass
    public static void startServer() throws Exception {
        server = new Server();
        connector = new SelectChannelConnector();
        connector.setMaxIdleTime(10000);
        server.addConnector(connector);
        server.setHandler((Handler)new EmptyHandler());
        server.start();
    }

    @AfterClass
    public static void stopServer() throws Exception {
        server.stop();
        server.join();
    }

    @Test
    @Ignore
    public void test() throws Exception {
        Socket socket = new Socket("localhost", connector.getLocalPort());
        byte[] content = new byte[65536];
        Arrays.fill(content, (byte)120);
        OutputStream out = socket.getOutputStream();
        String header = "POST / HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n" + "Content-Type: bytes\r\n" + "Connection: close\r\n" + "\r\n";
        byte[] h = header.getBytes("ISO-8859-1");
        out.write(h);
        out.flush();
        out.write(content, 0, 16384);
        Thread.sleep(100L);
        out.write(content, 8192, 16384);
        Thread.sleep(100L);
        out.write(content, 32768, content.length - 32768);
        out.flush();
        InputStream in = socket.getInputStream();
        String response = IO.toString((InputStream)in);
        Assert.assertTrue((response.indexOf("200 OK") > 0 ? 1 : 0) != 0);
        long total = __total.exchange(0L, 30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)content.length, (long)total);
    }

    @Test
    @Ignore
    public void tests() throws Exception {
        this.runTest(64, 4, 4, 20);
        this.runTest(256, 16, 16, 50);
        this.runTest(256, 1, 128, 10);
        this.runTest(131072, 1, 64, 10);
        this.runTest(262144, 5321, 10, 100);
        this.runTest(524288, 32768, 10, 10);
    }

    public void runTest(int contentSize, int chunkSize, int chunks, int delayMS) throws Exception {
        String tst = contentSize + "," + chunkSize + "," + chunks + "," + delayMS;
        Socket socket = new Socket("localhost", connector.getLocalPort());
        byte[] content = new byte[contentSize];
        Arrays.fill(content, (byte)120);
        OutputStream out = socket.getOutputStream();
        out.write("POST / HTTP/1.1\r\n".getBytes());
        out.write("Host: localhost\r\n".getBytes());
        out.write(("Content-Length: " + content.length + "\r\n").getBytes());
        out.write("Content-Type: bytes\r\n".getBytes());
        out.write("Connection: close\r\n".getBytes());
        out.write("\r\n".getBytes());
        out.flush();
        int offset = 0;
        for (int i = 0; i < chunks; ++i) {
            out.write(content, offset, chunkSize);
            offset += chunkSize;
            Thread.sleep(delayMS);
        }
        out.write(content, offset, content.length - offset);
        out.flush();
        InputStream in = socket.getInputStream();
        String response = IO.toString((InputStream)in);
        Assert.assertTrue((String)tst, (response.indexOf("200 OK") > 0 ? 1 : 0) != 0);
        long total = __total.exchange(0L, 30L, TimeUnit.SECONDS);
        Assert.assertEquals((String)tst, (long)content.length, (long)total);
    }

    static {
        __total = new Exchanger();
    }

    private static class EmptyHandler
    extends AbstractHandler {
        private EmptyHandler() {
        }

        public void handle(String path, final Request request, HttpServletRequest httpRequest, final HttpServletResponse httpResponse) throws IOException, ServletException {
            final Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            httpResponse.setStatus(500);
            request.setHandled(true);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long total = 0L;
                    try {
                        int read;
                        ServletInputStream in = request.getInputStream();
                        byte[] b = new byte[16384];
                        while ((read = in.read(b)) >= 0) {
                            total += (long)read;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        total = -1L;
                    }
                    finally {
                        httpResponse.setStatus(200);
                        continuation.complete();
                        try {
                            __total.exchange(total);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
            continuation.suspend();
        }
    }
}

