/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.toolchain.test.PropertyFlag;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncStressTest {
    private static final Logger LOG = Log.getLogger(AsyncStressTest.class);
    protected Server _server = new Server();
    protected SuspendHandler _handler = new SuspendHandler();
    protected SelectChannelConnector _connector;
    protected InetAddress _addr;
    protected int _port;
    protected Random _random = new Random();
    protected QueuedThreadPool _threads = new QueuedThreadPool();
    private static final String[][] __paths = new String[][]{{"/path", "NORMAL"}, {"/path/info", "NORMAL"}, {"/path?sleep=<PERIOD>", "SLEPT"}, {"/path?suspend=<PERIOD>", "TIMEOUT"}, {"/path?suspend=60000&resume=<PERIOD>", "RESUMED"}, {"/path?suspend=60000&complete=<PERIOD>", "COMPLETED"}};
    private static AsyncListener __asyncListener = new AsyncListener(){

        public void onComplete(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getSuppliedRequest().setAttribute("TIMEOUT", (Object)Boolean.TRUE);
            event.getSuppliedRequest().getAsyncContext().dispatch();
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    };

    @Before
    public void init() throws Exception {
        this._threads.setMaxThreads(50);
        this._server.setThreadPool((ThreadPool)this._threads);
        this._connector = new SelectChannelConnector();
        this._connector.setMaxIdleTime(120000);
        this._server.setConnectors(new Connector[]{this._connector});
        this._server.setHandler((Handler)this._handler);
        this._server.start();
        this._port = this._connector.getLocalPort();
        this._addr = InetAddress.getLocalHost();
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testAsync() throws Throwable {
        if (PropertyFlag.isEnabled((String)"test.stress")) {
            this.doConnections(1600, 240);
        } else {
            this.doConnections(80, 80);
        }
    }

    private void doConnections(int connections, int loops) throws Throwable {
        int i;
        Socket[] socket = new Socket[connections];
        int[][] path = new int[connections][loops];
        for (int i2 = 0; i2 < connections; ++i2) {
            socket[i2] = new Socket(this._addr, this._port);
            socket[i2].setSoTimeout(30000);
            if (i2 % 10 == 0) {
                Thread.sleep(50L);
            }
            if (i2 % 80 == 0) {
                System.err.println();
            }
            System.err.print('+');
        }
        System.err.println();
        LOG.info("Bound " + connections, new Object[0]);
        for (int l = 0; l < loops; ++l) {
            for (i = 0; i < connections; ++i) {
                int n = this._random.nextInt(__paths.length);
                path[i][l] = n;
                int p = n;
                int period = this._random.nextInt(290) + 10;
                String uri = __paths[p][0].replace("<PERIOD>", Integer.toString(period));
                long start = System.currentTimeMillis();
                String request = "GET " + uri + " HTTP/1.1\r\n" + "Host: localhost\r\n" + "start: " + start + "\r\n" + "result: " + __paths[p][1] + "\r\n" + (l + 1 < loops ? "" : "Connection: close\r\n") + "\r\n";
                socket[i].getOutputStream().write(request.getBytes("UTF-8"));
                socket[i].getOutputStream().flush();
            }
            if (l % 80 == 0) {
                System.err.println();
            }
            System.err.print('.');
            Thread.sleep(this._random.nextInt(290) + 10);
        }
        System.err.println();
        LOG.info("Sent " + loops * __paths.length + " requests", new Object[0]);
        String[] results = new String[connections];
        for (i = 0; i < connections; ++i) {
            results[i] = IO.toString((InputStream)socket[i].getInputStream(), (String)"UTF-8");
            if (i % 80 == 0) {
                System.err.println();
            }
            System.err.print('-');
        }
        System.err.println();
        LOG.info("Read " + connections + " connections", new Object[0]);
        for (i = 0; i < connections; ++i) {
            int offset = 0;
            String result = results[i];
            for (int l = 0; l < loops; ++l) {
                String expect = __paths[path[i][l]][1];
                expect = expect + " " + expect;
                offset = result.indexOf("200 OK", offset) + 6;
                offset = result.indexOf("\r\n\r\n", offset) + 4;
                int end = result.indexOf("\n", offset);
                String r = result.substring(offset, end).trim();
                Assert.assertEquals((String)(i + "," + l), (Object)expect, (Object)r);
                offset = end;
            }
        }
    }

    private static class SuspendHandler
    extends HandlerWrapper {
        private final Timer _timer = new Timer();

        private SuspendHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, final Request baseRequest, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
            int read_before = 0;
            long sleep_for = -1L;
            long suspend_for = -1L;
            long resume_after = -1L;
            long complete_after = -1L;
            final String uri = baseRequest.getUri().toString();
            if (request.getParameter("read") != null) {
                read_before = Integer.parseInt(request.getParameter("read"));
            }
            if (request.getParameter("sleep") != null) {
                sleep_for = Integer.parseInt(request.getParameter("sleep"));
            }
            if (request.getParameter("suspend") != null) {
                suspend_for = Integer.parseInt(request.getParameter("suspend"));
            }
            if (request.getParameter("resume") != null) {
                resume_after = Integer.parseInt(request.getParameter("resume"));
            }
            if (request.getParameter("complete") != null) {
                complete_after = Integer.parseInt(request.getParameter("complete"));
            }
            if (DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
                if (read_before > 0) {
                    byte[] buf = new byte[read_before];
                    request.getInputStream().read(buf);
                } else if (read_before < 0) {
                    ServletInputStream in = request.getInputStream();
                    int b = in.read();
                    while (b != -1) {
                        b = in.read();
                    }
                }
                if (suspend_for >= 0L) {
                    final AsyncContext asyncContext = baseRequest.startAsync();
                    asyncContext.addListener(__asyncListener);
                    if (suspend_for > 0L) {
                        asyncContext.setTimeout(suspend_for);
                    }
                    if (complete_after > 0L) {
                        TimerTask complete = new TimerTask(){

                            @Override
                            public void run() {
                                try {
                                    response.setStatus(200);
                                    response.getOutputStream().println("COMPLETED " + request.getHeader("result"));
                                    baseRequest.setHandled(true);
                                    asyncContext.complete();
                                }
                                catch (Exception e) {
                                    Request br = (Request)asyncContext.getRequest();
                                    System.err.println("\n" + e.toString());
                                    System.err.println(baseRequest + "==" + br);
                                    System.err.println(uri + "==" + br.getUri());
                                    System.err.println(asyncContext + "==" + br.getAsyncContinuation());
                                    LOG.warn((Throwable)e);
                                    System.exit(1);
                                }
                            }
                        };
                        Timer timer = this._timer;
                        synchronized (timer) {
                            this._timer.schedule(complete, complete_after);
                        }
                    } else if (complete_after == 0L) {
                        response.setStatus(200);
                        response.getOutputStream().println("COMPLETED " + request.getHeader("result"));
                        baseRequest.setHandled(true);
                        asyncContext.complete();
                    } else if (resume_after > 0L) {
                        TimerTask resume = new TimerTask(){

                            @Override
                            public void run() {
                                asyncContext.dispatch();
                            }
                        };
                        Timer timer = this._timer;
                        synchronized (timer) {
                            this._timer.schedule(resume, resume_after);
                        }
                    } else if (resume_after == 0L) {
                        asyncContext.dispatch();
                    }
                } else if (sleep_for >= 0L) {
                    try {
                        Thread.sleep(sleep_for);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    response.setStatus(200);
                    response.getOutputStream().println("SLEPT " + request.getHeader("result"));
                    baseRequest.setHandled(true);
                } else {
                    response.setStatus(200);
                    response.getOutputStream().println("NORMAL " + request.getHeader("result"));
                    baseRequest.setHandled(true);
                }
            } else if (request.getAttribute("TIMEOUT") != null) {
                response.setStatus(200);
                response.getOutputStream().println("TIMEOUT " + request.getHeader("result"));
                baseRequest.setHandled(true);
            } else {
                response.setStatus(200);
                response.getOutputStream().println("RESUMED " + request.getHeader("result"));
                baseRequest.setHandled(true);
            }
        }
    }
}

