/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpServerTestFixture;
import org.junit.Assert;
import org.junit.Test;

public abstract class ConnectorCloseTestBase
extends HttpServerTestFixture {
    private static String __content = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.";
    private static int __length = __content.length();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseBetweenRequests() throws Exception {
        int maxLength = 32;
        int requestCount = this.iterations(maxLength);
        final CountDownLatch latch = new CountDownLatch(requestCount);
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        try {
            OutputStream os = client.getOutputStream();
            ResponseReader reader = new ResponseReader(client){
                private int _index;
                {
                    super(x0);
                    this._index = 0;
                }

                @Override
                protected int doRead() throws IOException, InterruptedException {
                    int count = super.doRead();
                    if (count > 0) {
                        int idx;
                        while ((idx = this._response.indexOf("HTTP/1.1 200 OK", this._index)) >= 0) {
                            latch.countDown();
                            this._index = idx + 15;
                        }
                    }
                    return count;
                }
            };
            Thread runner = new Thread(reader);
            runner.start();
            for (int pipeline = 1; pipeline < maxLength; ++pipeline) {
                if (pipeline == maxLength / 2) {
                    _connector.close();
                }
                String request = "";
                for (int i = 0; i < pipeline; ++i) {
                    request = request + "GET /data?writes=1&block=16&id=" + i + " HTTP/1.1\r\n" + "host: " + "localhost" + ":" + _connector.getLocalPort() + "\r\n" + "user-agent: testharness/1.0 (blah foo/bar)\r\n" + "accept-encoding: nothing\r\n" + "cookie: aaa=1234567890\r\n" + "\r\n";
                }
                os.write(request.getBytes());
                os.flush();
                Thread.sleep(25L);
            }
            latch.await(30L, TimeUnit.SECONDS);
            reader.setDone();
            runner.join();
        }
        finally {
            client.close();
            Assert.assertEquals((long)requestCount, (long)((long)requestCount - latch.getCount()));
        }
    }

    private int iterations(int cnt) {
        return cnt > 0 ? this.iterations(--cnt) + cnt : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseBetweenChunks() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        try {
            int offset;
            OutputStream os = client.getOutputStream();
            ResponseReader reader = new ResponseReader(client);
            Thread runner = new Thread(reader);
            runner.start();
            byte[] bytes = __content.getBytes("utf-8");
            os.write(("POST /echo?charset=utf-8 HTTP/1.1\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: " + bytes.length + "\r\n" + "\r\n").getBytes("iso-8859-1"));
            int len = bytes.length;
            int stop = len / 2;
            for (offset = 0; offset < stop; offset += 64) {
                os.write(bytes, offset, 64);
                Thread.sleep(25L);
            }
            _connector.close();
            while (offset < len) {
                os.write(bytes, offset, len - offset <= 64 ? len - offset : 64);
                offset += 64;
                Thread.sleep(25L);
            }
            os.flush();
            reader.setDone();
            runner.join();
            String in = reader.getResponse().toString();
            Assert.assertTrue((in.indexOf(__content.substring(__length - 64)) > 0 ? 1 : 0) != 0);
        }
        finally {
            client.close();
        }
    }

    public class ResponseReader
    implements Runnable {
        private boolean _done = false;
        protected char[] _buffer = new char[256];
        protected StringBuffer _response = new StringBuffer();
        protected BufferedReader _reader;

        public ResponseReader(Socket client) throws IOException {
            this._reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
        }

        public void setDone() {
            this._done = true;
        }

        public StringBuffer getResponse() {
            return this._response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int count = 0;
                while (!this._done || count > 0) {
                    count = this.doRead();
                }
            }
            catch (IOException ex) {
            }
            catch (InterruptedException ex) {
            }
            finally {
                try {
                    this._reader.close();
                }
                catch (IOException e) {}
            }
        }

        protected int doRead() throws IOException, InterruptedException {
            if (!this._reader.ready()) {
                Thread.sleep(25L);
            }
            int count = 0;
            if (this._reader.ready() && (count = this._reader.read(this._buffer)) > 0) {
                this._response.append(this._buffer, 0, count);
            }
            return count;
        }
    }
}

