/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpServerTestFixture;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

public abstract class ConnectorTimeoutTest
extends HttpServerTestFixture {
    protected static final int MAX_IDLE_TIME = 250;
    private int sleepTime = 300;
    private int minimumTestRuntime = 200;
    private int maximumTestRuntime = 2500;

    @Test
    public void testMaxIdleWithRequest10() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        client.setSoTimeout(10000);
        Assert.assertFalse((boolean)client.isClosed());
        OutputStream os = client.getOutputStream();
        InputStream is = client.getInputStream();
        os.write(("GET / HTTP/1.0\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "connection: keep-alive\r\n" + "\r\n").getBytes("utf-8"));
        os.flush();
        long start = System.currentTimeMillis();
        IO.toString((InputStream)is);
        Thread.sleep(this.sleepTime);
        Assert.assertEquals((long)-1L, (long)is.read());
        Assert.assertTrue((System.currentTimeMillis() - start > (long)this.minimumTestRuntime ? 1 : 0) != 0);
        Assert.assertTrue((System.currentTimeMillis() - start < (long)this.maximumTestRuntime ? 1 : 0) != 0);
    }

    @Test
    public void testMaxIdleWithRequest11() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        client.setSoTimeout(10000);
        Assert.assertFalse((boolean)client.isClosed());
        OutputStream os = client.getOutputStream();
        InputStream is = client.getInputStream();
        String content = "Wibble";
        byte[] contentB = content.getBytes("utf-8");
        os.write(("POST /echo HTTP/1.1\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: " + contentB.length + "\r\n" + "\r\n").getBytes("utf-8"));
        os.write(contentB);
        os.flush();
        long start = System.currentTimeMillis();
        IO.toString((InputStream)is);
        Thread.sleep(this.sleepTime);
        Assert.assertEquals((long)-1L, (long)is.read());
        Assert.assertTrue((System.currentTimeMillis() - start > (long)this.minimumTestRuntime ? 1 : 0) != 0);
        Assert.assertTrue((System.currentTimeMillis() - start < (long)this.maximumTestRuntime ? 1 : 0) != 0);
    }

    @Test
    public void testMaxIdleWithRequest10NoClientClose() throws Exception {
        final Exchanger<Object> endpoint = new Exchanger<Object>();
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler(){

            @Override
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                try {
                    endpoint.exchange(baseRequest.getConnection().getEndPoint());
                }
                catch (Exception e) {
                    // empty catch block
                }
                super.handle(target, baseRequest, request, response);
            }
        });
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        client.setSoTimeout(10000);
        Assert.assertFalse((boolean)client.isClosed());
        OutputStream os = client.getOutputStream();
        InputStream is = client.getInputStream();
        os.write(("GET / HTTP/1.0\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "connection: close\r\n" + "\r\n").getBytes("utf-8"));
        os.flush();
        EndPoint endp = endpoint.exchange(null, 10L, TimeUnit.SECONDS);
        if (endp instanceof SslConnection.SslEndPoint) {
            endp = ((SslConnection.SslEndPoint)endp).getEndpoint();
        }
        String result = IO.toString((InputStream)is);
        Assert.assertThat((String)"OK", (Object)result, (Matcher)JUnitMatchers.containsString((String)"200 OK"));
        Assert.assertEquals((long)-1L, (long)is.read());
        TimeUnit.MILLISECONDS.sleep(375L);
        try {
            for (int i = 0; i < 1000; ++i) {
                os.write(("GET / HTTP/1.0\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "connection: keep-alive\r\n" + "\r\n").getBytes("utf-8"));
                os.flush();
            }
            Assert.fail((String)"half close should have timed out");
        }
        catch (SocketException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)endp.isOpen());
    }

    @Test
    public void testMaxIdleWithRequest11NoClientClose() throws Exception {
        final Exchanger<Object> endpoint = new Exchanger<Object>();
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler(){

            @Override
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                try {
                    endpoint.exchange(baseRequest.getConnection().getEndPoint());
                }
                catch (Exception e) {
                    // empty catch block
                }
                super.handle(target, baseRequest, request, response);
            }
        });
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        client.setSoTimeout(10000);
        Assert.assertFalse((boolean)client.isClosed());
        OutputStream os = client.getOutputStream();
        InputStream is = client.getInputStream();
        String content = "Wibble";
        byte[] contentB = content.getBytes("utf-8");
        os.write(("POST /echo HTTP/1.1\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: " + contentB.length + "\r\n" + "connection: close\r\n" + "\r\n").getBytes("utf-8"));
        os.write(contentB);
        os.flush();
        EndPoint endp = endpoint.exchange(null, 10L, TimeUnit.SECONDS);
        IO.toString((InputStream)is);
        Assert.assertEquals((long)-1L, (long)is.read());
        TimeUnit.MILLISECONDS.sleep(375L);
        try {
            for (int i = 0; i < 1000; ++i) {
                os.write(("GET / HTTP/1.0\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "connection: keep-alive\r\n" + "\r\n").getBytes("utf-8"));
                os.flush();
            }
            Assert.fail((String)"half close should have timed out");
        }
        catch (SocketException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)endp.isOpen());
    }

    @Test
    public void testMaxIdleNoRequest() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        client.setSoTimeout(10000);
        InputStream is = client.getInputStream();
        Assert.assertFalse((boolean)client.isClosed());
        Thread.sleep(this.sleepTime);
        long start = System.currentTimeMillis();
        try {
            IO.toString((InputStream)is);
            Assert.assertEquals((long)-1L, (long)is.read());
        }
        catch (SSLException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertTrue((System.currentTimeMillis() - start < (long)this.maximumTestRuntime ? 1 : 0) != 0);
    }

    @Test
    public void testMaxIdleWithSlowRequest() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        client.setSoTimeout(10000);
        Assert.assertFalse((boolean)client.isClosed());
        OutputStream os = client.getOutputStream();
        InputStream is = client.getInputStream();
        String content = "Wibble\r\n";
        byte[] contentB = content.getBytes("utf-8");
        os.write(("GET / HTTP/1.0\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "connection: keep-alive\r\n" + "Content-Length: " + contentB.length * 20 + "\r\n" + "Content-Type: text/plain\r\n" + "Connection: close\r\n" + "\r\n").getBytes("utf-8"));
        os.flush();
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(50L);
            os.write(contentB);
            os.flush();
        }
        String in = IO.toString((InputStream)is);
        int offset = 0;
        for (int i = 0; i < 20; ++i) {
            offset = in.indexOf("Wibble", offset + 1);
            Assert.assertTrue((String)("" + i), (offset > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMaxIdleWithSlowResponse() throws Exception {
        this.configureServer((Handler)new SlowResponseHandler());
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        client.setSoTimeout(10000);
        Assert.assertFalse((boolean)client.isClosed());
        OutputStream os = client.getOutputStream();
        InputStream is = client.getInputStream();
        os.write(("GET / HTTP/1.0\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "connection: keep-alive\r\n" + "Connection: close\r\n" + "\r\n").getBytes("utf-8"));
        os.flush();
        String in = IO.toString((InputStream)is);
        int offset = 0;
        for (int i = 0; i < 20; ++i) {
            offset = in.indexOf("Hello World", offset + 1);
            Assert.assertTrue((String)("" + i), (offset > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMaxIdleWithWait() throws Exception {
        this.configureServer((Handler)new WaitHandler());
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        client.setSoTimeout(10000);
        Assert.assertFalse((boolean)client.isClosed());
        OutputStream os = client.getOutputStream();
        InputStream is = client.getInputStream();
        os.write(("GET / HTTP/1.0\r\nhost: localhost:" + _connector.getLocalPort() + "\r\n" + "connection: keep-alive\r\n" + "Connection: close\r\n" + "\r\n").getBytes("utf-8"));
        os.flush();
        String in = IO.toString((InputStream)is);
        int offset = in.indexOf("Hello World");
        Assert.assertTrue((offset > 0 ? 1 : 0) != 0);
    }

    static {
        System.setProperty("org.eclipse.jetty.io.nio.IDLE_TICK", "100");
    }

    protected static class WaitHandler
    extends AbstractHandler {
        protected WaitHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            out.write("Hello World\r\n".getBytes());
            out.flush();
        }
    }

    protected static class SlowResponseHandler
    extends AbstractHandler {
        protected SlowResponseHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            for (int i = 0; i < 20; ++i) {
                out.write("Hello World\r\n".getBytes());
                out.flush();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            out.close();
        }
    }
}

