/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DumpHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(DumpHandler.class);
    String label = "Dump HttpHandler";

    public DumpHandler() {
    }

    public DumpHandler(String label) {
        this.label = label;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Cookie cookie;
        if (!this.isStarted()) {
            return;
        }
        if (request.getParameter("read") != null) {
            BufferedReader in = request.getReader();
            int i = Integer.parseInt(request.getParameter("read"));
            while (i-- > 0) {
                ((Reader)in).read();
            }
        }
        if (request.getParameter("ISE") != null) {
            throw new IllegalStateException();
        }
        if (request.getParameter("error") != null) {
            response.sendError(Integer.parseInt(request.getParameter("error")));
            return;
        }
        if (request.getParameter("continue") != null) {
            Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request, (ServletResponse)response);
            continuation.setTimeout(Long.parseLong(request.getParameter("continue")));
            continuation.suspend();
        }
        baseRequest.setHandled(true);
        response.setHeader("Content-Type", "text/html");
        ServletOutputStream out = response.getOutputStream();
        ByteArrayOutputStream buf = new ByteArrayOutputStream(2048);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, "ISO-8859-1");
        writer.write("<html><h1>" + this.label + "</h1>");
        writer.write("<pre>\npathInfo=" + request.getPathInfo() + "\n</pre>\n");
        writer.write("<pre>\ncontentType=" + request.getContentType() + "\n</pre>\n");
        writer.write("<pre>\nencoding=" + request.getCharacterEncoding() + "\n</pre>\n");
        writer.write("<h3>Header:</h3><pre>");
        writer.write(request.getMethod() + " " + request.getRequestURI() + " " + request.getProtocol() + "\n");
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            writer.write(name);
            writer.write(": ");
            writer.write(request.getHeader(name));
            writer.write("\n");
        }
        writer.write("</pre>\n<h3>Parameters:</h3>\n<pre>");
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String[] values = request.getParameterValues(name);
            if (values == null || values.length == 0) {
                writer.write(name);
                writer.write("=\n");
                continue;
            }
            if (values.length == 1) {
                writer.write(name);
                writer.write("=");
                writer.write(values[0]);
                writer.write("\n");
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                writer.write(name);
                writer.write("[" + i + "]=");
                writer.write(values[i]);
                writer.write("\n");
            }
        }
        String cookie_name = request.getParameter("CookieName");
        if (cookie_name != null && cookie_name.trim().length() > 0) {
            String cookie_action = request.getParameter("Button");
            try {
                String val = request.getParameter("CookieVal");
                val = val.replaceAll("[ \n\r=<>]", "?");
                cookie = new Cookie(cookie_name.trim(), val);
                if ("Clear Cookie".equals(cookie_action)) {
                    cookie.setMaxAge(0);
                }
                response.addCookie(cookie);
            }
            catch (IllegalArgumentException e) {
                writer.write("</pre>\n<h3>BAD Set-Cookie:</h3>\n<pre>");
                writer.write(e.toString());
            }
        }
        writer.write("</pre>\n<h3>Cookies:</h3>\n<pre>");
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (int c = 0; c < cookies.length; ++c) {
                cookie = cookies[c];
                writer.write(cookie.getName());
                writer.write("=");
                writer.write(cookie.getValue());
                writer.write("\n");
            }
        }
        writer.write("</pre>\n<h3>Attributes:</h3>\n<pre>");
        Enumeration attributes = request.getAttributeNames();
        if (attributes != null && attributes.hasMoreElements()) {
            while (attributes.hasMoreElements()) {
                String attr = attributes.nextElement().toString();
                writer.write(attr);
                writer.write("=");
                writer.write(request.getAttribute(attr).toString());
                writer.write("\n");
            }
        }
        writer.write("</pre>\n<h3>Content:</h3>\n<pre>");
        char[] content = new char[4096];
        try {
            int len;
            BufferedReader in = request.getReader();
            while ((len = in.read(content)) >= 0) {
                writer.write(new String(content, 0, len));
            }
        }
        catch (IOException e) {
            writer.write(e.toString());
        }
        writer.write("</pre>");
        writer.write("</html>");
        ((Writer)writer).flush();
        response.setContentLength(buf.size() + 1000);
        try {
            buf.writeTo((OutputStream)out);
            buf.reset();
            ((Writer)writer).flush();
            int pad = 998 - buf.size();
            while (pad-- > 0) {
                writer.write(" ");
            }
            writer.write("\r\n");
            ((Writer)writer).flush();
            buf.writeTo((OutputStream)out);
            response.setHeader("IgnoreMe", "ignored");
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
    }
}

