/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpConnectionTest {
    private static final Logger LOG = Log.getLogger(HttpConnectionTest.class);
    private Server server;
    private LocalConnector connector;

    @Before
    public void init() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector();
        this.server.addConnector((Connector)this.connector);
        this.connector.setRequestHeaderSize(1024);
        this.connector.setResponseHeaderSize(1024);
        this.server.setHandler((Handler)new DumpHandler());
        this.server.start();
    }

    @After
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testFragmentedChunk() {
        block2: {
            String response = null;
            try {
                int offset = 0;
                offset = 0;
                response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
                offset = this.checkContains(response, offset, "HTTP/1.1 200");
                offset = this.checkContains(response, offset, "/R1");
                offset = this.checkContains(response, offset, "12345");
                offset = 0;
                response = this.connector.getResponses("GET /R2 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\r\n5;\r\nABCDE\r\n0;\r\n\r\n");
                offset = this.checkContains(response, offset, "HTTP/1.1 200");
                offset = this.checkContains(response, offset, "/R2");
                offset = this.checkContains(response, offset, "ABCDE");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)false);
                if (response == null) break block2;
                System.err.println(response);
            }
        }
    }

    @Test
    public void testNoPath() throws Exception {
        String response = this.connector.getResponses("GET http://localhost:80 HTTP/1.1\nHost: localhost:80\n\n");
        int offset = 0;
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        this.checkContains(response, offset, "pathInfo=/");
    }

    @Test
    public void testBadNoPath() throws Exception {
        String response = this.connector.getResponses("GET http://localhost:80/../cheat HTTP/1.1\nHost: localhost:80\n\n");
        int offset = 0;
        offset = this.checkContains(response, offset, "HTTP/1.1 400");
    }

    @Test
    public void testOKPathDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /ooops/../path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 200 OK");
        this.checkContains(response, 0, "pathInfo=/path");
    }

    @Test
    public void testBadPathDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /ooops/../../path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testOKPathEncodedDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /ooops/%2e%2e/path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 200 OK");
        this.checkContains(response, 0, "pathInfo=/path");
    }

    @Test
    public void testBadPathEncodedDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /ooops/%2e%2e/%2e%2e/path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testBadDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET ../path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testBadSlashDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /../path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testEncodedBadDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET %2e%2e/path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testEmpty() throws Exception {
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\r\n0\r\n\r\n");
        int offset = 0;
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        this.checkContains(response, offset, "/R1");
    }

    @Test
    public void testHead() throws Exception {
        String responsePOST = this.connector.getResponses("POST /R1 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        String responseHEAD = this.connector.getResponses("HEAD /R1 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        Assert.assertTrue((boolean)responsePOST.startsWith(responseHEAD.substring(0, responseHEAD.length() - 2)));
        Assert.assertTrue((responsePOST.length() > responseHEAD.length() ? 1 : 0) != 0);
        responsePOST = this.connector.getResponses("POST /R1 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        Assert.assertTrue((boolean)responsePOST.startsWith(responseHEAD.substring(0, responseHEAD.length() - 2)));
        Assert.assertTrue((responsePOST.length() > responseHEAD.length() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBad() throws Exception {
        try {
            ((StdErrLog)Log.getLogger(AbstractHttpConnection.class)).setHideStacks(true);
            String response = this.connector.getResponses("GET % HTTP/1.1\nHost: localhost\n\r\n");
            this.checkContains(response, 0, "HTTP/1.1 400");
            response = this.connector.getResponses("GET http://localhost:WRONG/ HTTP/1.1\nHost: localhost\n\r\n");
            this.checkContains(response, 0, "HTTP/1.1 400");
            response = this.connector.getResponses("GET /bad/encoding%1 HTTP/1.1\nHost: localhost\n\r\n");
            this.checkContains(response, 0, "HTTP/1.1 400");
            response = this.connector.getResponses("GET /foo/bar%c0%00 HTTP/1.1\nHost: localhost\n\r\n");
            this.checkContains(response, 0, "HTTP/1.1 200");
            response = this.connector.getResponses("GET /bad/utf8%c1 HTTP/1.1\nHost: localhost\n\r\n");
            this.checkContains(response, 0, "HTTP/1.1 200");
        }
        finally {
            ((StdErrLog)Log.getLogger(AbstractHttpConnection.class)).setHideStacks(false);
        }
    }

    @Test
    public void testAutoFlush() throws Exception {
        String response = null;
        int offset = 0;
        offset = 0;
        response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        this.checkNotContained(response, offset, "IgnoreMe");
        offset = this.checkContains(response, offset, "/R1");
        offset = this.checkContains(response, offset, "12345");
    }

    @Test
    public void testCharset() {
        block2: {
            String response = null;
            try {
                int offset = 0;
                offset = 0;
                response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
                offset = this.checkContains(response, offset, "HTTP/1.1 200");
                offset = this.checkContains(response, offset, "/R1");
                offset = this.checkContains(response, offset, "encoding=UTF-8");
                offset = this.checkContains(response, offset, "12345");
                offset = 0;
                response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset =  iso-8859-1 ; other=value\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
                offset = this.checkContains(response, offset, "HTTP/1.1 200");
                offset = this.checkContains(response, offset, "encoding=iso-8859-1");
                offset = this.checkContains(response, offset, "/R1");
                offset = this.checkContains(response, offset, "12345");
                offset = 0;
                response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=unknown\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
                offset = this.checkContains(response, offset, "HTTP/1.1 200");
                offset = this.checkContains(response, offset, "encoding=unknown");
                offset = this.checkContains(response, offset, "/R1");
                offset = this.checkContains(response, offset, "UnsupportedEncodingException");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)false);
                if (response == null) break block2;
                System.err.println(response);
            }
        }
    }

    @Test
    public void testUnconsumedError() throws Exception {
        String response = null;
        String requests = null;
        int offset = 0;
        offset = 0;
        requests = "GET /R1?read=1&error=500 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n5;\r\n67890\r\n0;\r\n\r\nGET /R2 HTTP/1.1\nHost: localhost\nContent-Type: text/plain; charset=utf-8\nContent-Length: 10\n\nabcdefghij\n";
        response = this.connector.getResponses(requests);
        offset = this.checkContains(response, offset, "HTTP/1.1 500");
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        offset = this.checkContains(response, offset, "/R2");
        offset = this.checkContains(response, offset, "encoding=UTF-8");
        offset = this.checkContains(response, offset, "abcdefghij");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnconsumedException() throws Exception {
        String response = null;
        String requests = null;
        int offset = 0;
        offset = 0;
        requests = "GET /R1?read=1&ISE=true HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n5;\r\n67890\r\n0;\r\n\r\nGET /R2 HTTP/1.1\nHost: localhost\nContent-Type: text/plain; charset=utf-8\nContent-Length: 10\n\nabcdefghij\n";
        Object logger = null;
        try {
            ((StdErrLog)Log.getLogger(AbstractHttpConnection.class)).setHideStacks(true);
            response = this.connector.getResponses(requests);
            offset = this.checkContains(response, offset, "HTTP/1.1 500");
            offset = this.checkContains(response, offset, "Connection: close");
            this.checkNotContained(response, offset, "HTTP/1.1 200");
        }
        finally {
            ((StdErrLog)Log.getLogger(AbstractHttpConnection.class)).setHideStacks(false);
        }
    }

    @Test
    public void testConnection() {
        block2: {
            String response = null;
            try {
                int offset = 0;
                offset = 0;
                response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nConnection: TE, close\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
                this.checkContains(response, offset, "Connection: close");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)false);
                if (response == null) break block2;
                System.err.println(response);
            }
        }
    }

    @Test
    public void testOversizedBuffer() throws Exception {
        String response = null;
        try {
            int offset = 0;
            String cookie = "thisisastringthatshouldreachover1kbytes";
            for (int i = 0; i < 100; ++i) {
                cookie = cookie + "xxxxxxxxxxxx";
            }
            response = this.connector.getResponses("GET / HTTP/1.1\nHost: localhost\nCookie: " + cookie + "\n" + "\r\n");
            this.checkContains(response, offset, "HTTP/1.1 413");
        }
        catch (Exception e) {
            if (response != null) {
                System.err.println(response);
            }
            throw e;
        }
    }

    @Test
    public void testExcessiveHeader() throws Exception {
        String response = null;
        int offset = 0;
        StringBuilder request = new StringBuilder();
        request.append("GET / HTTP/1.1\n");
        request.append("Host: localhost\n");
        request.append("Cookie: thisisastring\n");
        for (int i = 0; i < 1000; ++i) {
            request.append(String.format("X-Header-%04d: %08x\n", i, i));
        }
        request.append("\r\n");
        response = this.connector.getResponses(request.toString());
        System.err.println(response);
        this.checkContains(response, offset, "HTTP/1.1 413");
    }

    @Test
    public void testOversizedResponse() throws Exception {
        String str = "thisisastringthatshouldreachover1kbytes-";
        for (int i = 0; i < 500; ++i) {
            str = str + "xxxxxxxxxxxx";
        }
        final String longstr = str;
        String response = null;
        this.server.stop();
        this.server.setHandler((Handler)new DumpHandler(){

            @Override
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                try {
                    baseRequest.setHandled(true);
                    response.setHeader("Content-Type", "text/html");
                    response.setHeader("LongStr", longstr);
                    PrintWriter writer = response.getWriter();
                    writer.write("<html><h1>FOO</h1></html>");
                    writer.flush();
                    if (!writer.checkError()) {
                        throw new RuntimeException("SHOULD NOT GET HERE");
                    }
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                    LOG.info("correctly ignored " + e, new Object[0]);
                }
            }
        });
        this.server.start();
        try {
            int offset = 0;
            response = this.connector.getResponses("GET / HTTP/1.1\nHost: localhost\n\r\n");
            this.checkContains(response, offset, "HTTP/1.1 500");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (response != null) {
                System.err.println(response);
            }
            Assert.fail((String)"Exception");
        }
    }

    @Test
    public void testAsterisk() {
        block2: {
            String response = null;
            try {
                int offset = 0;
                response = this.connector.getResponses("OPTIONS * HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
                offset = this.checkContains(response, offset, "HTTP/1.1 200");
                offset = this.checkContains(response, offset, "*");
                this.server.stop();
                this.server.setHandler(null);
                this.server.start();
                offset = 0;
                response = this.connector.getResponses("GET * HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
                offset = this.checkContains(response, offset, "HTTP/1.1 404 Not Found");
                offset = 0;
                response = this.connector.getResponses("GET ** HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
                offset = this.checkContains(response, offset, "HTTP/1.1 400 Bad Request");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)false);
                if (response == null) break block2;
                System.err.println(response);
            }
        }
    }

    @Test
    public void testCONNECT() {
        block2: {
            String response = null;
            try {
                int offset = 0;
                response = this.connector.getResponses("CONNECT www.webtide.com:8080 HTTP/1.1\nHost: myproxy:8888\r\n\r\n");
                this.checkContains(response, offset, "HTTP/1.1 200");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)false);
                if (response == null) break block2;
                System.err.println(response);
            }
        }
    }

    private int checkContains(String s, int offset, String c) {
        int o = s.indexOf(c, offset);
        if (o < offset) {
            System.err.println("FAILED");
            System.err.println("'" + c + "' not in:");
            System.err.println(s.substring(offset));
            System.err.flush();
            System.out.println("--\n" + s);
            System.out.flush();
            Assert.assertTrue((boolean)false);
        }
        return o;
    }

    private void checkNotContained(String s, int offset, String c) {
        int o = s.indexOf(c, offset);
        if (o >= offset) {
            System.err.println("FAILED");
            System.err.println("'" + c + "' IS in:");
            System.err.println(s.substring(offset));
            System.err.flush();
            System.out.println("--\n" + s);
            System.out.flush();
            Assert.assertTrue((boolean)false);
        }
    }
}

