/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.jetty.http.AbstractGenerator;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SimpleBuffers;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpWriterTest {
    private HttpWriter _writer;
    private ByteArrayBuffer _bytes;

    @Before
    public void init() throws Exception {
        this._bytes = new ByteArrayBuffer(2048);
        SimpleBuffers buffers = new SimpleBuffers((Buffer)new ByteArrayBuffer(1024), (Buffer)new ByteArrayBuffer(1024));
        ByteArrayEndPoint endp = new ByteArrayEndPoint();
        AbstractGenerator generator = new AbstractGenerator((Buffers)buffers, (EndPoint)endp){

            public boolean isRequest() {
                return false;
            }

            public boolean isResponse() {
                return true;
            }

            public void completeHeader(HttpFields fields, boolean allContentAdded) throws IOException {
            }

            public int flushBuffer() throws IOException {
                return 0;
            }

            public int prepareUncheckedAddContent() throws IOException {
                return 1024;
            }

            public void addContent(Buffer content, boolean last) throws IOException {
                HttpWriterTest.this._bytes.put(content);
                content.clear();
            }

            public boolean addContent(byte b) throws IOException {
                return false;
            }
        };
        AbstractHttpConnection connection = new AbstractHttpConnection(null, (EndPoint)endp, new Server(), null, (Generator)generator, null){

            public Connection handle() throws IOException {
                return null;
            }
        };
        endp.setMaxIdleTime(60000);
        HttpOutput httpOut = new HttpOutput(connection);
        this._writer = new HttpWriter(httpOut);
    }

    @Test
    public void testSimpleUTF8() throws Exception {
        this._writer.setCharacterEncoding("UTF-8");
        this._writer.write("Now is the time");
        this.assertArrayEquals("Now is the time".getBytes("UTF-8"), this._bytes.asArray());
    }

    @Test
    public void testUTF8() throws Exception {
        this._writer.setCharacterEncoding("UTF-8");
        this._writer.write("How now \uff22rown cow");
        this.assertArrayEquals("How now \uff22rown cow".getBytes("UTF-8"), this._bytes.asArray());
    }

    @Test
    public void testNotCESU8() throws Exception {
        this._writer.setCharacterEncoding("UTF-8");
        String data = "xxx\ud801\udc00xxx";
        this._writer.write(data);
        Assert.assertEquals((Object)"787878F0909080787878", (Object)TypeUtil.toHexString((byte[])this._bytes.asArray()));
        this.assertArrayEquals(data.getBytes("UTF-8"), this._bytes.asArray());
        Assert.assertEquals((long)10L, (long)this._bytes.length());
        Utf8StringBuilder buf = new Utf8StringBuilder();
        buf.append(this._bytes.asArray(), 0, this._bytes.length());
        Assert.assertEquals((Object)data, (Object)buf.toString());
    }

    @Test
    public void testMultiByteOverflowUTF8() throws Exception {
        int i;
        this._writer.setCharacterEncoding("UTF-8");
        String singleByteStr = "a";
        String multiByteDuplicateStr = "\uff22";
        int remainSize = 1;
        int multiByteStrByteLength = "\uff22".getBytes("UTF-8").length;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 512 - multiByteStrByteLength; ++i) {
            sb.append("a");
        }
        sb.append("\uff22");
        for (i = 0; i < remainSize; ++i) {
            sb.append("a");
        }
        char[] buf = new char[1536];
        int length = 512 - multiByteStrByteLength + remainSize + 1;
        sb.toString().getChars(0, length, buf, 0);
        this._writer.write(buf, 0, length);
        Assert.assertEquals((Object)sb.toString(), (Object)new String(this._bytes.asArray(), "UTF-8"));
    }

    @Test
    public void testISO8859() throws Exception {
        this._writer.setCharacterEncoding("ISO-8859-1");
        this._writer.write("How now \uff22rown cow");
        Assert.assertEquals((Object)"How now ?rown cow", (Object)new String(this._bytes.asArray(), "ISO-8859-1"));
    }

    @Test
    public void testOutput() throws Exception {
        ByteArrayBuffer sb = new ByteArrayBuffer(1500);
        ByteArrayBuffer bb = new ByteArrayBuffer(8096);
        HttpFields fields = new HttpFields();
        ByteArrayEndPoint endp = new ByteArrayEndPoint(new byte[0], 4096);
        HttpGenerator hb = new HttpGenerator((Buffers)new SimpleBuffers((Buffer)sb, (Buffer)bb), (EndPoint)endp);
        hb.setResponse(200, "OK");
        AbstractHttpConnection connection = new AbstractHttpConnection(null, (EndPoint)endp, new Server(), null, (Generator)hb, null){

            public Connection handle() throws IOException {
                return null;
            }
        };
        endp.setMaxIdleTime(10000);
        hb.setSendServerVersion(false);
        HttpOutput output = new HttpOutput(connection);
        HttpWriter writer = new HttpWriter(output);
        writer.setCharacterEncoding("UTF-8");
        char[] chars = new char[1024];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(48 + i % 10);
        }
        chars[0] = 1363;
        writer.write(chars);
        hb.completeHeader(fields, true);
        hb.flush(10000L);
        String response = new String(endp.getOut().asArray(), "UTF-8");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK\r\nContent-Length: 1025\r\n\r\n\u05531234567890"));
    }

    @Test
    public void testUTF16x2() throws Exception {
        this._writer.setCharacterEncoding("UTF-8");
        String source = "\ud842\udf9f";
        byte[] bytes = source.getBytes("UTF-8");
        this._writer.write(source.toCharArray(), 0, source.toCharArray().length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        osw.write(source.toCharArray(), 0, source.toCharArray().length);
        osw.flush();
        this.myReportBytes(bytes);
        this.myReportBytes(baos.toByteArray());
        this.myReportBytes(this._bytes.asArray());
        this.assertArrayEquals(bytes, this._bytes.asArray());
        this.assertArrayEquals(baos.toByteArray(), this._bytes.asArray());
    }

    @Test
    public void testMultiByteOverflowUTF16x2() throws Exception {
        int i;
        this._writer.setCharacterEncoding("UTF-8");
        String singleByteStr = "a";
        int remainSize = 1;
        String multiByteDuplicateStr = "\ud842\udf9f";
        int adjustSize = -1;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 512 + adjustSize; ++i) {
            sb.append("a");
        }
        sb.append("\ud842\udf9f");
        for (i = 0; i < remainSize; ++i) {
            sb.append("a");
        }
        String source = sb.toString();
        byte[] bytes = source.getBytes("UTF-8");
        this._writer.write(source.toCharArray(), 0, source.toCharArray().length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        osw.write(source.toCharArray(), 0, source.toCharArray().length);
        osw.flush();
        this.myReportBytes(bytes);
        this.myReportBytes(baos.toByteArray());
        this.myReportBytes(this._bytes.asArray());
        this.assertArrayEquals(bytes, this._bytes.asArray());
        this.assertArrayEquals(baos.toByteArray(), this._bytes.asArray());
    }

    @Test
    public void testMultiByteOverflowUTF16x2_2() throws Exception {
        int i;
        this._writer.setCharacterEncoding("UTF-8");
        String singleByteStr = "a";
        int remainSize = 1;
        String multiByteDuplicateStr = "\ud842\udf9f";
        int adjustSize = -2;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 512 + adjustSize; ++i) {
            sb.append("a");
        }
        sb.append("\ud842\udf9f");
        for (i = 0; i < remainSize; ++i) {
            sb.append("a");
        }
        String source = sb.toString();
        byte[] bytes = source.getBytes("UTF-8");
        this._writer.write(source.toCharArray(), 0, source.toCharArray().length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        osw.write(source.toCharArray(), 0, source.toCharArray().length);
        osw.flush();
        this.myReportBytes(bytes);
        this.myReportBytes(baos.toByteArray());
        this.myReportBytes(this._bytes.asArray());
        this.assertArrayEquals(bytes, this._bytes.asArray());
        this.assertArrayEquals(baos.toByteArray(), this._bytes.asArray());
    }

    private void myReportBytes(byte[] bytes) throws Exception {
        for (int i = 0; i < bytes.length; ++i) {
        }
    }

    private void assertArrayEquals(byte[] b1, byte[] b2) {
        String test = new String(b1) + "==" + new String(b2);
        Assert.assertEquals((String)test, (long)b1.length, (long)b2.length);
        for (int i = 0; i < b1.length; ++i) {
            Assert.assertEquals((String)test, (long)b1[i], (long)b2[i]);
        }
    }
}

