/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiPartInputStream;
import org.eclipse.jetty.util.log.Log;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequestTest {
    private Server _server;
    private LocalConnector _connector;
    private RequestHandler _handler;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector();
        this._connector.setRequestHeaderSize(512);
        this._connector.setRequestBufferSize(1024);
        this._connector.setResponseHeaderSize(512);
        this._connector.setResponseBufferSize(2048);
        this._connector.setForwarded(true);
        this._server.addConnector((Connector)this._connector);
        this._handler = new RequestHandler();
        this._server.setHandler((Handler)this._handler);
        this._server.start();
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                Map map = null;
                try {
                    request.getParameterMap();
                    junit.framework.Assert.fail((String)"Expected parsing failure");
                    return false;
                }
                catch (Exception e) {
                    map = request.getParameterMap();
                    System.err.println(map);
                    Assert.assertFalse((map == null ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)map.isEmpty());
                    Enumeration names = request.getParameterNames();
                    Assert.assertFalse((boolean)names.hasMoreElements());
                    return true;
                }
            }
        };
        String request = "GET /?param=%ZZaaa HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\n\n";
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testMultiPartNoConfig() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    Part foo = request.getPart("stuff");
                    return false;
                }
                catch (IllegalStateException e) {
                    Assert.assertTrue((boolean)e.getMessage().startsWith("No multipart config"));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\n" + "\r\n" + multipart;
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testMultiPart() throws Exception {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        final File testTmpDir = new File(tmpDir, "reqtest");
        testTmpDir.deleteOnExit();
        Assert.assertTrue((boolean)testTmpDir.mkdirs());
        Assert.assertTrue((testTmpDir.list().length == 0 ? 1 : 0) != 0);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new MultiPartRequestHandler(testTmpDir));
        contextHandler.addEventListener((EventListener)new Request.MultiPartCleanerListener(){

            public void requestDestroyed(ServletRequestEvent sre) {
                MultiPartInputStream m = (MultiPartInputStream)sre.getServletRequest().getAttribute("org.eclipse.multiPartInputStream");
                ContextHandler.Context c = (ContextHandler.Context)sre.getServletRequest().getAttribute("org.eclipse.multiPartContext");
                Assert.assertNotNull((Object)m);
                Assert.assertNotNull((Object)c);
                Assert.assertTrue((c == sre.getServletContext() ? 1 : 0) != 0);
                Assert.assertTrue((!m.getParsedParts().isEmpty() ? 1 : 0) != 0);
                Assert.assertTrue((testTmpDir.list().length == 2 ? 1 : 0) != 0);
                super.requestDestroyed(sre);
                String[] files = testTmpDir.list();
                Assert.assertTrue((files.length == 0 ? 1 : 0) != 0);
            }
        });
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        this._server.start();
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"foo.upload\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\n" + "\r\n" + multipart;
        String responses = this._connector.getResponses(request);
        System.err.println(responses);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testBadUtf8ParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                String value = request.getParameter("param");
                return value.startsWith("aaa") && value.endsWith("bb");
            }
        };
        String request = "GET /?param=aaa%E7bbb HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\n\n";
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testInvalidHostHeader() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.addVirtualHosts(new String[1]);
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: whatever.com:\r\nContent-Type: text/html;charset=utf8\n\n";
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((String)"400 Bad Request response expected", (boolean)responses.startsWith("HTTP/1.1 400"));
    }

    @Test
    public void testContentTypeEncoding() throws Exception {
        final ArrayList results = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                results.add(request.getContentType());
                results.add(request.getCharacterEncoding());
                return true;
            }
        };
        this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nContent-Type: text/test\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html;charset=utf8\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html; charset=\"utf8\"\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html; other=foo ; blah=\"charset=wrong;\" ; charset =   \" x=z; \"   ; more=values \n\n");
        int i = 0;
        Assert.assertEquals((Object)"text/test", results.get(i++));
        Assert.assertEquals(null, results.get(i++));
        Assert.assertEquals((Object)"text/html;charset=utf8", results.get(i++));
        Assert.assertEquals((Object)"utf8", results.get(i++));
        Assert.assertEquals((Object)"text/html; charset=\"utf8\"", results.get(i++));
        Assert.assertEquals((Object)"utf8", results.get(i++));
        Assert.assertTrue((boolean)((String)results.get(i++)).startsWith("text/html"));
        Assert.assertEquals((Object)" x=z; ", results.get(i++));
    }

    @Test
    public void testHostPort() throws Exception {
        final ArrayList results = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                results.add(request.getRemoteAddr());
                results.add(request.getServerName());
                results.add(String.valueOf(request.getServerPort()));
                return true;
            }
        };
        this._connector.getResponses("GET / HTTP/1.1\nHost: myhost\n\nGET / HTTP/1.1\nHost: myhost:8888\n\nGET / HTTP/1.1\nHost: 1.2.3.4\n\nGET / HTTP/1.1\nHost: 1.2.3.4:8888\n\nGET / HTTP/1.1\nHost: [::1]\n\nGET / HTTP/1.1\nHost: [::1]:8888\n\nGET / HTTP/1.1\nHost: [::1]\nx-forwarded-for: remote\nx-forwarded-proto: https\n\nGET / HTTP/1.1\nHost: [::1]:8888\nx-forwarded-for: remote\nx-forwarded-proto: https\n\n");
        int i = 0;
        Assert.assertEquals(null, results.get(i++));
        Assert.assertEquals((Object)"myhost", results.get(i++));
        Assert.assertEquals((Object)"80", results.get(i++));
        Assert.assertEquals(null, results.get(i++));
        Assert.assertEquals((Object)"myhost", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
        Assert.assertEquals(null, results.get(i++));
        Assert.assertEquals((Object)"1.2.3.4", results.get(i++));
        Assert.assertEquals((Object)"80", results.get(i++));
        Assert.assertEquals(null, results.get(i++));
        Assert.assertEquals((Object)"1.2.3.4", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
        Assert.assertEquals(null, results.get(i++));
        Assert.assertEquals((Object)"[::1]", results.get(i++));
        Assert.assertEquals((Object)"80", results.get(i++));
        Assert.assertEquals(null, results.get(i++));
        Assert.assertEquals((Object)"[::1]", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
        Assert.assertEquals((Object)"remote", results.get(i++));
        Assert.assertEquals((Object)"[::1]", results.get(i++));
        Assert.assertEquals((Object)"443", results.get(i++));
        Assert.assertEquals((Object)"remote", results.get(i++));
        Assert.assertEquals((Object)"[::1]", results.get(i++));
        Assert.assertEquals((Object)"8888", results.get(i++));
    }

    @Test
    public void testContent() throws Exception {
        final int[] length = new int[1];
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                Assert.assertEquals((long)request.getContentLength(), (long)((Request)request).getContentRead());
                length[0] = request.getContentLength();
                return true;
            }
        };
        String content = "";
        for (int l = 0; l < 1025; ++l) {
            String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/test\r\nContent-Length: " + l + "\r\n" + "Connection: close\r\n" + "\r\n" + content;
            String response = this._connector.getResponses(request);
            Assert.assertEquals((long)l, (long)length[0]);
            if (l > 0) {
                Assert.assertEquals((long)l, (long)this._handler._content.length());
            }
            content = content + "x";
        }
    }

    @Test
    public void testPartialRead() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                BufferedReader reader = request.getReader();
                byte[] b = ("read=" + ((Reader)reader).read() + "\n").getBytes("UTF-8");
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\n\r\n0123456789\r\nGET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\nConnection: close\r\n\r\nABCDEFGHIJ\r\n";
        String responses = this._connector.getResponses(request);
        int index = responses.indexOf("read=48");
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
        index = responses.indexOf("read=65", index + 7);
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryAfterRead() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                BufferedReader reader = request.getReader();
                String in = IO.toString((Reader)reader);
                String param = request.getParameter("param");
                byte[] b = ("read='" + in + "' param=" + param + "\n").getBytes("UTF-8");
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "POST /?param=right HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: 11\r\nConnection: close\r\n\r\nparam=wrong\r\n";
        String responses = this._connector.getResponses(request);
        Assert.assertTrue((responses.indexOf("read='param=wrong' param=right") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPartialInput() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                ServletInputStream in = request.getInputStream();
                byte[] b = ("read=" + in.read() + "\n").getBytes("UTF-8");
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\n\r\n0123456789\r\nGET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\nConnection: close\r\n\r\nABCDEFGHIJ\r\n";
        String responses = this._connector.getResponses(request);
        int index = responses.indexOf("read=48");
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
        index = responses.indexOf("read=65", index + 7);
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConnectionClose() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nConnection: Other, close\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.0\nHost: whatever\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertFalse((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.0\nHost: whatever\nConnection: Other, close\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.0\nHost: whatever\nConnection: Other,,keep-alive\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: keep-alive") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.setHeader("Connection", "TE");
                response.addHeader("Connection", "Other");
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: TE,Other") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("Hello World") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCookies() throws Exception {
        final ArrayList cookies = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                Cookie[] ca = request.getCookies();
                if (ca != null) {
                    cookies.addAll(Arrays.asList(ca));
                }
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        cookies.clear();
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)0L, (long)cookies.size());
        cookies.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nCookie: name=quoted=\\\"value\\\"\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"quoted=\\\"value\\\"", (Object)((Cookie)cookies.get(0)).getValue());
        cookies.clear();
        response = this._connector.getResponses("GET / HTTP/1.1\nHost: whatever\nCookie: name=value; other=\"quoted=;value\"\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)2L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        cookies.clear();
        response = this._connector.getResponses("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\nGET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)4L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        Assert.assertSame(cookies.get(0), cookies.get(2));
        Assert.assertSame(cookies.get(1), cookies.get(3));
        cookies.clear();
        response = this._connector.getResponses("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\nGET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"othervalue\"\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)4L, (long)cookies.size());
        Assert.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        Assert.assertNotSame(cookies.get(0), cookies.get(2));
        Assert.assertNotSame(cookies.get(1), cookies.get(3));
        cookies.clear();
        response = this._connector.getResponses("POST / HTTP/1.1\r\nHost: whatever\r\nCookie: name0=value0; name1 = value1 ; \"name2\"  =  \"\\\"value2\\\"\"  \nCookie: $Version=2; name3=value3=value3;$path=/path;$domain=acme.com;$port=8080; name4=; name5 =  ; name6\nCookie: name7=value7;\nConnection: close\r\n\r\n");
        Assert.assertEquals((Object)"name0", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"value0", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"name1", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals((Object)"value1", (Object)((Cookie)cookies.get(1)).getValue());
        Assert.assertEquals((Object)"name2", (Object)((Cookie)cookies.get(2)).getName());
        Assert.assertEquals((Object)"\"value2\"", (Object)((Cookie)cookies.get(2)).getValue());
        Assert.assertEquals((Object)"name3", (Object)((Cookie)cookies.get(3)).getName());
        Assert.assertEquals((Object)"value3=value3", (Object)((Cookie)cookies.get(3)).getValue());
        Assert.assertEquals((long)2L, (long)((Cookie)cookies.get(3)).getVersion());
        Assert.assertEquals((Object)"/path", (Object)((Cookie)cookies.get(3)).getPath());
        Assert.assertEquals((Object)"acme.com", (Object)((Cookie)cookies.get(3)).getDomain());
        Assert.assertEquals((Object)"$port=8080", (Object)((Cookie)cookies.get(3)).getComment());
        Assert.assertEquals((Object)"name4", (Object)((Cookie)cookies.get(4)).getName());
        Assert.assertEquals((Object)"", (Object)((Cookie)cookies.get(4)).getValue());
        Assert.assertEquals((Object)"name5", (Object)((Cookie)cookies.get(5)).getName());
        Assert.assertEquals((Object)"", (Object)((Cookie)cookies.get(5)).getValue());
        Assert.assertEquals((Object)"name6", (Object)((Cookie)cookies.get(6)).getName());
        Assert.assertEquals((Object)"", (Object)((Cookie)cookies.get(6)).getValue());
        Assert.assertEquals((Object)"name7", (Object)((Cookie)cookies.get(7)).getName());
        Assert.assertEquals((Object)"value7", (Object)((Cookie)cookies.get(7)).getValue());
        cookies.clear();
        response = this._connector.getResponses("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: __utmz=14316.133020.1.1.utr=gna.de|ucn=(real)|utd=reral|utct=/games/hen-one,gnt-50-ba-keys:key,2072262.html\n\n");
        Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"__utmz", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"14316.133020.1.1.utr=gna.de|ucn=(real)|utd=reral|utct=/games/hen-one,gnt-50-ba-keys:key,2072262.html", (Object)((Cookie)cookies.get(0)).getValue());
    }

    @Test
    public void testCookieLeak() throws Exception {
        final String[] cookie = new String[10];
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                for (int i = 0; i < cookie.length; ++i) {
                    cookie[i] = null;
                }
                Cookie[] cookies = request.getCookies();
                for (int i = 0; cookies != null && i < cookies.length; ++i) {
                    cookie[i] = cookies[i].getValue();
                }
                return true;
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: other=cookie\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nConnection: close\r\n\r\n";
        this._connector.getResponses(request);
        Assert.assertEquals((Object)"value", (Object)cookie[0]);
        Assert.assertEquals(null, (Object)cookie[1]);
        request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie:\r\nConnection: close\r\n\r\n";
        this._connector.getResponses(request);
        Assert.assertEquals(null, (Object)cookie[0]);
        Assert.assertEquals(null, (Object)cookie[1]);
        request = "POST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nCookie: other=cookie\r\n\r\nPOST / HTTP/1.1\r\nHost: whatever\r\nCookie: name=value\r\nCookie:\r\nConnection: close\r\n\r\n";
        this._connector.getResponses(request);
        Assert.assertEquals((Object)"value", (Object)cookie[0]);
        Assert.assertEquals(null, (Object)cookie[1]);
    }

    @Test
    public void testHashDOS() throws Exception {
        this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)-1);
        this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", (Object)1000);
        File evil_keys = new File("/tmp/keys_mapping_to_zero_2m");
        if (!evil_keys.exists()) {
            Log.info((String)"testHashDOS skipped");
            return;
        }
        BufferedReader in = new BufferedReader(new FileReader(evil_keys));
        StringBuilder buf = new StringBuilder(4000000);
        String key = null;
        buf.append("a=b");
        while ((key = in.readLine()) != null) {
            buf.append("&").append(key).append("=").append("x");
        }
        buf.append("&c=d");
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                return "b".equals(request.getParameter("a")) && request.getParameter("c") == null;
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + buf.length() + "\r\n" + "Connection: close\r\n" + "\r\n" + buf;
        long start = System.currentTimeMillis();
        String response = this._connector.getResponses(request);
        Assert.assertTrue((boolean)response.contains("200 OK"));
        long now = System.currentTimeMillis();
        Assert.assertTrue((now - start < 5000L ? 1 : 0) != 0);
    }

    private class MultiPartRequestHandler
    extends AbstractHandler {
        File tmpDir;

        public MultiPartRequestHandler(File tmpDir) {
            this.tmpDir = tmpDir;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            try {
                MultipartConfigElement mpce = new MultipartConfigElement(this.tmpDir.getAbsolutePath(), -1L, -1L, 2);
                request.setAttribute("org.eclipse.multipartConfig", (Object)mpce);
                String field1 = request.getParameter("field1");
                Assert.assertNotNull((Object)field1);
                Part foo = request.getPart("stuff");
                Assert.assertNotNull((Object)foo);
                Assert.assertTrue((foo.getSize() > 0L ? 1 : 0) != 0);
                response.setStatus(200);
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("No multipart config"));
                response.setStatus(200);
            }
            catch (Exception e) {
                response.sendError(500);
            }
        }
    }

    private class RequestHandler
    extends AbstractHandler {
        private RequestTester _checker;
        private String _content;

        private RequestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            if (request.getContentLength() > 0 && !"application/x-www-form-urlencoded".equals(request.getContentType()) && !request.getContentType().startsWith("multipart/form-data")) {
                this._content = IO.toString((InputStream)request.getInputStream());
            }
            if (this._checker != null && this._checker.check(request, response)) {
                response.setStatus(200);
            } else {
                response.sendError(500);
            }
        }
    }

    static interface RequestTester {
        public boolean check(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }
}

