/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ResourceCache;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.junit.Assert;
import org.junit.Test;

public class ResourceCacheTest {
    @Test
    public void testMutlipleSources1() throws Exception {
        ResourceCollection rc = new ResourceCollection(new String[]{"../jetty-util/src/test/resources/org/eclipse/jetty/util/resource/one/", "../jetty-util/src/test/resources/org/eclipse/jetty/util/resource/two/", "../jetty-util/src/test/resources/org/eclipse/jetty/util/resource/three/"});
        Resource[] r = rc.getResources();
        MimeTypes mime = new MimeTypes();
        ResourceCache rc3 = new ResourceCache(null, (ResourceFactory)r[2], mime, false, false);
        ResourceCache rc2 = new ResourceCache(rc3, (ResourceFactory)r[1], mime, false, false);
        ResourceCache rc1 = new ResourceCache(rc2, (ResourceFactory)r[0], mime, false, false);
        Assert.assertEquals((Object)"1 - one", (Object)ResourceCacheTest.getContent(rc1, "1.txt"));
        Assert.assertEquals((Object)"2 - two", (Object)ResourceCacheTest.getContent(rc1, "2.txt"));
        Assert.assertEquals((Object)"3 - three", (Object)ResourceCacheTest.getContent(rc1, "3.txt"));
        Assert.assertEquals((Object)"1 - two", (Object)ResourceCacheTest.getContent(rc2, "1.txt"));
        Assert.assertEquals((Object)"2 - two", (Object)ResourceCacheTest.getContent(rc2, "2.txt"));
        Assert.assertEquals((Object)"3 - three", (Object)ResourceCacheTest.getContent(rc2, "3.txt"));
        Assert.assertEquals(null, (Object)ResourceCacheTest.getContent(rc3, "1.txt"));
        Assert.assertEquals((Object)"2 - three", (Object)ResourceCacheTest.getContent(rc3, "2.txt"));
        Assert.assertEquals((Object)"3 - three", (Object)ResourceCacheTest.getContent(rc3, "3.txt"));
    }

    @Test
    public void testUncacheable() throws Exception {
        ResourceCollection rc = new ResourceCollection(new String[]{"../jetty-util/src/test/resources/org/eclipse/jetty/util/resource/one/", "../jetty-util/src/test/resources/org/eclipse/jetty/util/resource/two/", "../jetty-util/src/test/resources/org/eclipse/jetty/util/resource/three/"});
        Resource[] r = rc.getResources();
        MimeTypes mime = new MimeTypes();
        ResourceCache rc3 = new ResourceCache(null, (ResourceFactory)r[2], mime, false, false);
        ResourceCache rc2 = new ResourceCache(rc3, (ResourceFactory)r[1], mime, false, false){

            public boolean isCacheable(Resource resource) {
                return super.isCacheable(resource) && resource.getName().indexOf("2.txt") < 0;
            }
        };
        ResourceCache rc1 = new ResourceCache(rc2, (ResourceFactory)r[0], mime, false, false);
        Assert.assertEquals((Object)"1 - one", (Object)ResourceCacheTest.getContent(rc1, "1.txt"));
        Assert.assertEquals((Object)"2 - two", (Object)ResourceCacheTest.getContent(rc1, "2.txt"));
        Assert.assertEquals((Object)"3 - three", (Object)ResourceCacheTest.getContent(rc1, "3.txt"));
        Assert.assertEquals((Object)"1 - two", (Object)ResourceCacheTest.getContent(rc2, "1.txt"));
        Assert.assertEquals((Object)"2 - two", (Object)ResourceCacheTest.getContent(rc2, "2.txt"));
        Assert.assertEquals((Object)"3 - three", (Object)ResourceCacheTest.getContent(rc2, "3.txt"));
        Assert.assertEquals(null, (Object)ResourceCacheTest.getContent(rc3, "1.txt"));
        Assert.assertEquals((Object)"2 - three", (Object)ResourceCacheTest.getContent(rc3, "2.txt"));
        Assert.assertEquals((Object)"3 - three", (Object)ResourceCacheTest.getContent(rc3, "3.txt"));
    }

    @Test
    public void testResourceCache() throws Exception {
        FileOutputStream out;
        File[] files = new File[10];
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = File.createTempFile("R-" + i + "-", ".txt");
            files[i].deleteOnExit();
            names[i] = files[i].getName();
            out = new FileOutputStream(files[i]);
            for (int j = 0; j < i * 10 - 1; ++j) {
                out.write(32);
            }
            out.write(10);
            out.close();
        }
        Resource directory = Resource.newResource((String)files[0].getParentFile().getAbsolutePath());
        ResourceCache cache = new ResourceCache(null, (ResourceFactory)directory, new MimeTypes(), false, false);
        cache.setMaxCacheSize(95);
        cache.setMaxCachedFileSize(85);
        cache.setMaxCachedFiles(4);
        Assert.assertTrue((cache.lookup("does not exist") == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(cache.lookup(names[9]) instanceof HttpContent.ResourceAsHttpContent));
        HttpContent content = cache.lookup(names[8]);
        Assert.assertTrue((content != null ? 1 : 0) != 0);
        Assert.assertEquals((long)80L, (long)content.getContentLength());
        Assert.assertEquals((long)80L, (long)cache.getCachedSize());
        Assert.assertEquals((long)1L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[1]);
        Assert.assertEquals((long)90L, (long)cache.getCachedSize());
        Assert.assertEquals((long)2L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[2]);
        Assert.assertEquals((long)30L, (long)cache.getCachedSize());
        Assert.assertEquals((long)2L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[3]);
        Assert.assertEquals((long)60L, (long)cache.getCachedSize());
        Assert.assertEquals((long)3L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[4]);
        Assert.assertEquals((long)90L, (long)cache.getCachedSize());
        Assert.assertEquals((long)3L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[5]);
        Assert.assertEquals((long)90L, (long)cache.getCachedSize());
        Assert.assertEquals((long)2L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[6]);
        Assert.assertEquals((long)60L, (long)cache.getCachedSize());
        Assert.assertEquals((long)1L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        out = new FileOutputStream(files[6]);
        out.write(32);
        out.close();
        content = cache.lookup(names[7]);
        Assert.assertEquals((long)70L, (long)cache.getCachedSize());
        Assert.assertEquals((long)1L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[6]);
        Assert.assertEquals((long)71L, (long)cache.getCachedSize());
        Assert.assertEquals((long)2L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[0]);
        Assert.assertEquals((long)72L, (long)cache.getCachedSize());
        Assert.assertEquals((long)3L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[1]);
        Assert.assertEquals((long)82L, (long)cache.getCachedSize());
        Assert.assertEquals((long)4L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[2]);
        Assert.assertEquals((long)32L, (long)cache.getCachedSize());
        Assert.assertEquals((long)4L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        content = cache.lookup(names[3]);
        Assert.assertEquals((long)61L, (long)cache.getCachedSize());
        Assert.assertEquals((long)4L, (long)cache.getCachedFiles());
        Thread.sleep(200L);
        cache.flushCache();
        Assert.assertEquals((long)0L, (long)cache.getCachedSize());
        Assert.assertEquals((long)0L, (long)cache.getCachedFiles());
        cache.flushCache();
    }

    static String getContent(Resource r, String path) throws Exception {
        StringBuilder buffer = new StringBuilder();
        String line = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(r.addPath(path).getURL().openStream()));
        while ((line = br.readLine()) != null) {
            buffer.append(line);
        }
        br.close();
        return buffer.toString();
    }

    static String getContent(ResourceCache rc, String path) throws Exception {
        HttpContent content = rc.lookup(path);
        if (content == null) {
            return null;
        }
        return content.getIndirectBuffer().toString();
    }
}

