/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResponseTest {
    private Server server;
    private LocalConnector connector;

    @Before
    public void init() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector();
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler((Handler)new DumpHandler());
        this.server.start();
    }

    @After
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testContentType() throws Exception {
        TestHttpConnection connection = new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer());
        Response response = connection.getResponse();
        Assert.assertEquals(null, (Object)response.getContentType());
        response.setHeader("Content-Type", "text/something");
        Assert.assertEquals((Object)"text/something", (Object)response.getContentType());
        response.setContentType("foo/bar");
        Assert.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar;charset=ISO-8859-1", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=ISO-8859-1", (Object)response.getContentType());
        response.setHeader("name", "foo");
        Iterator en = response.getHeaders("name").iterator();
        Assert.assertEquals((Object)"foo", en.next());
        Assert.assertFalse((boolean)en.hasNext());
        response.addHeader("name", "bar");
        en = response.getHeaders("name").iterator();
        Assert.assertEquals((Object)"foo", en.next());
        Assert.assertEquals((Object)"bar", en.next());
        Assert.assertFalse((boolean)en.hasNext());
        response.recycle();
        response.setContentType("text/html");
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=ISO-8859-1", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=ISO-8859-1", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/xml;charset=ISO-8859-7");
        response.getWriter();
        response.setContentType("text/html;charset=UTF-8");
        Assert.assertEquals((Object)"text/html;charset=ISO-8859-7", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/html;charset=US-ASCII");
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=US-ASCII", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/json");
        response.getWriter();
        Assert.assertEquals((Object)"text/json;charset=UTF-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar");
        Assert.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setContentType("foo/bar");
        response.setCharacterEncoding("xyz");
        Assert.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar;charset=abc");
        Assert.assertEquals((Object)"foo/bar;charset=abc", (Object)response.getContentType());
        response.recycle();
        response.setContentType("foo/bar;charset=abc");
        response.setCharacterEncoding("xyz");
        Assert.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar");
        response.setCharacterEncoding(null);
        Assert.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setCharacterEncoding(null);
        response.setContentType("foo/bar");
        Assert.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.recycle();
        response.addHeader("Content-Type", "text/something");
        Assert.assertEquals((Object)"text/something", (Object)response.getContentType());
    }

    @Test
    public void testLocale() throws Exception {
        TestHttpConnection connection = new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer());
        Request request = connection.getRequest();
        Response response = connection.getResponse();
        ContextHandler context = new ContextHandler();
        context.addLocaleEncoding(Locale.ENGLISH.toString(), "ISO-8859-1");
        context.addLocaleEncoding(Locale.ITALIAN.toString(), "ISO-8859-2");
        request.setContext(context.getServletContext());
        response.setLocale(Locale.ITALIAN);
        Assert.assertEquals(null, (Object)response.getContentType());
        response.setContentType("text/plain");
        Assert.assertEquals((Object)"text/plain;charset=ISO-8859-2", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/plain");
        response.setCharacterEncoding("utf-8");
        response.setLocale(Locale.ITALIAN);
        Assert.assertEquals((Object)"text/plain;charset=UTF-8", (Object)response.getContentType());
        Assert.assertTrue((response.toString().indexOf("charset=UTF-8") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContentTypeCharacterEncoding() throws Exception {
        TestHttpConnection connection = new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer());
        Response response = connection.getResponse();
        response.setContentType("foo/bar");
        response.setCharacterEncoding("utf-8");
        Assert.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assert.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
    }

    @Test
    public void testCharacterEncodingContentType() throws Exception {
        Response response = new Response((AbstractHttpConnection)new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer()));
        response.setCharacterEncoding("utf-8");
        response.setContentType("foo/bar");
        Assert.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar;charset=utf-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assert.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("iso-8859-1");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
    }

    @Test
    public void testContentTypeWithCharacterEncoding() throws Exception {
        Response response = new Response((AbstractHttpConnection)new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer()));
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; charset=utf-8");
        Assert.assertEquals((Object)"foo/bar; charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar; charset=utf-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assert.assertEquals((Object)"foo2/bar2;charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("text/html; charset=utf-8");
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("iso-8859-1");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
    }

    @Test
    public void testContentTypeWithOther() throws Exception {
        Response response = new Response((AbstractHttpConnection)new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer()));
        response.setContentType("foo/bar; other=xyz");
        Assert.assertEquals((Object)"foo/bar; other=xyz", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar; other=xyz;charset=ISO-8859-1", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=ISO-8859-1", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html; other=xyz");
        Assert.assertEquals((Object)"text/html; other=xyz;charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html; other=xyz;charset=utf-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
    }

    @Test
    public void testContentTypeWithCharacterEncodingAndOther() throws Exception {
        Response response = new Response((AbstractHttpConnection)new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer()));
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; charset=utf-8 other=xyz");
        Assert.assertEquals((Object)"foo/bar; charset=utf-8 other=xyz", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar; charset=utf-8 other=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("text/html; other=xyz charset=utf-8");
        Assert.assertEquals((Object)"text/html; other=xyz charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html; other=xyz charset=utf-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; other=pq charset=utf-8 other=xyz");
        Assert.assertEquals((Object)"foo/bar; other=pq charset=utf-8 other=xyz", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar; other=pq charset=utf-8 other=xyz", (Object)response.getContentType());
    }

    @Test
    public void testStatusCodes() throws Exception {
        Response response = this.newResponse();
        response.sendError(404);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals(null, (Object)response.getReason());
        response = this.newResponse();
        response.sendError(500, "Database Error");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)"Database Error", (Object)response.getReason());
        Assert.assertEquals((Object)"must-revalidate,no-cache,no-store", (Object)response.getHeader("Cache-Control"));
        response = this.newResponse();
        response.setStatus(200);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(null, (Object)response.getReason());
        response = this.newResponse();
        response.sendError(406, "Super Nanny");
        Assert.assertEquals((long)406L, (long)response.getStatus());
        Assert.assertEquals((Object)"Super Nanny", (Object)response.getReason());
        Assert.assertEquals((Object)"must-revalidate,no-cache,no-store", (Object)response.getHeader("Cache-Control"));
    }

    @Test
    public void testEncodeRedirect() throws Exception {
        TestHttpConnection connection = new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer());
        Response response = new Response((AbstractHttpConnection)connection);
        Request request = connection.getRequest();
        request.setServerName("myhost");
        request.setServerPort(8888);
        request.setContextPath("/path");
        Assert.assertEquals((Object)"http://myhost:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        request.setRequestedSessionId("12345");
        request.setRequestedSessionIdFromCookie(false);
        HashSessionManager manager = new HashSessionManager();
        manager.setSessionIdManager((SessionIdManager)new HashSessionIdManager());
        request.setSessionManager((SessionManager)manager);
        request.setSession((HttpSession)new TestSession((AbstractSessionManager)manager, "12345"));
        manager.setCheckingRemoteSessionIdEncoding(false);
        Assert.assertEquals((Object)"http://myhost:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://other:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://myhost/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://myhost:8888/other/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/other/info;param?query=0&more=1#target"));
        manager.setCheckingRemoteSessionIdEncoding(true);
        Assert.assertEquals((Object)"http://myhost:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://other:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://myhost/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://myhost:8888/other/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/other/info;param?query=0&more=1#target"));
        request.setContextPath("");
        Assert.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888"));
        Assert.assertEquals((Object)"https://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("https://myhost:8888"));
        Assert.assertEquals((Object)"mailto:/foo", (Object)response.encodeURL("mailto:/foo"));
        Assert.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888/"));
        Assert.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888/;jsessionid=7777"));
        Assert.assertEquals((Object)"http://myhost:8888/;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://other:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        manager.setCheckingRemoteSessionIdEncoding(false);
        Assert.assertEquals((Object)"/foo;jsessionid=12345", (Object)response.encodeURL("/foo"));
        Assert.assertEquals((Object)"/;jsessionid=12345", (Object)response.encodeURL("/"));
        Assert.assertEquals((Object)"/foo.html;jsessionid=12345#target", (Object)response.encodeURL("/foo.html#target"));
        Assert.assertEquals((Object)";jsessionid=12345", (Object)response.encodeURL(""));
    }

    @Test
    public void testCanonicalSendRedirect() throws Exception {
        ByteArrayEndPoint out = new ByteArrayEndPoint(new byte[0], 4096);
        TestHttpConnection connection = new TestHttpConnection((Connector)this.connector, (EndPoint)out, this.connector.getServer());
        Response response = new Response((AbstractHttpConnection)connection);
        Request request = connection.getRequest();
        request.setServerName("myhost");
        request.setServerPort(8888);
        request.setRequestURI("/path/test/info/");
        request.setContextPath("/path");
        request.setServletPath("/test");
        request.setPathInfo("/info/");
        response.sendRedirect("../other%2Fpath");
        String location = response.getHeader("Location");
        Assert.assertEquals((Object)"http://myhost:8888/path/test/other%2Fpath", (Object)location);
    }

    @Test
    public void testSendRedirect() throws Exception {
        String[][] tests = new String[][]{{"http://myhost:8888/other/location;jsessionid=12345?name=value", "http://myhost:8888/other/location;jsessionid=12345?name=value"}, {"/other/location;jsessionid=12345?name=value", "http://myhost:8888/other/location;jsessionid=12345?name=value"}, {"./location;jsessionid=12345?name=value", "http://myhost:8888/path/location;jsessionid=12345?name=value"}, {"/other/location", "http://myhost:8888/other/location"}, {"/other/l%20cation", "http://myhost:8888/other/l%20cation"}, {"location", "http://myhost:8888/path/location"}, {"./location", "http://myhost:8888/path/location"}, {"../location", "http://myhost:8888/location"}, {"/other/l%20cation", "http://myhost:8888/other/l%20cation"}, {"l%20cation", "http://myhost:8888/path/l%20cation"}, {"./l%20cation", "http://myhost:8888/path/l%20cation"}, {"../l%20cation", "http://myhost:8888/l%20cation"}, {"../locati%C3%abn", "http://myhost:8888/locati%C3%abn"}, {"../other%2fplace", "http://myhost:8888/other%2fplace"}};
        for (int i = 0; i < tests.length; ++i) {
            ByteArrayEndPoint out = new ByteArrayEndPoint(new byte[0], 4096);
            TestHttpConnection connection = new TestHttpConnection((Connector)this.connector, (EndPoint)out, this.connector.getServer());
            Response response = new Response((AbstractHttpConnection)connection);
            Request request = connection.getRequest();
            request.setServerName("myhost");
            request.setServerPort(8888);
            request.setUri(new HttpURI("/path/info;param;jsessionid=12345?query=0&more=1#target"));
            request.setContextPath("/path");
            request.setRequestedSessionId("12345");
            request.setRequestedSessionIdFromCookie(i > 2);
            HashSessionManager manager = new HashSessionManager();
            manager.setSessionIdManager((SessionIdManager)new HashSessionIdManager());
            request.setSessionManager((SessionManager)manager);
            request.setSession((HttpSession)new TestSession((AbstractSessionManager)manager, "12345"));
            manager.setCheckingRemoteSessionIdEncoding(false);
            response.sendRedirect(tests[i][0]);
            String location = out.getOut().toString();
            int l = location.indexOf("Location: ");
            int e = location.indexOf(10, l);
            location = location.substring(l + 10, e).trim();
            Assert.assertEquals((String)("test-" + i), (Object)tests[i][1], (Object)location);
        }
    }

    @Test
    public void testSetBufferSize() throws Exception {
        Response response = new Response((AbstractHttpConnection)new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer()));
        response.setBufferSize(20480);
        response.getWriter().print("hello");
        try {
            response.setBufferSize(21504);
            Assert.fail((String)"Expected IllegalStateException on Request.setBufferSize");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    @Test
    public void testZeroContent() throws Exception {
        Response response = new Response((AbstractHttpConnection)new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer()));
        PrintWriter writer = response.getWriter();
        response.setContentLength(0);
        Assert.assertTrue((!response.isCommitted() ? 1 : 0) != 0);
        Assert.assertTrue((!writer.checkError() ? 1 : 0) != 0);
        writer.print("");
        Assert.assertTrue((!writer.checkError() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isCommitted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHead() throws Exception {
        Server server = new Server();
        try {
            SocketConnector socketConnector = new SocketConnector();
            socketConnector.setPort(0);
            server.addConnector((Connector)socketConnector);
            server.setHandler((Handler)new AbstractHandler(){

                public void handle(String string, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    response.setStatus(200);
                    response.setContentType("text/plain");
                    PrintWriter w = response.getWriter();
                    w.flush();
                    w.println("Geht");
                    w.flush();
                    w.println("Doch");
                    ((Request)request).setHandled(true);
                }
            });
            server.start();
            Socket socket = new Socket("localhost", socketConnector.getLocalPort());
            socket.getOutputStream().write("HEAD / HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes());
            socket.getOutputStream().write("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n".getBytes());
            socket.getOutputStream().flush();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                line = reader.readLine();
            }
            while (line != null && line.length() == 0) {
                line = reader.readLine();
            }
            Assert.assertTrue((line != null && line.startsWith("HTTP/1.1 200 OK") ? 1 : 0) != 0);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testAddCookie() throws Exception {
        Response response = new Response((AbstractHttpConnection)new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer()));
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        String set = response.getHttpFields().getStringField("Set-Cookie");
        Assert.assertEquals((Object)"name=value;Comment=comment;Path=/path;Domain=domain;Secure;HttpOnly", (Object)set);
    }

    @Test
    public void testCookiesWithReset() throws Exception {
        Response response = new Response((AbstractHttpConnection)new TestHttpConnection((Connector)this.connector, (EndPoint)new ByteArrayEndPoint(), this.connector.getServer()));
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        Cookie cookie2 = new Cookie("name2", "value2");
        cookie2.setDomain("domain");
        cookie2.setPath("/path");
        response.addCookie(cookie2);
        response.reset(true);
        Enumeration set = response.getHttpFields().getValues("Set-Cookie");
        Assert.assertNotNull((Object)set);
        ArrayList list = Collections.list(set);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("name=value;Comment=comment;Path=/path;Domain=domain;Secure;HttpOnly"));
        Assert.assertTrue((boolean)list.contains("name2=value2;Path=/path;Domain=domain"));
        response.reset();
        set = response.getHttpFields().getValues("Set-Cookie");
        Assert.assertFalse((boolean)set.hasMoreElements());
    }

    private Response newResponse() {
        ByteArrayEndPoint endPoint = new ByteArrayEndPoint();
        endPoint.setOut(new ByteArrayBuffer(1024));
        endPoint.setGrowOutput(true);
        TestHttpConnection connection = new TestHttpConnection((Connector)this.connector, (EndPoint)endPoint, this.connector.getServer());
        connection.getGenerator().reset();
        AbstractHttpConnection.setCurrentConnection((AbstractHttpConnection)connection);
        Response response = connection.getResponse();
        connection.getRequest().setRequestURI("/test");
        return response;
    }

    static class TestHttpConnection
    extends AbstractHttpConnection {
        public TestHttpConnection(Connector connector, EndPoint endpoint, Server server) {
            super(connector, endpoint, server);
        }

        public TestHttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
            super(connector, endpoint, server, parser, generator, request);
        }

        public Connection handle() throws IOException {
            return this;
        }
    }

    private class TestSession
    extends AbstractSession {
        public TestSession(AbstractSessionManager abstractSessionManager, String id) {
            super(abstractSessionManager, System.currentTimeMillis(), System.currentTimeMillis(), id);
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public long getCreationTime() {
            return 0L;
        }

        public String getId() {
            return "12345";
        }

        public long getLastAccessedTime() {
            return 0L;
        }

        public int getMaxInactiveInterval() {
            return 0;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public HttpSessionContext getSessionContext() {
            return null;
        }

        public Object getValue(String name) {
            return null;
        }

        public String[] getValueNames() {
            return null;
        }

        public void invalidate() {
        }

        public boolean isNew() {
            return false;
        }

        public void putValue(String name, Object value) {
        }

        public void removeAttribute(String name) {
        }

        public void removeValue(String name) {
        }

        public void setAttribute(String name, Object value) {
        }

        public void setMaxInactiveInterval(int interval) {
        }

        protected Map newAttributeMap() {
            return null;
        }
    }
}

