/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.LocalAsyncContextTest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.IO;
import org.junit.Test;

public class SelectChannelAsyncContextTest
extends LocalAsyncContextTest {
    volatile SelectChannelEndPoint _endp;

    @Override
    protected Connector initConnector() {
        return new SelectChannelConnector(){

            public void customize(EndPoint endpoint, Request request) throws IOException {
                super.customize(endpoint, request);
                SelectChannelAsyncContextTest.this._endp = (SelectChannelEndPoint)endpoint;
            }
        };
    }

    @Override
    protected String getResponse(String request) throws Exception {
        SelectChannelConnector connector = (SelectChannelConnector)this._connector;
        Socket socket = new Socket((String)null, connector.getLocalPort());
        socket.getOutputStream().write(request.getBytes("UTF-8"));
        return IO.toString((InputStream)socket.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuspendResumeWithAsyncDispatch() throws Exception {
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (running.get()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                        SelectChannelEndPoint endp = SelectChannelAsyncContextTest.this._endp;
                        if (endp == null || !endp.isOpen()) continue;
                        endp.asyncDispatch();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            thread.start();
            this.testSuspendResume();
        }
        finally {
            running.set(false);
            thread.join();
        }
    }
}

