/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Locale;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ConnectorTimeoutTest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.SuspendHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.IO;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SelectChannelTimeoutTest
extends ConnectorTimeoutTest {
    @BeforeClass
    public static void init() throws Exception {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setMaxIdleTime(250);
        SelectChannelTimeoutTest.startServer((Connector)connector);
    }

    @Test
    public void testIdleTimeoutAfterSuspend() throws Exception {
        SuspendHandler _handler = new SuspendHandler();
        _server.stop();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)_handler);
        _server.setHandler((Handler)session);
        _server.start();
        _handler.setSuspendFor(100L);
        _handler.setResumeAfter(25L);
        Assert.assertTrue((boolean)this.process(null).toUpperCase(Locale.ENGLISH).contains("RESUMED"));
    }

    @Test
    public void testIdleTimeoutAfterTimeout() throws Exception {
        SuspendHandler _handler = new SuspendHandler();
        _server.stop();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)_handler);
        _server.setHandler((Handler)session);
        _server.start();
        _handler.setSuspendFor(50L);
        Assert.assertTrue((boolean)this.process(null).toUpperCase(Locale.ENGLISH).contains("TIMEOUT"));
    }

    @Test
    public void testIdleTimeoutAfterComplete() throws Exception {
        SuspendHandler _handler = new SuspendHandler();
        _server.stop();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)_handler);
        _server.setHandler((Handler)session);
        _server.start();
        _handler.setSuspendFor(100L);
        _handler.setCompleteAfter(25L);
        Assert.assertTrue((boolean)this.process(null).toUpperCase(Locale.ENGLISH).contains("COMPLETED"));
    }

    private synchronized String process(String content) throws UnsupportedEncodingException, IOException, InterruptedException {
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n";
        request = content == null ? request + "\r\n" : request + "Content-Length: " + content.length() + "\r\n" + "\r\n" + content;
        return this.getResponse(request);
    }

    private String getResponse(String request) throws UnsupportedEncodingException, IOException, InterruptedException {
        SelectChannelConnector connector = (SelectChannelConnector)_connector;
        Socket socket = new Socket((String)null, connector.getLocalPort());
        socket.setSoTimeout(2500);
        socket.getOutputStream().write(request.getBytes("UTF-8"));
        InputStream inputStream = socket.getInputStream();
        long start = System.currentTimeMillis();
        String response = IO.toString((InputStream)inputStream);
        long timeElapsed = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"Time elapsed should be at least MAX_IDLE_TIME", (timeElapsed > 250L ? 1 : 0) != 0);
        return response;
    }
}

