/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.AsyncHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SlowClientWithPipelinedRequestTest {
    private final AtomicInteger handles = new AtomicInteger();
    private Server server;
    private SelectChannelConnector connector;

    public void startServer(Handler handler) throws Exception {
        this.server = new Server();
        this.connector = new SelectChannelConnector(){

            protected AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint) {
                return new AsyncHttpConnection((Connector)this, (EndPoint)endpoint, this.getServer()){

                    public Connection handle() throws IOException {
                        SlowClientWithPipelinedRequestTest.this.handles.incrementAndGet();
                        return super.handle();
                    }
                };
            }
        };
        this.server.addConnector((Connector)this.connector);
        this.connector.setPort(0);
        this.server.setHandler(handler);
        this.server.start();
    }

    @After
    public void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.join();
        }
    }

    @Test
    public void testSlowClientWithPipelinedRequest() throws Exception {
        int contentLength = 524288;
        this.startServer((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                System.err.println("target = " + target);
                if ("/content".equals(target)) {
                    ServletOutputStream outputStream = response.getOutputStream();
                    AbstractHttpConnection.Output output = (AbstractHttpConnection.Output)outputStream;
                    byte[] bytes = new byte[524288];
                    Arrays.fill(bytes, (byte)57);
                    ByteArrayBuffer buffer = new ByteArrayBuffer(bytes);
                    output.sendContent((Object)buffer);
                }
            }
        });
        Socket client = new Socket("localhost", this.connector.getLocalPort());
        OutputStream output = client.getOutputStream();
        output.write(("GET /content HTTP/1.1\r\nHost: localhost:" + this.connector.getLocalPort() + "\r\n" + "\r\n" + "").getBytes("UTF-8"));
        output.flush();
        InputStream input = client.getInputStream();
        int read = input.read();
        Assert.assertTrue((read >= 0 ? 1 : 0) != 0);
        output.write(("GET /pipelined HTTP/1.1\r\nHost: localhost:" + this.connector.getLocalPort() + "\r\n" + "\r\n" + "").getBytes("UTF-8"));
        output.flush();
        Thread.sleep(1000L);
        Assert.assertThat((Object)this.handles.get(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(10)));
        StringBuilder lines = new StringBuilder().append((char)read);
        int crlfs = 0;
        do {
            read = input.read();
            lines.append((char)read);
            if (read == 13 || read == 10) {
                ++crlfs;
                continue;
            }
            crlfs = 0;
        } while (crlfs != 4);
        Assert.assertTrue((boolean)lines.toString().contains(" 200 "));
        for (int i = 0; i < 524288; ++i) {
            input.read();
        }
        lines.setLength(0);
        crlfs = 0;
        do {
            read = input.read();
            lines.append((char)read);
            if (read == 13 || read == 10) {
                ++crlfs;
                continue;
            }
            crlfs = 0;
        } while (crlfs != 4);
        Assert.assertTrue((boolean)lines.toString().contains(" 200 "));
        client.close();
    }
}

