/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ConnectHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.junit.After;
import org.junit.Assert;

public abstract class AbstractConnectHandlerTest {
    protected Server server;
    protected Connector serverConnector;
    protected Server proxy;
    protected Connector proxyConnector;

    protected void startServer(Connector connector, Handler handler) throws Exception {
        this.server = new Server();
        this.serverConnector = connector;
        this.server.addConnector(this.serverConnector);
        this.server.setHandler(handler);
        this.server.start();
    }

    protected void startProxy() throws Exception {
        this.startProxy((Connector)new SelectChannelConnector(), new ConnectHandler());
    }

    protected void startProxy(Connector connector, ConnectHandler connectHandler) throws Exception {
        this.proxy = new Server();
        this.proxyConnector = connector;
        this.proxy.addConnector(this.proxyConnector);
        this.proxy.setHandler((Handler)connectHandler);
        this.proxy.start();
    }

    @After
    public void stop() throws Exception {
        this.stopProxy();
        this.stopServer();
    }

    protected void stopServer() throws Exception {
        this.server.stop();
        this.server.join();
    }

    protected void stopProxy() throws Exception {
        this.proxy.stop();
        this.proxy.join();
    }

    protected Response readResponse(BufferedReader reader) throws IOException {
        StringBuilder body;
        String line = reader.readLine();
        if (line == null) {
            throw new EOFException();
        }
        Matcher responseLine = Pattern.compile("HTTP/1\\.1\\s+(\\d+)").matcher(line);
        Assert.assertTrue((boolean)responseLine.lookingAt());
        String code = responseLine.group(1);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        while ((line = reader.readLine()) != null && line.trim().length() != 0) {
            Matcher header = Pattern.compile("([^:]+):\\s*(.*)").matcher(line);
            Assert.assertTrue((boolean)header.lookingAt());
            String headerName = header.group(1);
            String headerValue = header.group(2);
            headers.put(headerName.toLowerCase(Locale.ENGLISH), headerValue.toLowerCase(Locale.ENGLISH));
        }
        if (headers.containsKey("content-length")) {
            int readLen = 0;
            int length = Integer.parseInt((String)headers.get("content-length"));
            body = new StringBuilder(length);
            try {
                for (int i = 0; i < length; ++i) {
                    char c = (char)reader.read();
                    body.append(c);
                    ++readLen;
                }
            }
            catch (SocketTimeoutException e) {
                System.err.printf("Read %,d bytes (out of an expected %,d bytes)%n", readLen, length);
                throw e;
            }
        }
        if ("chunked".equals(headers.get("transfer-encoding"))) {
            body = new StringBuilder(65536);
            while ((line = reader.readLine()) != null) {
                if ("0".equals(line)) {
                    line = reader.readLine();
                    Assert.assertEquals((Object)"", (Object)line);
                    break;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int length = Integer.parseInt(line, 16);
                for (int i = 0; i < length; ++i) {
                    char c = (char)reader.read();
                    body.append(c);
                }
                line = reader.readLine();
                Assert.assertEquals((Object)"", (Object)line);
            }
        } else {
            throw new IllegalStateException();
        }
        return new Response(code, headers, body.toString().trim());
    }

    protected Socket newSocket() throws IOException {
        Socket socket = new Socket("localhost", this.proxyConnector.getLocalPort());
        socket.setSoTimeout(10000);
        return socket;
    }

    protected class Response {
        private final String code;
        private final Map<String, String> headers;
        private final String body;

        private Response(String code, Map<String, String> headers, String body) {
            this.code = code;
            this.headers = headers;
            this.body = body;
        }

        public String getCode() {
            return this.code;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.code).append("\r\n");
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.append(entry.getKey()).append(": ").append(entry.getValue()).append("\r\n");
            }
            builder.append("\r\n");
            builder.append(this.body);
            return builder.toString();
        }
    }
}

