/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractConnectHandlerTest;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ConnectHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectHandlerSSLTest
extends AbstractConnectHandlerTest {
    @Before
    public void init() throws Exception {
        this.startServer((Connector)this.prepareServerConnector(), (Handler)new ServerHandler());
        this.startProxy();
    }

    private SslSelectChannelConnector prepareServerConnector() {
        SslSelectChannelConnector connector = new SslSelectChannelConnector();
        String keyStorePath = MavenTestingUtils.getTestResourceFile((String)"keystore").getAbsolutePath();
        SslContextFactory cf = connector.getSslContextFactory();
        cf.setKeyStorePath(keyStorePath);
        cf.setKeyStorePassword("storepwd");
        cf.setKeyManagerPassword("keypwd");
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGETRequest() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            System.err.println(response);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertFalse((boolean)input.ready());
            SSLSocket sslSocket = this.wrapSocket(socket);
            try {
                output = sslSocket.getOutputStream();
                input = new BufferedReader(new InputStreamReader(sslSocket.getInputStream()));
                request = "GET /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
                output.write(request.getBytes("UTF-8"));
                output.flush();
                response = this.readResponse(input);
                Assert.assertEquals((Object)"200", (Object)response.getCode());
                Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
            }
            finally {
                sslSocket.close();
            }
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPOSTRequests() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertFalse((boolean)input.ready());
            SSLSocket sslSocket = this.wrapSocket(socket);
            try {
                output = sslSocket.getOutputStream();
                input = new BufferedReader(new InputStreamReader(sslSocket.getInputStream()));
                for (int i = 0; i < 10; ++i) {
                    request = "POST /echo?param=" + i + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "Content-Length: 5\r\n" + "\r\n" + "HELLO";
                    output.write(request.getBytes("UTF-8"));
                    output.flush();
                    response = this.readResponse(input);
                    Assert.assertEquals((Object)"200", (Object)response.getCode());
                    Assert.assertEquals((Object)("POST /echo?param=" + i + "\r\nHELLO"), (Object)response.getBody());
                }
            }
            finally {
                sslSocket.close();
            }
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerHalfClosesClientDoesNotCloseExpectIdleTimeout() throws Exception {
        this.stop();
        String uri = "/echo";
        int idleTimeout = 2000;
        this.startServer((Connector)this.prepareServerConnector(), (Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                String requestURI = request.getRequestURI();
                if ("/echo".equals(requestURI)) {
                    baseRequest.setHandled(true);
                    response.setHeader("Connection", "close");
                    response.setContentLength("/echo".length());
                    response.getOutputStream().print("/echo");
                }
            }
        });
        SelectChannelConnector proxyConnector = new SelectChannelConnector();
        proxyConnector.setMaxIdleTime(idleTimeout);
        final AtomicReference proxyToClientEndPoint = new AtomicReference();
        final AtomicReference proxyToServerEndPoint = new AtomicReference();
        ConnectHandler connectHandler = new ConnectHandler(){

            protected ConnectHandler.ClientToProxyConnection newClientToProxyConnection(ConcurrentMap<String, Object> context, SocketChannel channel, EndPoint endPoint, long timeStamp) {
                proxyToClientEndPoint.set(endPoint);
                return new ConnectHandler.ClientToProxyConnection((ConnectHandler)this, context, channel, endPoint, timeStamp);
            }

            protected ConnectHandler.ProxyToServerConnection newProxyToServerConnection(ConcurrentMap<String, Object> context, Buffer buffer) {
                return new ConnectHandler.ProxyToServerConnection(context, buffer){

                    public void setEndPoint(AsyncEndPoint endpoint) {
                        proxyToServerEndPoint.set(endpoint);
                        super.setEndPoint(endpoint);
                    }
                };
            }
        };
        connectHandler.setWriteTimeout(2 * idleTimeout);
        this.startProxy((Connector)proxyConnector, connectHandler);
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            System.err.println(response);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertFalse((boolean)input.ready());
            SSLSocket sslSocket = this.wrapSocket(socket);
            try {
                output = sslSocket.getOutputStream();
                input = new BufferedReader(new InputStreamReader(sslSocket.getInputStream()));
                request = "GET /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
                output.write(request.getBytes("UTF-8"));
                output.flush();
                response = this.readResponse(input);
                Assert.assertEquals((Object)"200", (Object)response.getCode());
                Assert.assertEquals((Object)"/echo", (Object)response.getBody());
                Thread.sleep(4 * idleTimeout);
                EndPoint p2c = (EndPoint)proxyToClientEndPoint.get();
                Assert.assertNotNull((Object)p2c);
                Assert.assertFalse((boolean)p2c.isOpen());
                EndPoint p2s = (EndPoint)proxyToServerEndPoint.get();
                Assert.assertNotNull((Object)p2s);
                Assert.assertFalse((boolean)p2s.isOpen());
            }
            finally {
                sslSocket.close();
            }
        }
        finally {
            socket.close();
        }
    }

    private SSLSocket wrapSocket(Socket socket) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSLv3");
        sslContext.init(null, new TrustManager[]{new AlwaysTrustManager()}, new SecureRandom());
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sslSocket.setUseClientMode(true);
        sslSocket.startHandshake();
        return sslSocket;
    }

    private static class ServerHandler
    extends AbstractHandler {
        private ServerHandler() {
        }

        public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            ByteArrayOutputStream baos;
            StringBuilder builder;
            request.setHandled(true);
            String uri = httpRequest.getRequestURI();
            if ("/echo".equals(uri)) {
                int read;
                builder = new StringBuilder();
                builder.append(httpRequest.getMethod()).append(" ").append(uri);
                if (httpRequest.getQueryString() != null) {
                    builder.append("?").append(httpRequest.getQueryString());
                }
                baos = new ByteArrayOutputStream();
                ServletInputStream input = httpRequest.getInputStream();
                while ((read = input.read()) >= 0) {
                    baos.write(read);
                }
            } else {
                throw new ServletException();
            }
            baos.close();
            ServletOutputStream output = httpResponse.getOutputStream();
            output.println(builder.toString());
            output.write(baos.toByteArray());
        }
    }

    private class AlwaysTrustManager
    implements X509TrustManager {
        private AlwaysTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

