/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractConnectHandlerTest;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ConnectHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.toolchain.test.OS;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ConnectHandlerTest
extends AbstractConnectHandlerTest {
    @Before
    public void init() throws Exception {
        this.startServer((Connector)new SelectChannelConnector(), (Handler)new ServerHandler());
        this.startProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECT() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndGET() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        socket.setSoTimeout(30000);
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            request = "GET /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTBadHostPort() throws Exception {
        String invalidHostname = "AMAZEBALLS_BADHOST.webtide.com";
        try {
            InetAddress addr = InetAddress.getByName(invalidHostname);
            StringBuilder err = new StringBuilder();
            err.append("DNS Hijacking detected: ");
            err.append(invalidHostname).append(" should have not returned a valid IP address [");
            err.append(addr.getHostAddress()).append("].  ");
            err.append("Fix your DNS provider to have this test pass.");
            err.append("\nFor more info see https://en.wikipedia.org/wiki/DNS_hijacking");
            Assert.assertNull((String)err.toString(), (Object)addr);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        String hostPort = String.format("%s:%d", invalidHostname, this.serverConnector.getLocalPort());
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        socket.setSoTimeout(30000);
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((String)"Response Code", (Object)"500", (Object)response.getCode());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECT10AndGET() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.0\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            request = "GET /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndGETPipelined() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n" + "GET /echo" + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndMultipleGETs() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            for (int i = 0; i < 10; ++i) {
                request = "GET /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
                output.write(request.getBytes("UTF-8"));
                output.flush();
                response = this.readResponse(input);
                Assert.assertEquals((Object)"200", (Object)response.getCode());
                Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
            }
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndGETServerStop() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            request = "GET /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
            this.stopServer();
            int read = input.read();
            Assert.assertEquals((long)-1L, (long)read);
        }
        finally {
            socket.close();
            this.server.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndGETAndServerSideClose() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            request = "GET /close HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            int read = input.read();
            Assert.assertEquals((long)-1L, (long)read);
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndPOSTAndGET() throws Exception {
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            request = "POST /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "Content-Length: 5\r\n" + "\r\n" + "HELLO";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)"POST /echo\r\nHELLO", (Object)response.getBody());
            request = "GET /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndPOSTWithBigBody() throws Exception {
        boolean stress = Boolean.getBoolean("STRESS");
        if (!stress) {
            return;
        }
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            StringBuilder body = new StringBuilder();
            String chunk = "0123456789ABCDEF";
            for (int i = 0; i < 0x100000; ++i) {
                body.append(chunk);
            }
            request = "POST /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "Content-Length: " + body.length() + "\r\n" + "\r\n" + body;
            output.write(request.getBytes("UTF-8"));
            output.flush();
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)("POST /echo\r\n" + body), (Object)response.getBody());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndPOSTWithContext() throws Exception {
        String contextKey = "contextKey";
        String contextValue = "contextValue";
        this.stopProxy();
        this.proxy.setHandler((Handler)new ConnectHandler(){

            protected boolean handleAuthentication(HttpServletRequest request, HttpServletResponse response, String address) throws ServletException, IOException {
                request.setAttribute("contextKey", (Object)"contextValue");
                return super.handleAuthentication(request, response, address);
            }

            protected SocketChannel connect(HttpServletRequest request, String host, int port) throws IOException {
                Assert.assertEquals((Object)"contextValue", (Object)request.getAttribute("contextKey"));
                return super.connect(request, host, port);
            }

            protected void prepareContext(HttpServletRequest request, ConcurrentMap<String, Object> context) {
                Assert.assertEquals((Object)"contextValue", (Object)request.getAttribute("contextKey"));
                context.put("contextKey", request.getAttribute("contextKey"));
            }

            protected int read(EndPoint endPoint, Buffer buffer, ConcurrentMap<String, Object> context) throws IOException {
                Assert.assertEquals((Object)"contextValue", context.get("contextKey"));
                return super.read(endPoint, buffer, context);
            }

            protected int write(EndPoint endPoint, Buffer buffer, ConcurrentMap<String, Object> context) throws IOException {
                Assert.assertEquals((Object)"contextValue", context.get("contextKey"));
                return super.write(endPoint, buffer, context);
            }
        });
        this.proxy.start();
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            String body = "0123456789ABCDEF";
            request = "POST /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "Content-Length: " + body.length() + "\r\n" + "\r\n" + body;
            output.write(request.getBytes("UTF-8"));
            output.flush();
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)("POST /echo\r\n" + body), (Object)response.getBody());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndGETPipelinedAndOutputShutdown() throws Exception {
        Assume.assumeTrue((!OS.IS_OSX ? 1 : 0) != 0);
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n" + "GET /echo" + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            socket.shutdownOutput();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCONNECTAndGETAndOutputShutdown() throws Exception {
        Assume.assumeTrue((!OS.IS_OSX ? 1 : 0) != 0);
        String hostPort = "localhost:" + this.serverConnector.getLocalPort();
        String request = "CONNECT " + hostPort + " HTTP/1.1\r\n" + "Host: " + hostPort + "\r\n" + "\r\n";
        Socket socket = this.newSocket();
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            AbstractConnectHandlerTest.Response response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            request = "GET /echo HTTP/1.1\r\nHost: " + hostPort + "\r\n" + "\r\n";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            socket.shutdownOutput();
            response = this.readResponse(input);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            Assert.assertEquals((Object)"GET /echo", (Object)response.getBody());
        }
        finally {
            socket.close();
        }
    }

    private static class ServerHandler
    extends AbstractHandler {
        private ServerHandler() {
        }

        public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            request.setHandled(true);
            String uri = httpRequest.getRequestURI();
            if ("/echo".equals(uri)) {
                int read;
                StringBuilder builder = new StringBuilder();
                builder.append(httpRequest.getMethod()).append(" ").append(uri);
                if (httpRequest.getQueryString() != null) {
                    builder.append("?").append(httpRequest.getQueryString());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ServletInputStream input = httpRequest.getInputStream();
                while ((read = input.read()) >= 0) {
                    baos.write(read);
                }
                baos.close();
                ServletOutputStream output = httpResponse.getOutputStream();
                output.println(builder.toString());
                output.write(baos.toByteArray());
            } else if ("/close".equals(uri)) {
                request.getConnection().getEndPoint().close();
            } else {
                throw new ServletException();
            }
        }
    }
}

