/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.handler.ConnectHandler;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectHandlerUnitTest {
    @Mock
    private EndPoint endPoint;

    @Test
    public void testPartialWritesWithNonFullBuffer() throws IOException {
        ConnectHandler connectHandler = new ConnectHandler();
        final byte[] bytes = "foo bar".getBytes();
        ByteArrayBuffer buffer = new ByteArrayBuffer(bytes.length * 2);
        buffer.put(bytes);
        Mockito.when((Object)this.endPoint.flush((Buffer)buffer)).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                Buffer buffer = (Buffer)args[0];
                int skip = bytes.length / 2;
                buffer.skip(skip);
                return skip;
            }
        });
        Mockito.when((Object)this.endPoint.blockWritable((long)Matchers.anyInt())).thenReturn((Object)true);
        connectHandler.write(this.endPoint, (Buffer)buffer, null);
        Assert.assertThat((Object)buffer.length(), (Matcher)org.hamcrest.Matchers.is((Object)0));
    }
}

