/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.junit.Assert;
import org.junit.Test;

public class ContextHandlerCollectionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostNormalization() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector();
        server.setConnectors(new Connector[]{connector});
        ContextHandler contextA = new ContextHandler("/");
        contextA.setVirtualHosts(new String[]{"www.example.com"});
        IsHandledHandler handlerA = new IsHandledHandler();
        contextA.setHandler((Handler)handlerA);
        ContextHandler contextB = new ContextHandler("/");
        IsHandledHandler handlerB = new IsHandledHandler();
        contextB.setHandler((Handler)handlerB);
        contextB.setVirtualHosts(new String[]{"www.example2.com."});
        ContextHandler contextC = new ContextHandler("/");
        IsHandledHandler handlerC = new IsHandledHandler();
        contextC.setHandler((Handler)handlerC);
        ContextHandlerCollection c = new ContextHandlerCollection();
        c.addHandler((Handler)contextA);
        c.addHandler((Handler)contextB);
        c.addHandler((Handler)contextC);
        server.setHandler((Handler)c);
        try {
            server.start();
            connector.getResponses("GET / HTTP/1.1\nHost: www.example.com.\n\n");
            Assert.assertTrue((boolean)handlerA.isHandled());
            Assert.assertFalse((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            connector.getResponses("GET / HTTP/1.1\nHost: www.example2.com\n\n");
            Assert.assertFalse((boolean)handlerA.isHandled());
            Assert.assertTrue((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostWildcard() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector();
        server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler("/");
        IsHandledHandler handler = new IsHandledHandler();
        context.setHandler((Handler)handler);
        ContextHandlerCollection c = new ContextHandlerCollection();
        c.addHandler((Handler)context);
        server.setHandler((Handler)c);
        try {
            server.start();
            this.checkWildcardHost(true, server, null, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{null}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"example.com", "*.example.com"}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.com", "*.example.com"}, new String[]{"badexample.com", ".badexample.com", "vhost.badexample.com"});
            this.checkWildcardHost(false, server, new String[]{"*."}, new String[]{"anything.anything"});
            this.checkWildcardHost(true, server, new String[]{"*.example.com"}, new String[]{"vhost.example.com", ".example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.example.com"}, new String[]{"vhost.www.example.com", "example.com", "www.vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"*.sub.example.com"}, new String[]{"vhost.sub.example.com", ".sub.example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.sub.example.com"}, new String[]{".example.com", "sub.example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.*.com", "example.com.*"}, new String[]{"example.vhost.com", "example.com.vhost", "example.com"});
        }
        finally {
            server.stop();
        }
    }

    private void checkWildcardHost(boolean succeed, Server server, String[] contextHosts, String[] requestHosts) throws Exception {
        LocalConnector connector = (LocalConnector)server.getConnectors()[0];
        ContextHandlerCollection handlerCollection = (ContextHandlerCollection)server.getHandler();
        ContextHandler context = (ContextHandler)handlerCollection.getHandlers()[0];
        IsHandledHandler handler = (IsHandledHandler)context.getHandler();
        context.setVirtualHosts(contextHosts);
        handlerCollection.mapContexts();
        for (String host : requestHosts) {
            connector.getResponses("GET / HTTP/1.1\nHost: " + host + "\n\n");
            if (succeed) {
                Assert.assertTrue((String)("'" + host + "' should have been handled."), (boolean)handler.isHandled());
            } else {
                Assert.assertFalse((String)("'" + host + "' should not have been handled."), (boolean)handler.isHandled());
            }
            handler.reset();
        }
    }

    @Test
    public void testFindContainer() throws Exception {
        Server server = new Server();
        ContextHandler contextA = new ContextHandler("/a");
        IsHandledHandler handlerA = new IsHandledHandler();
        contextA.setHandler((Handler)handlerA);
        ContextHandler contextB = new ContextHandler("/b");
        IsHandledHandler handlerB = new IsHandledHandler();
        HandlerWrapper wrapperB = new HandlerWrapper();
        wrapperB.setHandler((Handler)handlerB);
        contextB.setHandler((Handler)wrapperB);
        ContextHandler contextC = new ContextHandler("/c");
        IsHandledHandler handlerC = new IsHandledHandler();
        contextC.setHandler((Handler)handlerC);
        ContextHandlerCollection collection = new ContextHandlerCollection();
        collection.addHandler((Handler)contextA);
        collection.addHandler((Handler)contextB);
        collection.addHandler((Handler)contextC);
        HandlerWrapper wrapper = new HandlerWrapper();
        wrapper.setHandler((Handler)collection);
        server.setHandler((Handler)wrapper);
        Assert.assertEquals((Object)wrapper, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)server, HandlerWrapper.class, (Handler)handlerA));
        Assert.assertEquals((Object)contextA, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)server, ContextHandler.class, (Handler)handlerA));
        Assert.assertEquals((Object)contextB, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)server, ContextHandler.class, (Handler)handlerB));
        Assert.assertEquals((Object)wrapper, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)server, HandlerWrapper.class, (Handler)handlerB));
        Assert.assertEquals((Object)contextB, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)collection, HandlerWrapper.class, (Handler)handlerB));
        Assert.assertEquals((Object)wrapperB, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)contextB, HandlerWrapper.class, (Handler)handlerB));
    }

    private static final class IsHandledHandler
    extends AbstractHandler {
        private boolean handled;

        private IsHandledHandler() {
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            this.handled = true;
        }

        public void reset() {
            this.handled = false;
        }
    }
}

