/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class ContextHandlerTest {
    @Test
    public void testGetResourcePathsWhenSuppliedPathEndsInSlash() throws Exception {
        this.checkResourcePathsForExampleWebApp("/WEB-INF/");
    }

    @Test
    public void testGetResourcePathsWhenSuppliedPathDoesNotEndInSlash() throws Exception {
        this.checkResourcePathsForExampleWebApp("/WEB-INF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostNormalization() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector();
        server.setConnectors(new Connector[]{connector});
        ContextHandler contextA = new ContextHandler("/");
        contextA.setVirtualHosts(new String[]{"www.example.com"});
        IsHandledHandler handlerA = new IsHandledHandler();
        contextA.setHandler((Handler)handlerA);
        ContextHandler contextB = new ContextHandler("/");
        IsHandledHandler handlerB = new IsHandledHandler();
        contextB.setHandler((Handler)handlerB);
        contextB.setVirtualHosts(new String[]{"www.example2.com."});
        ContextHandler contextC = new ContextHandler("/");
        IsHandledHandler handlerC = new IsHandledHandler();
        contextC.setHandler((Handler)handlerC);
        HandlerCollection c = new HandlerCollection();
        c.addHandler((Handler)contextA);
        c.addHandler((Handler)contextB);
        c.addHandler((Handler)contextC);
        server.setHandler((Handler)c);
        try {
            server.start();
            connector.getResponses("GET / HTTP/1.1\nHost: www.example.com.\n\n");
            Assert.assertTrue((boolean)handlerA.isHandled());
            Assert.assertFalse((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            connector.getResponses("GET / HTTP/1.1\nHost: www.example2.com\n\n");
            Assert.assertFalse((boolean)handlerA.isHandled());
            Assert.assertTrue((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testContextGetContext() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector();
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler rootA = new ContextHandler((HandlerContainer)contexts, "/");
        ContextHandler fooA = new ContextHandler((HandlerContainer)contexts, "/foo");
        ContextHandler foobarA = new ContextHandler((HandlerContainer)contexts, "/foo/bar");
        server.start();
        junit.framework.Assert.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/"));
        junit.framework.Assert.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo"));
        junit.framework.Assert.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar"));
        junit.framework.Assert.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar/bob.jsp"));
        junit.framework.Assert.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/other"));
        junit.framework.Assert.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo/other"));
        junit.framework.Assert.assertEquals((Object)rootA._scontext, (Object)foobarA._scontext.getContext("/"));
        junit.framework.Assert.assertEquals((Object)fooA._scontext, (Object)foobarA._scontext.getContext("/foo"));
        junit.framework.Assert.assertEquals((Object)foobarA._scontext, (Object)foobarA._scontext.getContext("/foo/bar"));
        junit.framework.Assert.assertEquals((Object)foobarA._scontext, (Object)foobarA._scontext.getContext("/foo/bar/bob.jsp"));
        junit.framework.Assert.assertEquals((Object)rootA._scontext, (Object)foobarA._scontext.getContext("/other"));
        junit.framework.Assert.assertEquals((Object)fooA._scontext, (Object)foobarA._scontext.getContext("/foo/other"));
    }

    @Test
    public void testContextVirtualGetContext() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector();
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler rootA = new ContextHandler((HandlerContainer)contexts, "/");
        rootA.setVirtualHosts(new String[]{"a.com"});
        ContextHandler rootB = new ContextHandler((HandlerContainer)contexts, "/");
        rootB.setVirtualHosts(new String[]{"b.com"});
        ContextHandler rootC = new ContextHandler((HandlerContainer)contexts, "/");
        rootC.setVirtualHosts(new String[]{"c.com"});
        ContextHandler fooA = new ContextHandler((HandlerContainer)contexts, "/foo");
        fooA.setVirtualHosts(new String[]{"a.com"});
        ContextHandler fooB = new ContextHandler((HandlerContainer)contexts, "/foo");
        fooB.setVirtualHosts(new String[]{"b.com"});
        ContextHandler foobarA = new ContextHandler((HandlerContainer)contexts, "/foo/bar");
        foobarA.setVirtualHosts(new String[]{"a.com"});
        server.start();
        junit.framework.Assert.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/"));
        junit.framework.Assert.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo"));
        junit.framework.Assert.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar"));
        junit.framework.Assert.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar/bob"));
        junit.framework.Assert.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/other"));
        junit.framework.Assert.assertEquals((Object)rootB._scontext, (Object)rootB._scontext.getContext("/other"));
        junit.framework.Assert.assertEquals((Object)rootC._scontext, (Object)rootC._scontext.getContext("/other"));
        junit.framework.Assert.assertEquals((Object)fooB._scontext, (Object)rootB._scontext.getContext("/foo/other"));
        junit.framework.Assert.assertEquals((Object)rootC._scontext, (Object)rootC._scontext.getContext("/foo/other"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostWildcard() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector();
        server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler("/");
        IsHandledHandler handler = new IsHandledHandler();
        context.setHandler((Handler)handler);
        server.setHandler((Handler)context);
        try {
            server.start();
            this.checkWildcardHost(true, server, null, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{null}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"example.com", "*.example.com"}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.com", "*.example.com"}, new String[]{"badexample.com", ".badexample.com", "vhost.badexample.com"});
            this.checkWildcardHost(false, server, new String[]{"*."}, new String[]{"anything.anything"});
            this.checkWildcardHost(true, server, new String[]{"*.example.com"}, new String[]{"vhost.example.com", ".example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.example.com"}, new String[]{"vhost.www.example.com", "example.com", "www.vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"*.sub.example.com"}, new String[]{"vhost.sub.example.com", ".sub.example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.sub.example.com"}, new String[]{".example.com", "sub.example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.*.com", "example.com.*"}, new String[]{"example.vhost.com", "example.com.vhost", "example.com"});
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testVirtualHostManagement() throws Exception {
        ContextHandler context = new ContextHandler("/");
        context.setVirtualHosts(new String[]{"www.example.com"});
        junit.framework.Assert.assertEquals((int)1, (int)context.getVirtualHosts().length);
        context.addVirtualHosts(new String[]{"www.example2.com", "www.example3.com"});
        junit.framework.Assert.assertEquals((int)3, (int)context.getVirtualHosts().length);
        context.addVirtualHosts(new String[]{"www.example.com"});
        junit.framework.Assert.assertEquals((int)3, (int)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"www.example3.com"});
        junit.framework.Assert.assertEquals((int)2, (int)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"www.example3.com"});
        junit.framework.Assert.assertEquals((int)2, (int)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"www.example.com", "www.example2.com"});
        junit.framework.Assert.assertEquals(null, (Object)context.getVirtualHosts());
    }

    @Test
    public void testAttributes() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.setAttribute("aaa", (Object)"111");
        Assert.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assert.assertEquals(null, (Object)handler.getAttribute("bbb"));
        handler.start();
        handler.getServletContext().setAttribute("aaa", (Object)"000");
        handler.setAttribute("ccc", (Object)"333");
        handler.getServletContext().setAttribute("ddd", (Object)"444");
        Assert.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assert.assertEquals(null, (Object)handler.getServletContext().getAttribute("bbb"));
        handler.getServletContext().setAttribute("bbb", (Object)"222");
        Assert.assertEquals((Object)"333", (Object)handler.getServletContext().getAttribute("ccc"));
        Assert.assertEquals((Object)"444", (Object)handler.getServletContext().getAttribute("ddd"));
        Assert.assertEquals((Object)"111", (Object)handler.getAttribute("aaa"));
        Assert.assertEquals(null, (Object)handler.getAttribute("bbb"));
        Assert.assertEquals((Object)"333", (Object)handler.getAttribute("ccc"));
        Assert.assertEquals(null, (Object)handler.getAttribute("ddd"));
        handler.stop();
        Assert.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assert.assertEquals(null, (Object)handler.getServletContext().getAttribute("bbb"));
        Assert.assertEquals((Object)"333", (Object)handler.getServletContext().getAttribute("ccc"));
        Assert.assertEquals(null, (Object)handler.getServletContext().getAttribute("ddd"));
    }

    @Test
    public void testProtected() throws Exception {
        ContextHandler handler = new ContextHandler();
        String[] protectedTargets = new String[]{"/foo-inf", "/bar-inf"};
        handler.setProtectedTargets(protectedTargets);
        Assert.assertTrue((boolean)handler.isProtectedTarget("/foo-inf/x/y/z"));
        Assert.assertFalse((boolean)handler.isProtectedTarget("/foo/x/y/z"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("/foo-inf?x=y&z=1"));
        protectedTargets = new String[4];
        System.arraycopy(handler.getProtectedTargets(), 0, protectedTargets, 0, 2);
        protectedTargets[2] = "/abc";
        protectedTargets[3] = "/def";
        handler.setProtectedTargets(protectedTargets);
        Assert.assertTrue((boolean)handler.isProtectedTarget("/foo-inf/x/y/z"));
        Assert.assertFalse((boolean)handler.isProtectedTarget("/foo/x/y/z"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("/foo-inf?x=y&z=1"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("/abc/124"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("//def"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("/ABC/7777"));
    }

    private void checkResourcePathsForExampleWebApp(String root) throws IOException {
        File testDirectory = this.setupTestDirectory();
        ContextHandler handler = new ContextHandler();
        Assert.assertTrue((String)("Not a directory " + testDirectory), (boolean)testDirectory.isDirectory());
        handler.setBaseResource(Resource.newResource((URL)Resource.toURL((File)testDirectory)));
        ArrayList paths = new ArrayList(handler.getResourcePaths(root));
        Assert.assertEquals((long)2L, (long)paths.size());
        Collections.sort(paths);
        Assert.assertEquals((Object)"/WEB-INF/jsp/", paths.get(0));
        Assert.assertEquals((Object)"/WEB-INF/web.xml", paths.get(1));
    }

    private File setupTestDirectory() throws IOException {
        File tmpDir = new File(System.getProperty("basedir") + "/target/tmp/ContextHandlerTest");
        if (!tmpDir.exists()) {
            Assert.assertTrue((boolean)tmpDir.mkdirs());
        }
        File tmp = File.createTempFile("cht", null, tmpDir);
        Assert.assertTrue((boolean)tmp.delete());
        Assert.assertTrue((boolean)tmp.mkdir());
        tmp.deleteOnExit();
        File root = new File(tmp, this.getClass().getName());
        Assert.assertTrue((boolean)root.mkdir());
        File webInf = new File(root, "WEB-INF");
        Assert.assertTrue((boolean)webInf.mkdir());
        Assert.assertTrue((boolean)new File(webInf, "jsp").mkdir());
        Assert.assertTrue((boolean)new File(webInf, "web.xml").createNewFile());
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUncheckedPrintWriter() throws Exception {
        Server server = new Server();
        server.setUncheckedPrintWriter(true);
        LocalConnector connector = new LocalConnector();
        server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler("/");
        WriterHandler handler = new WriterHandler();
        context.setHandler((Handler)handler);
        server.setHandler((Handler)context);
        try {
            server.start();
            String response = connector.getResponses("GET / HTTP/1.1\nHost: www.example.com.\n\n");
            junit.framework.Assert.assertTrue((response.indexOf("Goodbye") > 0 ? 1 : 0) != 0);
            junit.framework.Assert.assertTrue((response.indexOf("dead") < 0 ? 1 : 0) != 0);
            junit.framework.Assert.assertTrue((boolean)handler.error);
            junit.framework.Assert.assertTrue((handler.throwable != null ? 1 : 0) != 0);
        }
        finally {
            server.stop();
        }
    }

    private void checkWildcardHost(boolean succeed, Server server, String[] contextHosts, String[] requestHosts) throws Exception {
        LocalConnector connector = (LocalConnector)server.getConnectors()[0];
        ContextHandler context = (ContextHandler)server.getHandler();
        context.setVirtualHosts(contextHosts);
        IsHandledHandler handler = (IsHandledHandler)context.getHandler();
        for (String host : requestHosts) {
            connector.getResponses("GET / HTTP/1.1\nHost: " + host + "\n\n");
            if (succeed) {
                Assert.assertTrue((String)("'" + host + "' should have been handled."), (boolean)handler.isHandled());
            } else {
                Assert.assertFalse((String)("'" + host + "' should not have been handled."), (boolean)handler.isHandled());
            }
            handler.reset();
        }
    }

    private static final class WriterHandler
    extends AbstractHandler {
        boolean error;
        Throwable throwable;

        private WriterHandler() {
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            this.error = false;
            this.throwable = null;
            response.setStatus(200);
            response.setContentType("text/plain; charset=utf-8");
            response.setHeader("Connection", "close");
            PrintWriter writer = response.getWriter();
            try {
                writer.write("Goodbye cruel world\n");
                writer.close();
                response.flushBuffer();
                writer.write("give the printwriter a chance");
                if (writer.checkError()) {
                    writer.write("didn't take the chance, will throw now");
                }
            }
            catch (Throwable th) {
                this.throwable = th;
            }
            this.error = writer.checkError();
        }
    }

    private static final class IsHandledHandler
    extends AbstractHandler {
        private boolean handled;

        private IsHandledHandler() {
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            this.handled = true;
        }

        public void reset() {
            this.handled = false;
        }
    }
}

