/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.IPAccessHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IPAccessHandlerTest {
    private static Server _server;
    private static Connector _connector;
    private static IPAccessHandler _handler;
    private String _white;
    private String _black;
    private String _host;
    private String _uri;
    private String _code;

    @BeforeClass
    public static void setUp() throws Exception {
        _server = new Server();
        _connector = new SocketConnector();
        _server.setConnectors(new Connector[]{_connector});
        _handler = new IPAccessHandler();
        _handler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
            }
        });
        _server.setHandler((Handler)_handler);
        _server.start();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        _server.stop();
    }

    public IPAccessHandlerTest(String white, String black, String host, String uri, String code) {
        this._white = white;
        this._black = black;
        this._host = host;
        this._uri = uri;
        this._code = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandler() throws Exception {
        _handler.setWhite(this._white.split(";", -1));
        _handler.setBlack(this._black.split(";", -1));
        String request = "GET " + this._uri + " HTTP/1.1\n" + "Host: " + this._host + "\n\n";
        Socket socket = new Socket("127.0.0.1", _connector.getLocalPort());
        socket.setSoTimeout(5000);
        try {
            OutputStream output = socket.getOutputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes("UTF-8"));
            output.flush();
            Response response = this.readResponse(input);
            Assert.assertEquals((Object)this._code, (Object)response.getCode());
        }
        finally {
            socket.close();
        }
    }

    protected Response readResponse(BufferedReader reader) throws IOException {
        StringBuilder body;
        LinkedHashMap<String, String> headers;
        String code;
        block6: {
            String line;
            block7: {
                line = reader.readLine();
                if (line == null) {
                    throw new EOFException();
                }
                Matcher responseLine = Pattern.compile("HTTP/1\\.1\\s+(\\d+)").matcher(line);
                Assert.assertTrue((boolean)responseLine.lookingAt());
                code = responseLine.group(1);
                headers = new LinkedHashMap<String, String>();
                while ((line = reader.readLine()) != null && line.trim().length() != 0) {
                    Matcher header = Pattern.compile("([^:]+):\\s*(.*)").matcher(line);
                    Assert.assertTrue((boolean)header.lookingAt());
                    String headerName = header.group(1);
                    String headerValue = header.group(2);
                    headers.put(headerName.toLowerCase(Locale.ENGLISH), headerValue.toLowerCase(Locale.ENGLISH));
                }
                body = new StringBuilder();
                if (!headers.containsKey("content-length")) break block7;
                int length = Integer.parseInt((String)headers.get("content-length"));
                for (int i = 0; i < length; ++i) {
                    char c = (char)reader.read();
                    body.append(c);
                }
                break block6;
            }
            if (!"chunked".equals(headers.get("transfer-encoding"))) break block6;
            while ((line = reader.readLine()) != null) {
                if ("0".equals(line)) {
                    line = reader.readLine();
                    Assert.assertEquals((Object)"", (Object)line);
                    break;
                }
                int length = Integer.parseInt(line, 16);
                for (int i = 0; i < length; ++i) {
                    char c = (char)reader.read();
                    body.append(c);
                }
                line = reader.readLine();
                Assert.assertEquals((Object)"", (Object)line);
            }
        }
        return new Response(code, headers, body.toString().trim());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"", "", "127.0.0.1", "/", "200"}, {"", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1", "", "127.0.0.1", "/", "200"}, {"127.0.0.1", "", "127.0.0.1", "/dispatch", "200"}, {"127.0.0.1", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/", "", "127.0.0.1", "/", "200"}, {"127.0.0.1|/", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.1|/", "", "127.0.0.1", "/dump/info", "403"}, {"127.0.0.1|/*", "", "127.0.0.1", "/", "200"}, {"127.0.0.1|/*", "", "127.0.0.1", "/dispatch", "200"}, {"127.0.0.1|/*", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/", "403"}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dump/test", "200"}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/", "403"}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dump/test", "403"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/", "403"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/test", "200"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/fail", "403"}, {"127.0.0.0-2|", "", "127.0.0.1", "/", "200"}, {"127.0.0.0-2|", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.0-2|/", "", "127.0.0.1", "/", "200"}, {"127.0.0.0-2|/", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.0-2|/", "", "127.0.0.1", "/dump/info", "403"}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/", "403"}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/", "403"}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dump/test", "403"}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/", "403"}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/test", "200"}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/fail", "403"}, {"", "127.0.0.1", "127.0.0.1", "/", "403"}, {"", "127.0.0.1", "127.0.0.1", "/dispatch", "403"}, {"", "127.0.0.1", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.1|/", "127.0.0.1", "/", "403"}, {"", "127.0.0.1|/", "127.0.0.1", "/dispatch", "200"}, {"", "127.0.0.1|/", "127.0.0.1", "/dump/info", "200"}, {"", "127.0.0.1|/*", "127.0.0.1", "/", "403"}, {"", "127.0.0.1|/*", "127.0.0.1", "/dispatch", "403"}, {"", "127.0.0.1|/*", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/", "200"}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dispatch", "200"}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dump/test", "403"}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/", "200"}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dispatch", "200"}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dump/test", "200"}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/", "200"}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dispatch", "200"}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/test", "403"}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/fail", "200"}, {"", "127.0.0.0-2|", "127.0.0.1", "/", "403"}, {"", "127.0.0.0-2|", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.0-2|/", "127.0.0.1", "/", "403"}, {"", "127.0.0.0-2|/", "127.0.0.1", "/dispatch", "200"}, {"", "127.0.0.0-2|/", "127.0.0.1", "/dump/info", "200"}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/", "200"}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/dispatch", "200"}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/", "200"}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dispatch", "200"}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dump/test", "200"}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/", "200"}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dispatch", "200"}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/info", "403"}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/test", "403"}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/fail", "200"}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200"}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "403"}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403"}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200"}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403"}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200"}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/test", "403"}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump", "403"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/test", "403"}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/fail", "403"}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/", "200"}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/dump/fail", "403"}, {"127.0.0.2", "", "127.0.0.1", "/", "403"}, {"127.0.0.2", "", "127.0.0.1", "/dump/info", "403"}, {"127.0.0.2|/dump/*", "", "127.0.0.1", "/", "403"}, {"127.0.0.2|/dump/*", "", "127.0.0.1", "/dump/info", "403"}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/", "403"}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/dump/info", "403"}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/dump/test", "403"}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/", "403"}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dispatch", "403"}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/info", "200"}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/test", "403"}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/fail", "403"}, {"172.0.0.0-255", "", "127.0.0.1", "/", "403"}, {"172.0.0.0-255", "", "127.0.0.1", "/dump/info", "403"}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/", "403"}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/dispatch", "403"}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/dump/info", "200"}};
        return Arrays.asList(data);
    }

    protected class Response {
        private final String code;
        private final Map<String, String> headers;
        private final String body;

        private Response(String code, Map<String, String> headers, String body) {
            this.code = code;
            this.headers = headers;
            this.body = body;
        }

        public String getCode() {
            return this.code;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.code).append("\r\n");
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.append(entry.getKey()).append(": ").append(entry.getValue()).append("\r\n");
            }
            builder.append("\r\n");
            builder.append(this.body);
            return builder.toString();
        }
    }
}

