/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.net.URI;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.SimpleRequest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResourceHandlerTest
extends TestCase {
    private static Server _server;
    private static Connector _connector;
    private static ContextHandler _contextHandler;
    private static ResourceHandler _resourceHandler;

    @BeforeClass
    public void setUp() throws Exception {
        _server = new Server();
        _connector = new SocketConnector();
        _server.setConnectors(new Connector[]{_connector});
        _resourceHandler = new ResourceHandler();
        _contextHandler = new ContextHandler("/resource");
        _contextHandler.setHandler((Handler)_resourceHandler);
        _server.setHandler((Handler)_contextHandler);
        _server.start();
    }

    @AfterClass
    public void tearDown() throws Exception {
        _server.stop();
    }

    @Test
    public void testSimpleResourceHandler() throws Exception {
        _resourceHandler.setResourceBase(MavenTestingUtils.getTestResourceDir((String)"simple").getAbsolutePath());
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        Assert.assertEquals((String)"simple text", (String)sr.getString("/resource/simple.txt"));
        Assert.assertNotNull((String)"missing jetty.css", (Object)sr.getString("/resource/jetty-dir.css"));
    }
}

