/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatisticsHandlerTest {
    private Server _server;
    private LocalConnector _connector;
    private LatchHandler _latchHandler;
    private StatisticsHandler _statsHandler;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector();
        this._server.addConnector((Connector)this._connector);
        this._connector.setStatsOn(true);
        this._latchHandler = new LatchHandler();
        this._statsHandler = new StatisticsHandler();
        this._server.setHandler((Handler)this._latchHandler);
        this._latchHandler.setHandler((Handler)this._statsHandler);
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testRequest() throws Exception {
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    barrier[1].await();
                }
                catch (Exception x) {
                    Thread.currentThread().interrupt();
                    throw (IOException)new IOException().initCause(x);
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._connector.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        boolean passed = this._latchHandler.await(1000L);
        Assert.assertTrue((boolean)passed);
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActiveMax());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getSuspends());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getResumes());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResponses2xx());
        this._latchHandler.reset();
        barrier[0].reset();
        barrier[1].reset();
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)2L, (long)this._connector.getConnectionsOpen());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        passed = this._latchHandler.await(1000L);
        Assert.assertTrue((boolean)passed);
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActiveMax());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getSuspends());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getResumes());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getResponses2xx());
        this._latchHandler.reset(2);
        barrier[0] = new CyclicBarrier(3);
        barrier[1] = new CyclicBarrier(3);
        this._connector.executeRequest(request);
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)4L, (long)this._connector.getConnectionsOpen());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        passed = this._latchHandler.await(1000L);
        Assert.assertTrue((boolean)passed);
        Assert.assertEquals((long)4L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatchedActiveMax());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getSuspends());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getResumes());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getResponses2xx());
    }

    @Test
    public void testSuspendResume() throws Exception {
        final AtomicReference continuationHandle = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)httpRequest);
                    if (continuationHandle.get() == null) {
                        continuation.suspend();
                        continuationHandle.set(continuation);
                    }
                }
                catch (Exception x) {
                    Thread.currentThread().interrupt();
                    throw (IOException)new IOException().initCause(x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        Thread.currentThread().interrupt();
                        Assert.fail();
                    }
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._connector.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await(1000L));
        Assert.assertNotNull(continuationHandle.get());
        Assert.assertTrue((boolean)((Continuation)continuationHandle.get()).isSuspended());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Thread.sleep(10L);
        this._latchHandler.reset();
        barrier[0].reset();
        barrier[1].reset();
        ((Continuation)continuationHandle.get()).addContinuationListener(new ContinuationListener(){

            public void onTimeout(Continuation continuation) {
            }

            public void onComplete(Continuation continuation) {
                try {
                    barrier[2].await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ((Continuation)continuationHandle.get()).resume();
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._connector.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await(1000L));
        barrier[2].await();
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getSuspends());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResumes());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResponses2xx());
        Assert.assertTrue((this._statsHandler.getRequestTimeTotal() >= 30L ? 1 : 0) != 0);
        Assert.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assert.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeTotal() >= 20L ? 1 : 0) != 0);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeMean() + 10.0 <= (double)this._statsHandler.getDispatchedTimeTotal() ? 1 : 0) != 0);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeMax() + 10L <= this._statsHandler.getDispatchedTimeTotal() ? 1 : 0) != 0);
    }

    @Test
    public void testSuspendExpire() throws Exception {
        final AtomicReference continuationHandle = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)httpRequest);
                    if (continuationHandle.get() == null) {
                        continuation.setTimeout(100L);
                        continuation.suspend();
                        continuationHandle.set(continuation);
                    }
                }
                catch (Exception x) {
                    Thread.currentThread().interrupt();
                    throw (IOException)new IOException().initCause(x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        Thread.currentThread().interrupt();
                        Assert.fail();
                    }
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._connector.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await(1000L));
        Assert.assertNotNull(continuationHandle.get());
        Assert.assertTrue((boolean)((Continuation)continuationHandle.get()).isSuspended());
        ((Continuation)continuationHandle.get()).addContinuationListener(new ContinuationListener(){

            public void onTimeout(Continuation continuation) {
            }

            public void onComplete(Continuation continuation) {
                try {
                    barrier[2].await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        this._latchHandler.reset();
        barrier[0].reset();
        barrier[1].reset();
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await(1000L));
        barrier[2].await();
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getSuspends());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResumes());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResponses2xx());
        Assert.assertTrue((this._statsHandler.getRequestTimeTotal() >= 30L ? 1 : 0) != 0);
        Assert.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assert.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeTotal() >= 20L ? 1 : 0) != 0);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeMean() + 10.0 <= (double)this._statsHandler.getDispatchedTimeTotal() ? 1 : 0) != 0);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeMax() + 10L <= this._statsHandler.getDispatchedTimeTotal() ? 1 : 0) != 0);
    }

    @Test
    public void testSuspendComplete() throws Exception {
        final AtomicReference continuationHandle = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)httpRequest);
                    if (continuationHandle.get() == null) {
                        continuation.setTimeout(1000L);
                        continuation.suspend();
                        continuationHandle.set(continuation);
                    }
                }
                catch (Exception x) {
                    Thread.currentThread().interrupt();
                    throw (IOException)new IOException().initCause(x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        Thread.currentThread().interrupt();
                        Assert.fail();
                    }
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._connector.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await(1000L));
        Assert.assertNotNull(continuationHandle.get());
        Assert.assertTrue((boolean)((Continuation)continuationHandle.get()).isSuspended());
        ((Continuation)continuationHandle.get()).addContinuationListener(new ContinuationListener(){

            public void onTimeout(Continuation continuation) {
            }

            public void onComplete(Continuation continuation) {
                try {
                    barrier[2].await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Thread.sleep(10L);
        ((Continuation)continuationHandle.get()).complete();
        barrier[2].await();
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getSuspends());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getResumes());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResponses2xx());
        Assert.assertTrue((this._statsHandler.getRequestTimeTotal() >= 20L ? 1 : 0) != 0);
        Assert.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assert.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeTotal() >= 10L ? 1 : 0) != 0);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeTotal() < this._statsHandler.getRequestTimeTotal() ? 1 : 0) != 0);
        Assert.assertEquals((long)this._statsHandler.getDispatchedTimeTotal(), (long)this._statsHandler.getDispatchedTimeMax());
        Assert.assertEquals((double)this._statsHandler.getDispatchedTimeTotal(), (double)this._statsHandler.getDispatchedTimeMean(), (double)0.01);
    }

    private static class LatchHandler
    extends HandlerWrapper {
        private volatile CountDownLatch _latch = new CountDownLatch(1);

        private LatchHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            CountDownLatch latch = this._latch;
            try {
                super.handle(path, request, httpRequest, httpResponse);
            }
            finally {
                latch.countDown();
            }
        }

        private void reset() {
            this._latch = new CountDownLatch(1);
        }

        private void reset(int count) {
            this._latch = new CountDownLatch(count);
        }

        private boolean await(long ms) throws InterruptedException {
            return this._latch.await(ms, TimeUnit.MILLISECONDS);
        }
    }
}

