/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.File;
import junit.framework.Assert;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HashSessionManagerTest {
    @After
    public void enableStacks() {
        this.enableStacks(true);
    }

    @Before
    public void quietStacks() {
        this.enableStacks(false);
    }

    protected void enableStacks(boolean enabled) {
        StdErrLog log = (StdErrLog)Log.getLogger((String)"org.eclipse.jetty.server.session");
        log.setHideStacks(!enabled);
    }

    @Test
    public void testDangerousSessionIdRemoval() throws Exception {
        HashSessionManager manager = new HashSessionManager();
        manager.setDeleteUnrestorableSessions(true);
        manager.setLazyLoad(true);
        File testDir = MavenTestingUtils.getTargetTestingDir((String)"hashes");
        testDir.mkdirs();
        manager.setStoreDirectory(testDir);
        MavenTestingUtils.getTargetFile((String)"dangerFile.session").createNewFile();
        Assert.assertTrue((String)"File should exist!", (boolean)MavenTestingUtils.getTargetFile((String)"dangerFile.session").exists());
        manager.getSession("../../dangerFile.session");
        Assert.assertTrue((String)"File should exist!", (boolean)MavenTestingUtils.getTargetFile((String)"dangerFile.session").exists());
    }

    @Test
    public void testValidSessionIdRemoval() throws Exception {
        HashSessionManager manager = new HashSessionManager();
        manager.setDeleteUnrestorableSessions(true);
        manager.setLazyLoad(true);
        File testDir = MavenTestingUtils.getTargetTestingDir((String)"hashes");
        testDir.mkdirs();
        manager.setStoreDirectory(testDir);
        new File(testDir, "validFile.session").createNewFile();
        Assert.assertTrue((String)"File should exist!", (boolean)new File(testDir, "validFile.session").exists());
        manager.getSession("validFile.session");
        Assert.assertTrue((String)"File shouldn't exist!", (!new File(testDir, "validFile.session").exists() ? 1 : 0) != 0);
    }
}

